-- Step 0: Create all necessary fetch tables if they do not exist

-- Create etpfetrq (FRQ) table
CREATE TABLE IF NOT EXISTS etpfetrq (
    OID BIGSERIAL PRIMARY KEY,
    TemplateNumber BIGINT,
    DBTableName VARCHAR(20),
    UserName VARCHAR(20),
    ImportID VARCHAR(20),
    ACode VARCHAR(100)
);

-- Create etpfetrt (FRT) table
CREATE TABLE IF NOT EXISTS etpfetrt (
    OID BIGINT PRIMARY KEY,
    TemplateNumber BIGINT,
    DBTableName VARCHAR(20),
    UserName VARCHAR(20),
    ImportID VARCHAR(20),
    GuestBook BIGINT,
    DateStamp BIGINT,
    TStamp BIGINT,
    ReturnOKA VARCHAR(100),
    ReturnOKB VARCHAR(100),
    ACode VARCHAR(100),
    DataFieldNumber SMALLINT,
    DataFieldName VARCHAR(40),
    DataValue TEXT
);

-- Create Source_Seq_Map table
CREATE TABLE IF NOT EXISTS Source_Seq_Map (
    ImportID VARCHAR(20) PRIMARY KEY,
    SourceID BIGINT  -- Adjust based on your unique source column type
);

-- Create ETPProHd table (if required for header data)
CREATE TABLE IF NOT EXISTS ETPProHd (
    TemplateNumber BIGINT,
    DBTableName VARCHAR(20),
    UniqueSourceColumn VARCHAR(40),
    UserName VARCHAR(20)
);

-- Create ETPProFM table (Field Mapping)
CREATE TABLE IF NOT EXISTS ETPProFM (
    FieldNumber SMALLINT,
    FieldName VARCHAR(40),
    TemplateNumber BIGINT
);
