:: Step 1: Copy PAC data to FRQ for fetch requests
:: Step 1: Insert Protection Requests (ETPProRq) into SQL Table
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\Fetch
set LOG_PATH=C:\ETP_A_26\Logs

:: Ensure the FBatch1.sql exists before running
IF NOT EXIST "%SQL_PATH%\FBatch1.sql" (
    echo FBatch1.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute FBatch1.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch1.sql" > "%LOG_PATH%\FBatch1.log" 2>&1

:: Handle errors::
if %ERRORLEVEL% neq 0 (
    echo Error in FBatch1.sql. Check log at %LOG_PATH%\FBatch1.log for details.
    pause
    exit /b 1
)

:: Success message and pause
echo Successful completion of FBatch1.sql. Check log at %LOG_PATH%\FBatch1.log for output details.
::pause



