:: FBatch4.bat
@echo off
setlocal

:: Define SQL credentials
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set BASE_DIR=C:\ETP_A_26
set SQL_PATH=%BASE_DIR%\Fetch
set LOG_PATH=%BASE_DIR%\Logs

:: Ensure ETPFet.exe exists
IF NOT EXIST "%BASE_DIR%\ETPFet.exe" (
    echo ETPFet.exe not found at %BASE_DIR%. Exiting...
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO public.etp_log (log_time, log_message) VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch4: Error - ETPFet.exe not found at %BASE_DIR%');" >nul 2>&1
    pause
    exit /b 1
)

:: Log start to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO public.etp_log (log_time, log_message) VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch4: Started running ETPFet.exe with ETPFetRq.xml');" > "%LOG_PATH%\FBatch4.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Failed to log start to etp_log. Check %LOG_PATH%\FBatch4.log.
    pause
    exit /b 1
)

:: Change to working directory
cd /d %BASE_DIR%

:: Run the CTP Fetch Engine 250723 SQL
ETPFet.exe /SQL >> "%LOG_PATH%\FBatch4.log" 2>&1
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO public.etp_log (log_time, log_message) VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch4: Error - Fetch process failed with ETPFet.exe');" >> "%LOG_PATH%\FBatch4.log" 2>&1
    echo [ERROR] Fetch process failed. Check %LOG_PATH%\FBatch4.log.
    pause
    exit /b 1
)

:: Log success to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO public.etp_log (log_time, log_message) VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml');" >> "%LOG_PATH%\FBatch4.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Failed to log success to etp_log. Check %LOG_PATH%\FBatch4.log.
    pause
    exit /b 1
)

:: Return to SQL script path
cd /d %SQL_PATH%
echo [INFO] Step 4 completed: Fetch process ran successfully. Check %LOG_PATH%\FBatch4.log.

:: Optional pause for debug
:: pause

endlocal
