@echo off
:: Set environment variables
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\Fetch
set LOG_PATH=C:\ETP_A_26\Logs
:: Step 5.1: Wait for etpfetrt.xml to be ready (Fetch Process)
SET FRT_XML_PATH=C:\ETP_A_26\etpfetrt.xml

:: Log start to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Started parsing ETPFetRt.xml into etpfetrt');" >nul 2>&1

:WAIT_FOR_FRT_XML
IF EXIST "%FRT_XML_PATH%" (
    ECHO Fetch XML file found: %FRT_XML_PATH%
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Found ETPFetRt.xml at %FRT_XML_PATH%');" >nul 2>&1
    GOTO PROCESS_FRT
) ELSE (
    ECHO Waiting for Fetch XML file...
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Waiting for ETPFetRt.xml');" >nul 2>&1
    TIMEOUT /T 5 >NUL
    GOTO WAIT_FOR_FRT_XML
)

:PROCESS_FRT
ECHO Proceeding to parse the fetch return XML...
:: Log parsing start to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Parsing ETPFetRt.xml');" >nul 2>&1
:: pause

:: Step 5.2: Run the SQL script to load the XML into etpfetrt (FRT)
:: Ensure the FBatch5.sql exists before running
IF NOT EXIST "%SQL_PATH%\FBatch5.sql" (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Error - FBatch5.sql not found at %SQL_PATH%');" >nul 2>&1
    echo FBatch5.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute FBatch5.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch5.sql" > "%LOG_PATH%\FBatch5.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Error in FBatch5.sql - Check %LOG_PATH%\FBatch5.log');" >nul 2>&1
    echo Error in FBatch5.sql. Check log at %LOG_PATH%\FBatch5.log for details.
    pause
    exit /b 1
)

:: Log success to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch5: Successfully loaded ETPFetRt.xml into etpfetrt');" >nul 2>&1

:: Success message and pause
echo Successful completion of FBatch5.sql. Check log at %LOG_PATH%\FBatch5.log for output details.
:: pause