@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\Fetch
set LOG_PATH=C:\ETP_A_26\Logs

:: Log start to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch6: Started updating source records from etpfetrt using etpprofm');" >nul 2>&1

:: Ensure the FBatch6.sql exists before running
IF NOT EXIST "%SQL_PATH%\FBatch6.sql" (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch6: Error - FBatch6.sql not found at %SQL_PATH%');" >nul 2>&1
    echo FBatch6.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute FBatch6.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch6.sql" > "%LOG_PATH%\FBatch6.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch6: Error in FBatch6.sql - Check %LOG_PATH%\FBatch6.log');" >nul 2>&1
    echo Error in FBatch6.sql. Check log at %LOG_PATH%\FBatch6.log for details.
    pause
    exit /b 1
)

:: Log success to etp_log
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'FBatch6: Successfully updated source records from etpfetrt');" >nul 2>&1

:: Success message and pause
echo Successful completion of FBatch6.sql. Check log at %LOG_PATH%\FBatch6.log for output details.
pause