-- FBatch6.sql
-- Purpose: Update source records from etpfetrt using etpprofm mapping, log results
-- Version: v250725a

-- Log start
INSERT INTO public.etp_log (log_time, log_message)
VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch6: Starting update of source records from etpfetrt using etpprofm');

DO $$
DECLARE
    record_row RECORD;
    field_name TEXT;
    update_stmt TEXT;
    unique_column TEXT;
    source_table TEXT;
    rec_count INT;
BEGIN
    -- Get the unique source column and source table name
    SELECT UniqueSourceColumn, DBTableName INTO unique_column, source_table
    FROM public.etpprohd
    LIMIT 1;

    -- Log number of matching records
    SELECT COUNT(*) INTO rec_count
    FROM public.etpfetrt r
    JOIN public.etpprofm f
      ON r.templatenumber = f.templatenumber
     AND r.datafieldname = CONCAT('D', f.datafieldnumber)
    WHERE r.acode IS NOT NULL;
    INSERT INTO public.etp_log (log_time, log_message)
    VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch6: Found ' || rec_count || ' matching records in etpfetrt and etpprofm');

    -- Loop through each return record
    FOR record_row IN 
        SELECT r.importid, r.datafieldname, f.datafieldname AS resolved_fieldname, r.datavalue, r.acode
        FROM public.etpfetrt r
        JOIN public.etpprofm f
          ON r.templatenumber = f.templatenumber
         AND r.datafieldname = CONCAT('D', f.datafieldnumber)
        WHERE r.acode IS NOT NULL
    LOOP
        -- Build update statement dynamically using resolved field_name
        update_stmt := format(
            'UPDATE %I SET %I = %L WHERE %I = %L',
            source_table,
            record_row.resolved_fieldname,
            record_row.datavalue,
            unique_column,
            record_row.importid
        );

        -- Log update statement
        INSERT INTO public.etp_log (log_time, log_message)
        VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch6: Executing: ' || update_stmt);

        -- Execute the dynamic update
        EXECUTE update_stmt;
    END LOOP;

    -- Log completion of updates
    INSERT INTO public.etp_log (log_time, log_message)
    VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch6: Source table updated using etpfetrt records with mapped field names');
END $$;

-- Log completion
INSERT INTO public.etp_log (log_time, log_message)
VALUES (TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD HH24:MI:SS'), 'FBatch6: Completed successfully');
