@echo off
setlocal enabledelayedexpansion
:: PostgreSQL connection settings
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432

setlocal enabledelayedexpansion

:: ---------------------------------------------------
:: StartFetchBatch.bat
:: Full Fetch Process (FBatch1 to FBatch6)
:: Including ETPParam Setup and Logging
:: ---------------------------------------------------

:: Define working paths
set BASE_DIR=C:\ETP_A_26
set SQL_PATH=%BASE_DIR%\FBatch
set LOG_DIR=%BASE_DIR%\Logs

:: Create log folder if it doesn't exist
if not exist "%LOG_DIR%" mkdir "%LOG_DIR%"

:: Generate timestamped log filename
for /f %%i in ('wmic os get localdatetime ^| find "."') do set DTS=%%i
set DTS=%DTS:~0,8%_%DTS:~8,6%
set LOG_FILE=%LOG_DIR%\FetchLog_%DTS%.log

echo Logging to: %LOG_FILE%
echo ----------------------------------------------- >> "%LOG_FILE%"
echo Fetch Process Log - %DATE% %TIME% >> "%LOG_FILE%"
echo ----------------------------------------------- >> "%LOG_FILE%"

cd /d %SQL_PATH%

:: Prompt for ImportID range
set /p MINID=Enter minimum ImportID [default=0]: 
if "%MINID%"=="" set MINID=0

set /p MAXID=Enter maximum ImportID [default=999999999]: 
if "%MAXID%"=="" set MAXID=999999999

echo Using ImportID range: %MINID% to %MAXID%
echo Using ImportID range: %MINID% to %MAXID% >> "%LOG_FILE%"

:: Step 0: Populate ETPParam
echo [STEP 0] Inserting parameters...
echo [STEP 0] Inserting parameters... >> "%LOG_FILE%"
psql -U postgres -d postgres -c "TRUNCATE TABLE etpparam;" >> "%LOG_FILE%" 2>&1
psql -U postgres -d postgres -c "INSERT INTO etpparam (oid, batch_oid, min_id, max_id) VALUES (1, 1, %MINID%, %MAXID%);" >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Parameter setup failed. See log: %LOG_FILE%
    pause
    exit /b 1
)
pause

:: Step 1
echo [STEP 1] Running FBatch1.sql...
echo [STEP 1] Running FBatch1.sql... >> "%LOG_FILE%"
psql -U postgres -d postgres -f FBatch1.sql >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 1 failed.
    pause
    exit /b 1
)
pause

:: Step 2
echo [STEP 2] Running FBatch2.sql...
echo [STEP 2] Running FBatch2.sql... >> "%LOG_FILE%"
psql -U postgres -d postgres -f FBatch2.sql >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 2 failed.
    pause
    exit /b 1
)
pause

:: Step 3
echo [STEP 3] Running FBatch3.sql...
echo [STEP 3] Running FBatch3.sql... >> "%LOG_FILE%"
psql -U postgres -d postgres -f FBatch3.sql >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 3 failed.
    pause
    exit /b 1
)
pause

:: Step 4
echo [STEP 4] Running FBatch4.bat...
echo [STEP 4] Running FBatch4.bat... >> "%LOG_FILE%"
call FBatch4.bat >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 4 failed.
    pause
    exit /b 1
)
pause

:: Step 5
echo [STEP 5] Running FBatch5.sql...
echo [STEP 5] Running FBatch5.sql... >> "%LOG_FILE%"
psql -U postgres -d postgres -f FBatch5.sql >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 5 failed.
    pause
    exit /b 1
)
pause

:: Step 6
echo [STEP 6] Running FBatch6.sql...
echo [STEP 6] Running FBatch6.sql... >> "%LOG_FILE%"
psql -U postgres -d postgres -f FBatch6.sql >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo [ERROR] Step 6 failed.
    pause
    exit /b 1
)
pause

echo ----------------------------------------------- >> "%LOG_FILE%"
echo [SUCCESS] Fetch process completed at %TIME% >> "%LOG_FILE%"
echo ----------------------------------------------- >> "%LOG_FILE%"

echo [DONE] Fetch process completed.
echo Log file saved to: %LOG_FILE%

endlocal
