@echo off
:: Set PostgreSQL environment variables
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\Fetch
set LOG_PATH=C:\ETP_A_26\Logs

:: Log start
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Started fetch process');" >nul 2>&1

:: Debugging output for variables
echo PGUSER=%PGUSER%
echo PGPASSWORD=%PGPASSWORD%
echo PGDATABASE=%PGDATABASE%
echo PGHOST=%PGHOST%
echo SQL_PATH=%SQL_PATH%

:: Step 1: Run FBatch1.bat (copy etpproac to etpfetrq, initialize etpfetbt)
echo Running Step 1: Inserting data...
call "%SQL_PATH%\FBatch1.bat"
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Error in FBatch1.bat');" >nul 2>&1
    echo Error in Step 1: Inserting data. Exiting process.
    pause
    exit /b 1
)
echo Completed Step 1
::pause

:: Step 2: Skipped (FBatch2 removed)

:: Step 3: Skipped (FBatch3 removed, no XML)

:: Step 4: Run FBatch4.bat (call ETPFet.exe /SQL)
echo Running Step 4: Calling CTP Fetch Engine...
call "%SQL_PATH%\FBatch4.bat"
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Error in FBatch4.bat');" >nul 2>&1
    echo Error in Step 4: CTP fetch process. Exiting process.
    pause
    exit /b 1
)
echo Fetch process completed successfully.
::pause

:: Step 5: Run FBatch5.sql (poll etpfetrt, update etpfetbt)
echo Running Step 5: Loading Fetch Response into etpfetbt...
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch5.sql"
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Error in FBatch5.sql');" >nul 2>&1
    echo Error in Step 5: Loading fetch response. Exiting process.
    pause
    exit /b 1
)
echo Fetch response successfully loaded into etpfetbt.
::pause

:: Step 6: Run FBatch6.sql (dynamic field updates using etpprofm)
echo Running Step 6: Dynamic Field Updates using Sequence Map...
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch6.sql"
if %ERRORLEVEL% neq 0 (
    psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Error in FBatch6.sql');" >nul 2>&1
    echo Error in Step 6: Dynamic field updates. Exiting process.
    pause
    exit /b 1
)
echo Dynamic field updates completed successfully.
::pause

:: Log completion
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (CURRENT_TIMESTAMP, 'MasterBatchF: Fetch process completed successfully');" >nul 2>&1
echo MasterBatchF completed successfully.
::pause