@echo off
:: Set PostgreSQL environment variables once in the master batch file
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\Fetch

:: Debugging output for variables
echo PGUSER=%PGUSER%
echo PGPASSWORD=%PGPASSWORD%
echo PGDATABASE=%PGDATABASE%
echo PGHOST=%PGHOST%
echo SQL_PATH=%SQL_PATH%

:: Start with Step 1: Run FBatch1.bat
echo Running Step 1: Inserting data...
call "%SQL_PATH%\FBatch1.bat"
echo Completed Step 1
if %ERRORLEVEL% neq 0 (
    echo Error in Step 1: Inserting data. Exiting process.
    pause
    exit /b 1
)
pause

:: Step 2: Run FBatch2.bat (ensure Source_Seq_Map is created)
echo Running Step 2: Creating Source_Seq_Map...
call "%SQL_PATH%\FBatch2.bat"
echo Completed Step 2
if %ERRORLEVEL% neq 0 (
    echo Error in Step 2: Creating Source_Seq_Map. Exiting process.
    pause
    exit /b 1
)
pause

:: Step 3: Continue the process for further steps
echo Running Step 3: ...
call "%SQL_PATH%\FBatch3.bat"
echo Completed Step 3
if %ERRORLEVEL% neq 0 (
    echo Error in Step 3: Processing. Exiting process.
    pause
    exit /b 1
)
pause

:: Step 4: Call CTP Fetch Engine (ETPFtch.exe)
echo Running Step 4: Calling CTP Fetch Engine...
CD C:\ETP_A_26
cmd /c "ETPFtch.exe /XML"
if %ERRORLEVEL% neq 0 (
    echo Error during CTP fetch process. Exiting process.
    pause
    exit /b 1
)
echo Fetch process completed successfully.
pause

:: Step 5: Load fetch response into FRT table and ensure a clean slate
echo Running Step 5: Loading Fetch Response into FRT Table...
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch5.sql"
if %ERRORLEVEL% neq 0 (
    echo Error loading fetch response into FRT table. Exiting process.
    pause
    exit /b 1
)
echo Fetch response successfully loaded into FRT table.
pause

:: Step 6: Use the ETPProFM to map field names and update the source table dynamically
echo Running Step 6: Dynamic Field Updates using Sequence Map...
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\FBatch6.sql"
if %ERRORLEVEL% neq 0 (
    echo Error in dynamic field updates. Exiting process.
    pause
    exit /b 1
)
echo Dynamic field updates completed successfully.
pause
