-- AttachInsertPRQTrigger_Auto.sql
-- Drops and re-creates the trigger on the correct source table dynamically

DO $$
DECLARE
    tbl TEXT;
BEGIN
    SELECT DBTableName INTO tbl FROM ETPProHd LIMIT 1;

    -- Drop existing trigger if present
    EXECUTE format('DROP TRIGGER IF EXISTS insert_prq_trigger ON %I;', tbl);

    -- Create new trigger bound to the dynamic table
    EXECUTE format('CREATE TRIGGER insert_prq_trigger AFTER INSERT ON %I FOR EACH ROW EXECUTE FUNCTION trigger_insert_prq();', tbl);
END $$;