@echo off
setlocal

:: Define SQL credentials
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Set search_path for psql
set PGOPTIONS=-c search_path=public

:: Log current directory
cd > "%LOG_PATH%\current_dir.log"

:: Log psql version
psql --version > "%LOG_PATH%\psql_version.log" 2>&1

:: Verify SQL file exists
if not exist "%SQL_PATH%\AuditTriggers.sql" (
    echo Error: AuditTriggers.sql not found in %SQL_PATH% >> "%LOG_PATH%\audit_log.txt"
    exit /b 1
)

:: Apply AuditTriggers.sql
psql -U %PGUSER% -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -f "%SQL_PATH%\AuditTriggers.sql" > "%LOG_PATH%\sql_apply.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo Error applying AuditTriggers.sql. Check %LOG_PATH%\sql_apply.log >> "%LOG_PATH%\audit_log.txt"
    exit /b 1
)

:: Ensure audit_result.txt is clean
if exist "%LOG_PATH%\audit_result.txt" del "%LOG_PATH%\audit_result.txt"

:: Run audit SQL function
psql -U %PGUSER% -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -c "SELECT public.sendatrix_audit_triggers();" > "%LOG_PATH%\audit_result.txt" 2>&1
if %ERRORLEVEL% neq 0 (
    echo Error executing sendatrix_audit_triggers. Check %LOG_PATH%\audit_result.txt >> "%LOG_PATH%\audit_log.txt"
    exit /b 1
)

:: Log success
echo Audit completed at %DATE% %TIME%. Results in %LOG_PATH%\audit_result.txt >> "%LOG_PATH%\audit_log.txt"