:: BatchProc.bat
:: Purpose: Run all PBatch scripts for MBTIP workflow
:: Version: TriggerBuffered_v250716b, 2025-07-16
@echo off
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Log start
echo %DATE% %TIME% Starting BatchProc.bat... >> "%LOG_PATH%\BatchProc.log"

:: Create database tables (etp_log, etpprobt, etpprorq, etc.)
::call "%SQL_PATH%\PBatch0.bat"

:: Populate ETPProRq with request data from ETPProFM
call "%SQL_PATH%\PBatch1.bat"

:: Execute ETPProt.exe to populate ETPProRt
call "%SQL_PATH%\PBatch3.bat"

:: Wait for ETPProRt population and update ETPProBt
call "%SQL_PATH%\PBatch4.bat"

:: Populate ETPProTp with masking rules from ETPProHd
:: call "%SQL_PATH%\PBatch6.bat" 250828 Now done at initiation

:: Update ETPProBt with completion time and status
call "%SQL_PATH%\PBatch7.bat"

:: Apply masking rules to sensitive fields in source table
call "%SQL_PATH%\PBatch8.bat"

:: Populate ETPProAC from ETPProRt results
call "%SQL_PATH%\PBatch9.bat"

:: Log completion
echo %DATE% %TIME% BatchProc.bat completed successfully. >> "%LOG_PATH%\BatchProc.log"