-- ClaimBatch_ReturnBatchNumber.sql (v251005a):
-- Purpose: Atomically claims the oldest 'Ready' batch by updating its status to 'Processing',
--          sets the StartTime to now, and returns ONLY the batchnumber (no command tag).
-- Logic: Uses a CTE for selection, UPDATE RETURNING for atomic claim, and wraps in DO $$ 
--        with a final SELECT to output cleanly (avoids psql's "UPDATE n" tag).
-- Output: Solely the batchnumber (or empty if none found)—no extra lines for simpler batch parsing.

DO $$
DECLARE
    claimed_batchnumber BIGINT;
BEGIN
    WITH next_batch AS (  -- Step 1: Identify the oldest 'Ready' batch by OID
        SELECT oid 
        FROM etpprobt
        WHERE status = 'Ready'
        ORDER BY oid ASC  -- FIFO ordering
        LIMIT 1
    )
    UPDATE etpprobt       -- Step 2: Claim it atomically
    SET status = 'Processing', 
        StartTime = CURRENT_TIMESTAMP
    WHERE oid IN (SELECT oid FROM next_batch)
    RETURNING batchnumber INTO claimed_batchnumber;  -- Capture the returned value
    
    -- Step 3: Output only the batchnumber via SELECT (no command tag)
    SELECT claimed_batchnumber;
END $$;