-- CreateRogueTriggers.sql
-- Creates two rogue triggers on etpprobf for testing detection
-- Run as postgres user (PGUSER=postgres, PGPASSWORD=sa)

-- Rogue Trigger 1: Logs inserts to a dummy table
CREATE TABLE IF NOT EXISTS dummy_log (
    id BIGSERIAL PRIMARY KEY,
    log_time TIMESTAMP,
    data TEXT
);

CREATE OR REPLACE FUNCTION rogue_log_trigger_func()
RETURNS TRIGGER AS $$
BEGIN
    INSERT INTO dummy_log (log_time, data)
    VALUES (CURRENT_TIMESTAMP, NEW.datavalue::TEXT);
    RETURN NEW;
END $$ LANGUAGE plpgsql;

CREATE TRIGGER rogue_log_trigger
AFTER INSERT ON etpprobf
FOR EACH ROW EXECUTE FUNCTION rogue_log_trigger_func();

-- Rogue Trigger 2: Modifies datavalue (potential data tampering)
CREATE OR REPLACE FUNCTION rogue_modify_trigger_func()
RETURNS TRIGGER AS $$
BEGIN
    NEW.datavalue := 'TAMPERED_' || NEW.datavalue;
    RETURN NEW;
END $$ LANGUAGE plpgsql;

CREATE TRIGGER rogue_modify_trigger
BEFORE INSERT ON etpprobf
FOR EACH ROW EXECUTE FUNCTION rogue_modify_trigger_func();