-- Step 1: Create the role if it does not exist
DO $$
BEGIN
    IF NOT EXISTS (
        SELECT 1 FROM pg_roles WHERE rolname = 'dataentry_role'
    ) THEN
        CREATE ROLE dataentry_role;
        RAISE NOTICE 'Role "dataentry_role" created.';
    ELSE
        RAISE NOTICE 'Role "dataentry_role" already exists.';
    END IF;
END $$;

-- Step 2: Grant schema-level usage (optional depending on structure)
GRANT USAGE ON SCHEMA public TO dataentry_role;

-- Step 3: Grant SELECT privilege to the source table (non-destructive access)
DO $$
DECLARE
    src_table TEXT;
BEGIN
    SELECT DBTableName INTO src_table FROM ETPProHd LIMIT 1;

    -- SELECT is allowed at all times
    EXECUTE format('GRANT SELECT ON %I TO dataentry_role', src_table);
END $$;