-- DisableTriggerMode.sql
DO $$ 
DECLARE
    src_table TEXT;
BEGIN
    SELECT DBTableName INTO src_table FROM ETPProHd LIMIT 1;

    EXECUTE format('ALTER TABLE %I DISABLE TRIGGER insert_prq_trigger', src_table);
    EXECUTE format('REVOKE INSERT ON %I FROM dataentry_role', src_table);

    INSERT INTO ETPConfig (option_name, option_value)
    VALUES ('TriggerEnabled', 'false')
    ON CONFLICT (option_name) DO UPDATE SET option_value = 'false';

    RAISE NOTICE 'Trigger disabled and INSERT revoked on table: %', src_table;
END $$;