:: EnableTriggerMode.bat
@echo off
setlocal

echo ----------------------------------
echo Enabling Trigger Mode
echo ----------------------------------

:: Set database connection variables
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Ensure log path exists
IF NOT EXIST "%LOG_PATH%" (
    mkdir "%LOG_PATH%"
)

:: Step 1: Reset PRQ environment BEFORE enabling trigger
echo Resetting PRQ environment...
call "%SQL_PATH%\ResetETPPro.bat"

:: Step 2: Enable the trigger
echo Enabling trigger...
psql -U %PGUSER% -h %PGHOST% -d %PGDATABASE% -f "%SQL_PATH%\EnableTriggerMode.sql" > "%LOG_PATH%\EnableTriggerMode.log" 2>&1

IF %ERRORLEVEL% NEQ 0 (
    echo [EnableTriggerMode] ERROR! See log at %LOG_PATH%\EnableTriggerMode.log
    pause
    exit /b 1
)

echo [EnableTriggerMode] Trigger enabled and permission granted.
echo ----------------------------------
echo Environment ready for inserting new source records!
echo ----------------------------------
endlocal
pause
