-- EnableTriggerMode.sql
DO $$ 
DECLARE
    src_table TEXT;
BEGIN
    SELECT DBTableName INTO src_table FROM ETPProHd LIMIT 1;

    EXECUTE format('ALTER TABLE %I ENABLE TRIGGER insert_prq_trigger', src_table);
    EXECUTE format('GRANT INSERT ON %I TO dataentry_role', src_table);

    INSERT INTO ETPConfig (option_name, option_value)
    VALUES ('TriggerEnabled', 'true')
    ON CONFLICT (option_name) DO UPDATE SET option_value = 'true';

    RAISE NOTICE 'Trigger enabled and INSERT granted on table: %', src_table;
END $$;