@echo off
:: Batch file to rename XML files with YRMODY and time format

:: Set the directory where the XML files are located
set FILE_PATH=.

:: Get the current date and time in YRMODY format (e.g., 241014_1420)
for /f "tokens=2 delims==" %%I in ('wmic os get localdatetime /value') do set datetime=%%I
set DATE=%datetime:~0,8%
set TIME=%datetime:~8,4%
set TIMESTAMP=%DATE:~2,6%_%TIME%

:: List of files to rename
set FILES=etpprorq.xml etpprort.xml etpfetrq.xml etpfetrt.xml

:: Loop through each file and rename it with the timestamp
for %%F in (%FILES%) do (
    if exist "%FILE_PATH%\%%F" (
        rename "%FILE_PATH%\%%F" "%%~nF_%TIMESTAMP%.xml"
        echo Renamed %%F to %%~nF_%TIMESTAMP%.xml
    ) else (
        echo File %%F not found, skipping.
    )
)

echo All files renamed (if found).
::pause
