-- Simplified pbatch0.sql – only creates tables with IDENTITY oids
-- No conversion logic, no ALTER attempts, no sequence removal.
-- Safe to run multiple times (IF NOT EXISTS on all tables).

SET search_path = public;

-- etp_log
CREATE TABLE IF NOT EXISTS public.etp_log (
    logoid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    log_time character varying(30) NOT NULL,
    log_message character varying(999) NOT NULL
);
ALTER TABLE IF EXISTS public.etp_log OWNER TO postgres;

-- etpconfig
CREATE TABLE IF NOT EXISTS public.etpconfig (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    option_name text,
    option_value text
);
ALTER TABLE IF EXISTS public.etpconfig OWNER TO postgres;

-- etpfetbt
CREATE TABLE IF NOT EXISTS public.etpfetbt (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    batchnumber bigint NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    recordcount bigint NOT NULL,
    starttime character varying(19) NOT NULL,
    endtime character varying(19),
    executiontime character varying(19),
    status character varying(20) NOT NULL,
    notes text
);
ALTER TABLE IF EXISTS public.etpfetbt OWNER TO postgres;

-- etpfetrq
CREATE TABLE IF NOT EXISTS public.etpfetrq (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    templatenumber bigint,
    dbtablename character varying(20),
    username character varying(20),
    importid character varying(20),
    acode character varying(100)
);
ALTER TABLE IF EXISTS public.etpfetrq OWNER TO postgres;

-- etpfetrt
CREATE TABLE IF NOT EXISTS public.etpfetrt (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    templatenumber bigint,
    dbtablename character varying(20),
    username character varying(20),
    importid character varying(20),
    guestbook bigint,
    datestamp bigint,
    tstamp bigint,
    returnoka character varying(100),
    returnokb character varying(100),
    acode character varying(100),
    datafieldnumber smallint,
    datafieldname character varying(40),
    datavalue text
);
ALTER TABLE IF EXISTS public.etpfetrt OWNER TO postgres;

-- etppaclog
CREATE TABLE IF NOT EXISTS public.etppaclog (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    log_date bigint,
    log_time bigint,
    guestbook bigint,
    batchnumber bigint,
    importid character varying(50),
    status character varying(20) DEFAULT 'Pending'
);
ALTER TABLE IF EXISTS public.etppaclog OWNER TO postgres;

-- etpparam
CREATE TABLE IF NOT EXISTS public.etpparam (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    batch_oid bigint,
    min_id bigint,
    max_id bigint,
    min_gb bigint,
    max_gb bigint
);
ALTER TABLE IF EXISTS public.etpparam OWNER TO postgres;

-- etpproac
CREATE TABLE IF NOT EXISTS public.etpproac (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    importid character varying(20) NOT NULL,
    acode character varying(100) NOT NULL,
    guestbook bigint,
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20)
);
ALTER TABLE IF EXISTS public.etpproac OWNER TO postgres;

-- etpprobf
CREATE TABLE IF NOT EXISTS public.etpprobf (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(40) NOT NULL,
    importid character varying(20) NOT NULL,
    datafieldnumber smallint NOT NULL,
    datafieldname character varying(40) NOT NULL,
    datavalue text
);
ALTER TABLE IF EXISTS public.etpprobf OWNER TO postgres;

-- etpprobt
CREATE TABLE IF NOT EXISTS public.etpprobt (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    batchnumber bigint NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    recordcount bigint NOT NULL,
    starttime character varying(30) NOT NULL,
    endtime character varying(30),
    executiontime character varying(30),
    status character varying(20) NOT NULL,
    notes text
);
ALTER TABLE IF EXISTS public.etpprobt OWNER TO postgres;

-- etpprofm
CREATE TABLE IF NOT EXISTS public.etpprofm (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    templatenumber bigint NOT NULL,
    datafieldname character varying(40) NOT NULL,
    datafieldnumber smallint NOT NULL
);
ALTER TABLE IF EXISTS public.etpprofm OWNER TO postgres;

-- etpprohd
CREATE TABLE IF NOT EXISTS public.etpprohd (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    location character varying(20) NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    uniquesourcecolumn character varying(40) NOT NULL,
    gencrypt smallint DEFAULT 0
);
ALTER TABLE IF EXISTS public.etpprohd OWNER TO postgres;

-- etpprorq
CREATE TABLE IF NOT EXISTS public.etpprorq (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20),
    importid character varying(20),
    datafieldnumber smallint,
    datafieldname character varying(40),
    datavalue text
);
ALTER TABLE IF EXISTS public.etpprorq OWNER TO postgres;

-- etpprort
CREATE TABLE IF NOT EXISTS public.etpprort (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    templatenumber bigint NOT NULL,
    dbtablename character varying(20) NOT NULL,
    username character varying(20) NOT NULL,
    importid character varying(20) NOT NULL,
    guestbook bigint,
    acode character varying(100),
    actiontype character(1),
    returnoka character varying(100),
    returnokb character varying(100),
    datestamp bigint,
    tstamp bigint
);
ALTER TABLE IF EXISTS public.etpprort OWNER TO postgres;

-- etpprosr
CREATE TABLE IF NOT EXISTS public.etpprosr (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20),
    importid character varying(20)
);
ALTER TABLE IF EXISTS public.etpprosr OWNER TO postgres;

-- etpprotp
CREATE TABLE IF NOT EXISTS public.etpprotp (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    templatenumber bigint NOT NULL,
    fieldname character varying(40) NOT NULL,
    fieldnumber smallint NOT NULL,
    masktype character varying(20) NOT NULL
);
ALTER TABLE IF EXISTS public.etpprotp OWNER TO postgres;

-- End of simplified installer

-- patients
CREATE TABLE IF NOT EXISTS public.patients (
    patient_id bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    first_name character varying(50) NOT NULL,
    last_name character varying(50) NOT NULL,
    birthdate date NOT NULL,
    gender character varying(10),
    ssn character varying(15) NOT NULL,
    address character varying(100),
    city character varying(50),
    state character varying(50),
    zip_code character varying(10),
    phone_number character varying(15),
    email character varying(100),
    emergency_contact_name character varying(50),
    emergency_contact_phone character varying(15),
    insurance_provider character varying(100),
    insurance_policy_number character varying(50),
    primary_physician character varying(100),
    medical_conditions text,
    medications text,
    allergies text,
    blood_type character varying(5),
    date_of_last_visit date,
    credit_card_number character varying(19),
    credit_card_expiry character varying(5),
    billing_address character varying(100),
    account_balance numeric(10,2),
    account_status character varying(20),
    driver_license_number character varying(20),
    passport_number character varying(20),
    marital_status character varying(20),
    ethnicity character varying(50),
    occupation character varying(100),
    employer_name character varying(100),
    employer_phone character varying(15),
    notes text
);
ALTER TABLE IF EXISTS public.patients OWNER TO postgres;

-- eccpend
CREATE TABLE IF NOT EXISTS public.eccpend (
    oid bigint GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    dateord bigint,
    etp_vendor_code character varying(22),
    etp_vault_number bigint,
    ecode numeric(4,0),
    response character varying(2000),
    ordernum bigint,
    status character varying(1),
    tid character varying(16),
    order_type character varying(1),
    transaction_type character varying(2),
    billing_name character varying(30),
    billing_first_name character varying(30),
    billing_last_name character varying(30),
    billing_zip character varying(9),
    billing_email character varying(255),
    cc_type character varying(20),
    cc_number character varying(19),
    ccexp_month character varying(2),
    ccexp_year character varying(4),
    cnp_recurring character varying(1),
    cnp_security character varying(4),
    counter character varying(10),
    grand_total character varying(10),
    product_description character varying(17),
    purchase_order_number character varying(17),
    sales_tax character varying(8),
    track1 character varying(76),
    track2 character varying(37)
);
ALTER TABLE IF EXISTS public.eccpend OWNER TO postgres;

-- Table: public.employees

-- DROP TABLE IF EXISTS public.employees;

CREATE TABLE IF NOT EXISTS public.employees
(
    employeenum numeric(7,0) NOT NULL,
    personcode numeric(7,0),
    lastname character varying(35) COLLATE pg_catalog."default" NOT NULL,
    firstname character varying(35) COLLATE pg_catalog."default" NOT NULL,
    middlename character varying(20) COLLATE pg_catalog."default",
    employeename character varying(40) COLLATE pg_catalog."default",
    searchname character varying(40) COLLATE pg_catalog."default",
    callname character varying(20) COLLATE pg_catalog."default",
    prefix character varying(8) COLLATE pg_catalog."default",
    suffix character varying(4) COLLATE pg_catalog."default",
    address1 character varying(30) COLLATE pg_catalog."default",
    address2 character varying(30) COLLATE pg_catalog."default",
    city character varying(30) COLLATE pg_catalog."default",
    state character varying(2) COLLATE pg_catalog."default",
    zip character varying(12) COLLATE pg_catalog."default",
    country character varying(3) COLLATE pg_catalog."default",
    county character varying(20) COLLATE pg_catalog."default",
    telephone character varying(15) COLLATE pg_catalog."default" NOT NULL,
    cellphone character varying(15) COLLATE pg_catalog."default",
    workphone character varying(15) COLLATE pg_catalog."default",
    email character varying(200) COLLATE pg_catalog."default" NOT NULL,
    sex character varying(1) COLLATE pg_catalog."default",
    marital character varying(1) COLLATE pg_catalog."default",
    race character varying(20) COLLATE pg_catalog."default",
    ethnicity character varying(20) COLLATE pg_catalog."default",
    education character varying(20) COLLATE pg_catalog."default",
    primarylanguage character varying(20) COLLATE pg_catalog."default",
    birthdate date,
    socsecno character varying(11) COLLATE pg_catalog."default",
    salary numeric(10,2),
    ratecode character varying(2) COLLATE pg_catalog."default",
    dlnumber character varying(20) COLLATE pg_catalog."default",
    sensitivedata character varying(255) COLLATE pg_catalog."default",
    hiredate date,
    dept character varying(3) COLLATE pg_catalog."default",
    outin character varying(3) COLLATE pg_catalog."default",
    CONSTRAINT employees_pkey PRIMARY KEY (employeenum),
    CONSTRAINT employees_email_key UNIQUE (email),
    CONSTRAINT employees_telephone_key UNIQUE (telephone)
);
ALTER TABLE IF EXISTS public.employees OWNER to postgres;

-- Triggers added

-- patients trigger
DROP TRIGGER IF EXISTS insert_prq_trigger ON public.patients;
CREATE OR REPLACE TRIGGER insert_prq_trigger
    AFTER INSERT ON public.patients
    FOR EACH ROW
    EXECUTE FUNCTION public.trigger_insert_prq();
ALTER TABLE public.patients DISABLE TRIGGER insert_prq_trigger;

-- eccpend trigger
DROP TRIGGER IF EXISTS insert_prq_trigger ON public.eccpend;
CREATE OR REPLACE TRIGGER insert_prq_trigger
    AFTER INSERT ON public.eccpend
    FOR EACH ROW
    EXECUTE FUNCTION public.trigger_insert_prq();
