:: PBatch1.bat
:: Populate Source_Seq_Map Dynamically Based on the Source Table
:: Update current_batch_oid in ETPParam table
:: Insert Protection Requests (ETPProRq) into SQL Table
:: Step 1: Insert Protection Requests (ETPProRq) into SQL Table

@echo off
:: Set environment variables
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Ensure the log path exists
if not exist "%LOG_PATH%" (
    mkdir "%LOG_PATH%"
)

:: Step 1: Insert Protection Requests (ETPProRq) into SQL Table
echo Running Protection Requests Batch 1...
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch1.sql" > "%LOG_PATH%\PBatch1.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo Error inserting protection requests. Check log at %LOG_PATH%\PBatch1.log for details.
    ::pause
    exit /b 1
)
echo Protection requests inserted successfully. Log available at %LOG_PATH%\PBatch1.log
::pause  :: ::pause here so you can see the output before it closes
