-- Step 2: Generate ETPProRq.XML File for CTP Engine
DO $$ 
DECLARE
    xml_content TEXT;
BEGIN
    -- Generate the XML content using XMLElement
    SELECT '<?xml version="1.0" encoding="ISO-8859-1"?>' || 
           XMLELEMENT(NAME "ETPProRq", 
               XMLAGG(
                   XMLELEMENT(NAME "record", 
                       XMLELEMENT(NAME "OID", COALESCE(CAST(OID AS TEXT), '')),
                       XMLELEMENT(NAME "GUESTBOOK", COALESCE(CAST(GuestBook AS TEXT), '')),
                       XMLELEMENT(NAME "LOCATION", COALESCE(Location, '')),
                       XMLELEMENT(NAME "TEMPLATENUMBER", COALESCE(CAST(TemplateNumber AS TEXT), '')),
                       XMLELEMENT(NAME "USERNAME", COALESCE(UserName, '')),
                       XMLELEMENT(NAME "DBTABLENAME", COALESCE(DBTableName, '')),
                       XMLELEMENT(NAME "IMPORTID", COALESCE(ImportID, '')),
                       XMLELEMENT(NAME "DATAFIELDNUMBER", COALESCE(CAST(DataFieldNumber AS TEXT), '')),
                       XMLELEMENT(NAME "DATAFIELDNAME", COALESCE(DataFieldName, '')),
                       XMLELEMENT(NAME "DATAVALUE", COALESCE(DataValue, ''))
                   )
               )
           )::TEXT
    INTO xml_content
    FROM ETPProRq;

    -- Check if there is any content generated
    IF xml_content IS NULL THEN
        RAISE NOTICE 'No data found in ETPProRq.';
    ELSE
        -- Create a temporary table to store the XML content
        CREATE TEMP TABLE temp_xml (xml_content TEXT);
        INSERT INTO temp_xml (xml_content) VALUES (xml_content);

        -- Use COPY to write the XML content to a file
        COPY (SELECT xml_content FROM temp_xml) TO 'C:\\ETP_A_25\\Show50KTst\\etpprorq.xml';
        -- Truncate the ETPProRq table to clear data after XML creation
        TRUNCATE TABLE ETPProRq;
        
        RAISE NOTICE 'ETPProRq table truncated after generating XML.';
    END IF;
END $$;


