:: PBatch3.bat
:: Purpose: Run ETPProt.exe to populate ETPProRt with etp_log logging
:: Version: TriggerBuffered_v250717c, 2025-07-17
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set CTP_PATH=C:\ETP_A_26
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Log start to etp_log and PBatch3.log
echo PBatch3.bat: Starting ETPProt.exe /SQL at %DATE% %TIME% >> "%LOG_PATH%\PBatch3.log"
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), 'PBatch3.bat: Starting ETPProRt population. StartTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'));" >> "%LOG_PATH%\PBatch3.log" 2>&1

:: Change to CTP directory and run ETPProt.exe
CD %CTP_PATH%
cmd /c "%CTP_PATH%\ETPProt.exe" /SQL >> "%LOG_PATH%\PBatch3.log" 2>&1

:: Log success to etp_log with row count
for /f %%i in ('psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -t -c "SELECT COUNT(*) FROM etpprort;"') do set ROW_COUNT=%%i
echo PBatch3.bat: ETPProRt population successful at %DATE% %TIME%. Populated %ROW_COUNT% records. >> "%LOG_PATH%\PBatch3.log"
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), 'PBatch3.bat: ETPProRt populated with ' || %ROW_COUNT% || ' records. EndTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS') || ', Elapsed: ' || TO_CHAR(NOW() - (SELECT log_time::TIMESTAMP FROM etp_log WHERE log_message LIKE 'PBatch3.bat: Starting%%' ORDER BY log_time DESC LIMIT 1), 'MI:SS'));" >> "%LOG_PATH%\PBatch3.log" 2>&1

:: Return to SQL directory
CD %SQL_PATH%

:: Success message
echo 3. CTP/ETP protection process completed successfully!