:: PBatch4.bat
:: Purpose: Executes PBatch4.sql to check ETPProRt
:: Version: TriggerBuffered_v250712b, 2025-07-12
@echo off
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs
set PSQL="C:\Program Files\PostgreSQL\16\bin\psql.exe"
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432

:: Ensure LOG_PATH exists
if not exist "%LOG_PATH%" mkdir "%LOG_PATH%"

:: Log start
echo %DATE% %TIME% Executing PBatch4.sql to check ETPProRt... >> "%LOG_PATH%\PBatch4.log"

:: Run PBatch4.sql
%PSQL% -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -f "%SQL_PATH%\PBatch4.sql" >> "%LOG_PATH%\PBatch4.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Error executing PBatch4.sql. Check %LOG_PATH%\PBatch4.log and etp_log table. Exiting. >> "%LOG_PATH%\PBatch4.log"
    pause
    exit /b 1
)

:: Success message
echo 4. PBatch4.sql executed successfully. Check %LOG_PATH%\PBatch4.log for details.
::pause