:: PBatch5.bat
:: Process Return XML (ETPProRt.xml) from CTP Engine
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs


:: Ensure the PBatch5.sql exists before running
IF NOT EXIST "%SQL_PATH%\PBatch5.sql" (
    echo PBatch5.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute PBatch5.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch5.sql" > "%LOG_PATH%\PBatch5.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    echo Error in PBatch5.sql. Check log at %LOG_PATH%\PBatch5.log for details.
    pause
    exit /b 1
)

:: Success message and pause
echo 5. Successful Process Return: XML (ETPProRt.xml) from CTP Engine. Check log at %LOG_PATH%\PBatch5.log for output details.

