-- PBatch5.sql
-- Process Return XML (ETPProRt.xml) from CTP Engine

DO $$
DECLARE
    xml_content TEXT;
BEGIN
    -- Try to read the XML file first
    SELECT pg_read_file('C:\\ETP_A_25\\Show50KTst\\etpprort.xml')
    INTO xml_content;

    -- Check if anything was read
    IF xml_content IS NULL OR length(trim(xml_content)) = 0 THEN
        RAISE NOTICE 'No data found in etpprort.xml. Skipping Return Processing.';
        RETURN;
    END IF;

    -- Truncate the ETPProRt table to clear any existing data
    TRUNCATE TABLE ETPProRt;

    -- Insert into the actual ETPProRt table by parsing the XML file
    INSERT INTO ETPProRt
    SELECT *
    FROM xmltable(
        '/ETPProRt/record'
        PASSING xmlparse(document xml_content)
        COLUMNS
            OID BIGINT PATH 'OID',
            TemplateNumber BIGINT PATH 'TEMPLATENUMBER',
            DBTableName TEXT PATH 'DBTABLENAME',
            UserName TEXT PATH 'USERNAME',
            ImportID TEXT PATH 'IMPORTID',
            GuestBook BIGINT PATH 'GUESTBOOK',
            ACode TEXT PATH 'ACODE',
            ActionType CHAR(1) PATH 'ACTIONTYPE',
            ReturnOKA TEXT PATH 'RETURNOKA',
            ReturnOKB TEXT PATH 'RETURNOKB',
            DateStamp BIGINT PATH 'DATESTAMP',
            TStamp BIGINT PATH 'TIMESTAMP'
    );

    RAISE NOTICE 'Data inserted into ETPProRt.';
END $$;
