:: Step 6: Populate ETPProTp table for masking logic
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\PBatch\Logs


:: Ensure the PBatch6.sql exists before running
IF NOT EXIST "%SQL_PATH%\PBatch6.sql" (
    echo PBatch6.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute PBatch6.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch6.sql" > "%LOG_PATH%\PBatch6.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    echo Error in PBatch6.sql. Check log at %LOG_PATH%\PBatch6.log for details.
    ::pause
    exit /b 1
)

:: Success message and ::pause
echo 6. Source field Template table (ETPProTp) populated successfully. Check log at %LOG_PATH%\PBatch6.log for output details.
::pause

