:: PBatch7.bat
:: Update Completion Time for ETPProBt Batch Record
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs


:: Ensure the PBatch7.sql exists before running
IF NOT EXIST "%SQL_PATH%\PBatch7.sql" (
    echo PBatch7.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute PBatch7.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch7.sql" > "%LOG_PATH%\PBatch7.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    echo Error in PBatch7.sql. Check log at %LOG_PATH%\PBatch7.log for details.
    ::pause
    exit /b 1
)

:: Success message and ::pause
echo 7. Update Completion Time for ETPProBt Batch Record successful. Check log at %LOG_PATH%\PBatch7.log for output details.


 ::pause
