:: PBatch8.bat
:: Mask Source Records  
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Ensure the PBatch8.sql exists before running
IF NOT EXIST "%SQL_PATH%\PBatch8.sql" (
    echo PBatch8.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute PBatch8.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch8.sql" > "%LOG_PATH%\PBatch8.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    echo Error in PBatch8.sql. Check log at %LOG_PATH%\PBatch8.log for details.
    ::pause
    exit /b 1
)

:: Success message and ::pause
echo 8. Sensitive fields masked successfully. Check log at %LOG_PATH%\PBatch8.log for output details.

::pause

