:: PBatch9.bat
:: Insert into the ETPProAC table using return records in ETPProRt
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

:: Ensure the PBatch9.sql exists before running
IF NOT EXIST "%SQL_PATH%\PBatch9.sql" (
    echo PBatch9.sql not found at %SQL_PATH%. Exiting...
    pause
    exit /b 1
)

:: Execute PBatch9.sql with logging
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -f "%SQL_PATH%\PBatch9.sql" > "%LOG_PATH%\PBatch9.log" 2>&1

:: Handle errors
if %ERRORLEVEL% neq 0 (
    echo Error in PBatch9.sql. Check log at %LOG_PATH%\PBatch9.log for details.
    pause
    exit /b 1
)

:: Success message and ::pause
echo 9. ACode updated successfully. Check log at %LOG_PATH%\PBatch9.log for output details.


::pause

