-- PBatch9.sql
-- Purpose: Populate ETPProAC from protection return results (ETPProRt)
-- Version: TriggerBuffered_v250715l, 2025-07-15
DO $$
DECLARE
    inserted_count INT;
    start_time TIMESTAMP := NOW();
    log_message TEXT;
BEGIN
    -- Log start
    log_message := format('PBatch9.sql: Starting ETPProAC population. StartTime: %s', 
                         TO_CHAR(start_time, 'YYYY-MM-DD HH24:MI:SS'));
    INSERT INTO etp_log (log_time, log_message)
    VALUES (TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), log_message);
    RAISE NOTICE '%', log_message;

    -- Insert successful protection returns into ETPProAC
    INSERT INTO etpproac (
        importid, 
        acode, 
        guestbook, 
        templatenumber, 
        username, 
        dbtablename
    )
    SELECT
        r.importid,
        r.acode,
        r.guestbook,
        r.templatenumber,
        r.username,
        (SELECT dbtablename FROM etpprohd LIMIT 1)
    FROM etpprort r
    WHERE r.acode IS NOT NULL;

    -- Get inserted row count
    GET DIAGNOSTICS inserted_count = ROW_COUNT;

    -- Log completion
    log_message := format('PBatch9.sql: ETPProAC populated with %s records. EndTime: %s, Elapsed: %s', 
                         inserted_count, TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), 
                         TO_CHAR(NOW() - start_time, 'MI:SS'));
    INSERT INTO etp_log (log_time, log_message)
    VALUES (TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), log_message);
    RAISE NOTICE '%', log_message;
END $$;