:: PBatchCombined.bat
:: Purpose: Executes PBatch1.sql to populate ETPProRq and ETPProBt, then runs ETPProt.exe /SQL to populate ETPProRt
:: Version: TriggerBuffered_v250713e, 2025-07-13
@echo off
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs
set CTP_PATH=C:\ETP_A_26
set PSQL="C:\Program Files\PostgreSQL\16\bin\psql.exe"
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set PGCONNECT_TIMEOUT=10

:: Ensure LOG_PATH exists
if not exist "%LOG_PATH%" (
    echo %DATE% %TIME% Error: LOG_PATH %LOG_PATH% does not exist. Creating... >> "%LOG_PATH%\PBatchCombined.log"
    mkdir "%LOG_PATH%"
    if %ERRORLEVEL% neq 0 (
        echo %DATE% %TIME% Error: Failed to create LOG_PATH %LOG_PATH%. Exiting. >> "%LOG_PATH%\PBatchCombined.log"
        exit /b 1
    )
)

:: Log start
echo %DATE% %TIME% Starting PBatchCombined.bat... >> "%LOG_PATH%\PBatchCombined.log"

:: Step 1: Run PBatch1.sql to populate ETPProRq and ETPProBt
echo %DATE% %TIME% Executing PBatch1.sql to populate ETPProRq... >> "%LOG_PATH%\PBatchCombined.log"
call %PSQL% -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -f "%SQL_PATH%\PBatch1.sql" >> "%LOG_PATH%\PBatchCombined.log" 2>&1
set PSQL_ERROR=%ERRORLEVEL%
echo %DATE% %TIME% PBatch1.sql completed (ERRORLEVEL: %PSQL_ERROR%) >> "%LOG_PATH%\PBatchCombined.log"
if %PSQL_ERROR% neq 0 (
    echo %DATE% %TIME% Error executing PBatch1.sql (ERRORLEVEL: %PSQL_ERROR%). Check %LOG_PATH%\PBatchCombined.log and etp_log table. Exiting. >> "%LOG_PATH%\PBatchCombined.log"
    exit /b 1
)
echo %DATE% %TIME% PBatch1.sql executed successfully. Continuing to ETPProt.exe... >> "%LOG_PATH%\PBatchCombined.log"

:: Step 2: Run ETPProt.exe to populate ETPProRt
echo %DATE% %TIME% Checking ETPProt.exe existence... >> "%LOG_PATH%\PBatchCombined.log"
if not exist "%CTP_PATH%\ETPProt.exe" (
    echo %DATE% %TIME% Error: ETPProt.exe not found at %CTP_PATH%. Exiting... >> "%LOG_PATH%\PBatchCombined.log"
    exit /b 1
)
echo %DATE% %TIME% Starting ETPProt.exe /SQL... >> "%LOG_PATH%\PBatchCombined.log"
call psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (NOW(), 'PBatchCombined.bat: Starting ETPProRt population. StartTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'));" >> "%LOG_PATH%\PBatchCombined.log" 2>&1
set PSQL_LOG_ERROR=%ERRORLEVEL%
echo %DATE% %TIME% etp_log insert completed (ERRORLEVEL: %PSQL_LOG_ERROR%) >> "%LOG_PATH%\PBatchCombined.log"
if %PSQL_LOG_ERROR% neq 0 (
    echo %DATE% %TIME% Error: Failed to log start to etp_log (ERRORLEVEL: %PSQL_LOG_ERROR%). Exiting. >> "%LOG_PATH%\PBatchCombined.log"
    exit /b 1
)
echo %DATE% %TIME% Running ETPProt.exe /SQL... >> "%LOG_PATH%\PBatchCombined.log"
cmd /c ""%CTP_PATH%\ETPProt.exe" /SQL" >> "%LOG_PATH%\PBatchCombined.log" 2>&1
set ETPPROT_ERROR=%ERRORLEVEL%
echo %DATE% %TIME% ETPProt.exe completed (ERRORLEVEL: %ETPPROT_ERROR%) >> "%LOG_PATH%\PBatchCombined.log"
if %ETPPROT_ERROR% neq 0 (
    echo %DATE% %TIME% Error in ETPProt.exe (ERRORLEVEL: %ETPPROT_ERROR%). Check %LOG_PATH%\PBatchCombined.log for details. >> "%LOG_PATH%\PBatchCombined.log"
    call psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (NOW(), 'PBatchCombined.bat: Error in ETPProt.exe. EndTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'));" >> "%LOG_PATH%\PBatchCombined.log" 2>&1
    exit /b 1
)
echo %DATE% %TIME% Querying ETPProRt row count... >> "%LOG_PATH%\PBatchCombined.log"
for /f "tokens=*" %%i in ('call %PSQL% -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -t -c "SELECT COUNT(*) FROM etpprort;"') do set ROW_COUNT=%%i
set ROW_COUNT=%ROW_COUNT: =%
echo %DATE% %TIME% ETPProRt population successful. Populated %ROW_COUNT% records. >> "%LOG_PATH%\PBatchCombined.log"
call psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (NOW(), 'PBatchCombined.bat: ETPProRt populated with ' || %ROW_COUNT% || ' records. EndTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS') || ', Elapsed: ' || TO_CHAR(NOW() - (SELECT log_time FROM etp_log WHERE log_message LIKE 'PBatchCombined.bat: Starting%%' ORDER BY log_time DESC LIMIT 1), 'MI:SS'));" >> "%LOG_PATH%\PBatchCombined.log" 2>&1
set PSQL_LOG_ERROR=%ERRORLEVEL%
echo %DATE% %TIME% etp_log final insert completed (ERRORLEVEL: %PSQL_LOG_ERROR%) >> "%LOG_PATH%\PBatchCombined.log"
if %PSQL_LOG_ERROR% neq 0 (
    echo %DATE% %TIME% Error: Failed to log success to etp_log (ERRORLEVEL: %PSQL_LOG_ERROR%). Exiting. >> "%LOG_PATH%\PBatchCombined.log"
    exit /b 1
)

:: Success message
echo %DATE% %TIME% PBatchCombined.bat executed successfully. Check %LOG_PATH%\PBatchCombined.log for details. >> "%LOG_PATH%\PBatchCombined.log"
exit /b 0