@echo off
:: Restore_StableRelease.bat – Restore a named version into active PBatch folder

set BASE_DIR=C:\ETP_A_26\PBatch
set VERSION=TriggerBuffered_v250508a
set RELEASE_DIR=%BASE_DIR%\StableRelease\%VERSION%

:: Confirm release exists
IF NOT EXIST "%RELEASE_DIR%" (
    echo ERROR: Release folder not found: %RELEASE_DIR%
    pause
    exit /b 1
)

echo Restoring files from: %RELEASE_DIR%
copy /Y "%RELEASE_DIR%\StartProcessing.bat" "%BASE_DIR%\StartProcessing.bat"
copy /Y "%RELEASE_DIR%\FlushBufferedToPRQ.sql" "%BASE_DIR%\FlushBufferedToPRQ.sql"
copy /Y "%RELEASE_DIR%\ClaimBatch_ReturnBatchNumber.sql" "%BASE_DIR%\ClaimBatch_ReturnBatchNumber.sql"

:: Restore PBatch2-9 scripts if present
for %%F in (2 3 4 5 6 7 8 9) do (
    if exist "%RELEASE_DIR%\PBatch%%F.sql" copy /Y "%RELEASE_DIR%\PBatch%%F.sql" "%BASE_DIR%\PBatch%%F.sql"
)

echo Restore complete.
pause
