:: RunTriggeredBatch.bat
:: One-pass triggered pipeline (Flush → Claim → Process → Finalize)
:: Version: v251007e
@echo
 off
setlocal ENABLEDELAYEDEXPANSION
:: ─────────────────────────────
:: CONFIGURATION
:: ─────────────────────────────
set "PGUSER=postgres"
set "PGPASSWORD=sa"
set "PGDATABASE=postgres"
set "PGHOST=localhost"
set "PGPORT=5432"
set "SQL_PATH=C:\ETP_A_26\PBatch"
set "LOG_PATH=C:\ETP_A_26\Logs"
set "PSQL=C:\PROGRA~1\PostgreSQL\16\bin\psql.exe"
set "LOG_FILE=%LOG_PATH%\RunTriggeredBatch.log"
:: ─────────────────────────────
:: STARTUP LOG
:: ─────────────────────────────
echo %DATE% %TIME% Starting RunTriggeredBatch.bat... >> "%LOG_FILE%"
"%PSQL%" -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% ^
-c "INSERT INTO etp_log (log_time, log_message) VALUES (TO_CHAR(NOW(),'YYYY-MM-DD HH24:MI:SS'), 'RunTriggeredBatch.bat: Starting triggered processing pipeline.');" >> "%LOG_FILE%" 2>&1
:: ─────────────────────────────
:: STEP 1 — FLUSH BUFFER
:: ─────────────────────────────
echo %DATE% %TIME% Flushing buffered records... >> "%LOG_FILE%"
"%PSQL%" -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -f "%SQL_PATH%\FlushBufferedToPRQ.sql" >> "%LOG_FILE%" 2>&1
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% ERROR: FlushBufferedToPRQ.sql failed. >> "%LOG_FILE%"
    exit /b 1
)
:: ─────────────────────────────
:: STEP 2 — PROMOTE READY → PROCESSING
:: ─────────────────────────────
"%PSQL%" -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% ^
-c "UPDATE ETPProBt SET Status='Processing' WHERE Status='Ready';" >> "%LOG_FILE%" 2>&1
:: ─────────────────────────────
:: STEP 3 — FETCH ACTIVE PROCESSING BATCH NUMBER
:: ─────────────────────────────
for /f %%B in ('%PSQL% -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -t -A -c "SELECT BatchNumber FROM ETPProBt WHERE Status=''Processing'' ORDER BY BatchNumber DESC LIMIT 1;"') do set "FOUND_BATCH=%%B"
for /f "tokens=* delims= " %%A in ("%FOUND_BATCH%") do set "FOUND_BATCH=%%A"
echo %DATE% %TIME% Found batch: [%FOUND_BATCH%] >> "%LOG_FILE%"if not defined FOUND_BATCH (
    echo %DATE% %TIME% ERROR: No Processing batch detected. Aborting. >> "%LOG_FILE%"
    exit /b 1
)
:: ─────────────────────────────
:: STEP 5 — PIPELINE SEQUENCE
:: ─────────────────────────────
echo %DATE% %TIME% Running pipeline for batch %FOUND_BATCH%... >> "%LOG_FILE%"
call "%SQL_PATH%\PBatch3.bat"
call "%SQL_PATH%\PBatch4.bat"
call "%SQL_PATH%\PBatch6.bat"
call "%SQL_PATH%\PBatch7.bat"
call "%SQL_PATH%\PBatch8.bat"
call "%SQL_PATH%\PBatch9.bat"
:: ─────────────────────────────
:: STEP 6 — COMPLETION LOGGING
:: ─────────────────────────────
echo %DATE% %TIME% Completed batch %FOUND_BATCH%. >> "%LOG_FILE%"
"%PSQL%" -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% ^
-c "INSERT INTO etp_log (log_time, log_message) VALUES (TO_CHAR(NOW(),'YYYY-MM-DD HH24:MI:SS'), 'RunTriggeredBatch.bat: Completed batch %FOUND_BATCH%.');" >> "%LOG_FILE%" 2>&1endlocal
exit /b 0

