--
-- PostgreSQL database dump
--

-- Dumped from database version 16.3
-- Dumped by pg_dump version 16.3

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: etp_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etp_log (
    logoid integer NOT NULL,
    log_time character varying(30) NOT NULL,
    log_message character varying(999) NOT NULL
);


ALTER TABLE public.etp_log OWNER TO postgres;

--
-- Name: etp_log_logoid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.etp_log ALTER COLUMN logoid ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME public.etp_log_logoid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: etpconfig; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpconfig (
    oid bigint NOT NULL,
    option_name text,
    option_value text
);


ALTER TABLE public.etpconfig OWNER TO postgres;

--
-- Name: etpconfig_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpconfig_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpconfig_oid_seq OWNER TO postgres;

--
-- Name: etpconfig_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpconfig_oid_seq OWNED BY public.etpconfig.oid;


--
-- Name: etpfetbt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpfetbt (
    oid bigint NOT NULL,
    batchnumber bigint NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    recordcount bigint NOT NULL,
    starttime character varying(19) NOT NULL,
    endtime character varying(19),
    executiontime character varying(19),
    status character varying(20) NOT NULL,
    notes text
);


ALTER TABLE public.etpfetbt OWNER TO postgres;

--
-- Name: etpfetbt_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpfetbt_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpfetbt_oid_seq OWNER TO postgres;

--
-- Name: etpfetbt_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpfetbt_oid_seq OWNED BY public.etpfetbt.oid;


--
-- Name: etpfetrq; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpfetrq (
    oid bigint NOT NULL,
    templatenumber bigint,
    dbtablename character varying(20),
    username character varying(20),
    importid character varying(20),
    acode character varying(100)
);


ALTER TABLE public.etpfetrq OWNER TO postgres;

--
-- Name: etpfetrt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpfetrt (
    oid bigint NOT NULL,
    templatenumber bigint,
    dbtablename character varying(20),
    username character varying(20),
    importid character varying(20),
    guestbook bigint,
    datestamp bigint,
    tstamp bigint,
    returnoka character varying(100),
    returnokb character varying(100),
    acode character varying(100),
    datafieldnumber smallint,
    datafieldname character varying(40),
    datavalue text
);


ALTER TABLE public.etpfetrt OWNER TO postgres;

--
-- Name: etppaclog; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etppaclog (
    oid bigint NOT NULL,
    log_date bigint,
    log_time bigint,
    guestbook bigint,
    batchnumber bigint,
    importid character varying(50),
    status character varying(20) DEFAULT 'Pending'::character varying
);


ALTER TABLE public.etppaclog OWNER TO postgres;

--
-- Name: etpparam; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpparam (
    oid bigint NOT NULL,
    batch_oid bigint,
    min_id bigint,
    max_id bigint,
    min_gb bigint,
    max_gb bigint
);


ALTER TABLE public.etpparam OWNER TO postgres;

--
-- Name: etpparam_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpparam_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpparam_oid_seq OWNER TO postgres;

--
-- Name: etpparam_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpparam_oid_seq OWNED BY public.etpparam.oid;


--
-- Name: etpproac; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpproac (
    oid bigint NOT NULL,
    importid character varying(20) NOT NULL,
    acode character varying(100) NOT NULL,
    guestbook bigint,
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20)
);


ALTER TABLE public.etpproac OWNER TO postgres;

--
-- Name: etpproac_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpproac_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpproac_oid_seq OWNER TO postgres;

--
-- Name: etpproac_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpproac_oid_seq OWNED BY public.etpproac.oid;


--
-- Name: etpprobf; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprobf (
    oid bigint NOT NULL,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(40) NOT NULL,
    importid character varying(20) NOT NULL,
    datafieldnumber smallint NOT NULL,
    datafieldname character varying(40) NOT NULL,
    datavalue text
);


ALTER TABLE public.etpprobf OWNER TO postgres;

--
-- Name: etpprobf_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprobf_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprobf_oid_seq OWNER TO postgres;

--
-- Name: etpprobf_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprobf_oid_seq OWNED BY public.etpprobf.oid;


--
-- Name: etpprobt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprobt (
    oid bigint NOT NULL,
    batchnumber bigint NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    recordcount bigint NOT NULL,
    starttime character varying(30) NOT NULL,
    endtime character varying(30),
    executiontime character varying(30),
    status character varying(20) NOT NULL,
    notes text
);


ALTER TABLE public.etpprobt OWNER TO postgres;

--
-- Name: etpprobt_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprobt_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprobt_oid_seq OWNER TO postgres;

--
-- Name: etpprobt_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprobt_oid_seq OWNED BY public.etpprobt.oid;


--
-- Name: etpprofm; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprofm (
    oid bigint NOT NULL,
    templatenumber bigint NOT NULL,
    datafieldname character varying(40) NOT NULL,
    datafieldnumber smallint NOT NULL
);


ALTER TABLE public.etpprofm OWNER TO postgres;

--
-- Name: etpprofm_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprofm_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprofm_oid_seq OWNER TO postgres;

--
-- Name: etpprofm_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprofm_oid_seq OWNED BY public.etpprofm.oid;


--
-- Name: etpprohd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprohd (
    oid bigint NOT NULL,
    location character varying(20) NOT NULL,
    templatenumber bigint NOT NULL,
    username character varying(20) NOT NULL,
    dbtablename character varying(20) NOT NULL,
    uniquesourcecolumn character varying(40) NOT NULL,
    gencrypt smallint DEFAULT 0
);


ALTER TABLE public.etpprohd OWNER TO postgres;

--
-- Name: etpprohd_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprohd_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprohd_oid_seq OWNER TO postgres;

--
-- Name: etpprohd_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprohd_oid_seq OWNED BY public.etpprohd.oid;


--
-- Name: etpprorq; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprorq (
    oid bigint NOT NULL,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20),
    importid character varying(20),
    datafieldnumber smallint,
    datafieldname character varying(40),
    datavalue text
);


ALTER TABLE public.etpprorq OWNER TO postgres;

--
-- Name: etpprort; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprort (
    oid bigint NOT NULL,
    templatenumber bigint NOT NULL,
    dbtablename character varying(20) NOT NULL,
    username character varying(20) NOT NULL,
    importid character varying(20) NOT NULL,
    guestbook bigint,
    acode character varying(100),
    actiontype character(1),
    returnoka character varying(100),
    returnokb character varying(100),
    datestamp bigint,
    tstamp bigint
);


ALTER TABLE public.etpprort OWNER TO postgres;

--
-- Name: etpprort_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprort_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprort_oid_seq OWNER TO postgres;

--
-- Name: etpprort_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprort_oid_seq OWNED BY public.etpprort.oid;


--
-- Name: etpprosr; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprosr (
    oid bigint NOT NULL,
    guestbook bigint,
    location character varying(20),
    templatenumber bigint,
    username character varying(20),
    dbtablename character varying(20),
    importid character varying(20)
);


ALTER TABLE public.etpprosr OWNER TO postgres;

--
-- Name: etpprotp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.etpprotp (
    oid bigint NOT NULL,
    templatenumber bigint NOT NULL,
    fieldname character varying(40) NOT NULL,
    fieldnumber smallint NOT NULL,
    masktype character varying(20) NOT NULL
);


ALTER TABLE public.etpprotp OWNER TO postgres;

--
-- Name: etpprotp_oid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.etpprotp_oid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.etpprotp_oid_seq OWNER TO postgres;

--
-- Name: etpprotp_oid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.etpprotp_oid_seq OWNED BY public.etpprotp.oid;


--
-- Name: etpconfig oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpconfig ALTER COLUMN oid SET DEFAULT nextval('public.etpconfig_oid_seq'::regclass);


--
-- Name: etpfetbt oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpfetbt ALTER COLUMN oid SET DEFAULT nextval('public.etpfetbt_oid_seq'::regclass);


--
-- Name: etpparam oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpparam ALTER COLUMN oid SET DEFAULT nextval('public.etpparam_oid_seq'::regclass);


--
-- Name: etpproac oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpproac ALTER COLUMN oid SET DEFAULT nextval('public.etpproac_oid_seq'::regclass);


--
-- Name: etpprobf oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprobf ALTER COLUMN oid SET DEFAULT nextval('public.etpprobf_oid_seq'::regclass);


--
-- Name: etpprobt oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprobt ALTER COLUMN oid SET DEFAULT nextval('public.etpprobt_oid_seq'::regclass);


--
-- Name: etpprofm oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprofm ALTER COLUMN oid SET DEFAULT nextval('public.etpprofm_oid_seq'::regclass);


--
-- Name: etpprohd oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprohd ALTER COLUMN oid SET DEFAULT nextval('public.etpprohd_oid_seq'::regclass);


--
-- Name: etpprort oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprort ALTER COLUMN oid SET DEFAULT nextval('public.etpprort_oid_seq'::regclass);


--
-- Name: etpprotp oid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprotp ALTER COLUMN oid SET DEFAULT nextval('public.etpprotp_oid_seq'::regclass);


--
-- Data for Name: etp_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etp_log (logoid, log_time, log_message) FROM stdin;
4157	2025-10-15 21:13:42	etpparam: INSERT oid=29, min_id=0, max_id=0
7	2025-07-25 16:25:00.702687-04	MasterBatchF: Started fetch process
8	2025-07-25 16:25:01.051736-04	FBatch1: Starting copy from etpproac to etpfetrq
9	2025-07-25 16:25:01.067121-04	FBatch1: Cleared etpfetrq table
10	2025-07-25 16:25:01.07683-04	FBatch1: Copied 0 records to etpfetrq
11	2025-07-25 16:25:01.087213-04	FBatch1: Completed successfully
12	2025-07-25 16:25:01.268985-04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
13	2025-07-25 16:25:11.078647-04	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
21	2025-07-25 17:00:48.798243-04	MasterBatchF: Started fetch process
22	2025-07-25 17:00:49	FBatch1: Starting copy from etpproac to etpfetrq
23	2025-07-25 17:00:49	FBatch1: Cleared etpfetrq table
24	2025-07-25 17:00:49	FBatch1: Copied 1 records to etpfetrq
25	2025-07-25 17:00:49	FBatch1: Created batch 77, OID=84, RecordCount=1
26	2025-07-25 17:00:49	FBatch1: Completed successfully
27	2025-07-25 17:00:49.677385-04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
28	2025-07-25 17:01:02.342216-04	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
29	2025-07-25 17:01:02	FBatch5: etpfetrt table found, starting poll
30	2025-07-25 17:01:02	FBatch5: Retry 1/60: etpfetrt has 8 rows
31	2025-07-25 17:01:02	FBatch5: etpfetrt contains 8 rows. Processing complete.
32	2025-07-25 17:01:02	FBatch5: Batch OID 84 marked as Completed. EndTime: 2025-07-25 17:01:02, ExecutionTime: 00:00:13
33	2025-07-25 17:01:02	FBatch6: Starting update of source records from etpfetrt using etpprofm
34	2025-07-25 17:01:02	FBatch6: Found 8 matching records in etpfetrt and etpprofm
35	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET birthdate = '1957-04-15' WHERE patient_id = '121'
36	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '121'
37	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '121'
38	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '121'
39	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '121'
40	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '121'
41	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '121'
42	2025-07-25 17:01:02	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '121'
43	2025-07-25 17:01:02	FBatch6: Source table updated using etpfetrt records with mapped field names
44	2025-07-25 17:01:02	FBatch6: Completed successfully
45	2025-07-25 17:01:03.029422-04	MasterBatchF: Fetch process completed successfully
46	2025-07-25 21:00:39	etpparam: UPDATE oid=1, min_id=122, max_id=122
47	2025-07-25 21:00:48.544175-04	MasterBatchF: Started fetch process
48	2025-07-25 21:00:48	FBatch1: Starting copy from etpproac to etpfetrq
49	2025-07-25 21:00:48	FBatch1: Cleared etpfetrq table
50	2025-07-25 21:00:48	FBatch1: Copied 0 records to etpfetrq
52	2025-07-25 21:00:48	FBatch1: Completed successfully
53	2025-07-25 21:00:48.797654-04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
54	2025-07-25 21:00:52.737094-04	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
68	2025-07-25 21:08:43	etpparam: UPDATE oid=1, min_id=123, max_id=123
69	2025-07-25 21:08:59.030847-04	MasterBatchF: Started fetch process
70	2025-07-25 21:08:59	FBatch1: Starting copy from etpproac to etpfetrq
71	2025-07-25 21:08:59	FBatch1: Cleared etpfetrq table
72	2025-07-25 21:08:59	FBatch1: Copied 1 records to etpfetrq
73	2025-07-25 21:08:59	FBatch1: Created batch 78, OID=85, RecordCount=1
74	2025-07-25 21:08:59	FBatch1: Completed successfully
75	2025-07-25 21:08:59.323251-04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
76	2025-07-25 21:09:08.17673-04	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
77	2025-07-25 21:09:08	FBatch5: etpfetrt table found, starting poll
78	2025-07-25 21:09:08	FBatch5: Retry 1/60: etpfetrt has 8 rows
79	2025-07-25 21:09:08	FBatch5: etpfetrt contains 8 rows. Processing complete.
80	2025-07-25 21:09:08	FBatch5: Batch OID 85 marked as Completed. EndTime: 2025-07-25 21:09:08, ExecutionTime: 00:00:09
81	2025-07-25 21:09:08	FBatch6: Starting update of source records from etpfetrt using etpprofm
82	2025-07-25 21:09:08	FBatch6: Found 8 matching records in etpfetrt and etpprofm
83	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET birthdate = '1957-04-15' WHERE patient_id = '123'
84	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '123'
85	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '123'
86	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '123'
87	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '123'
88	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '123'
89	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '123'
90	2025-07-25 21:09:08	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '123'
91	2025-07-25 21:09:08	FBatch6: Source table updated using etpfetrt records with mapped field names
92	2025-07-25 21:09:08	FBatch6: Completed successfully
93	2025-07-25 21:09:08.628128-04	MasterBatchF: Fetch process completed successfully
94	2025-07-25 21:12:38	etpparam: DELETE oid=20, min_id=0, max_id=0
95	2025-07-25 21:32:25	etpparam: UPDATE oid=1, min_id=126, max_id=127
96	2025-07-25 21:33:16.997433-04	MasterBatchF: Started fetch process
97	2025-07-25 21:33:17	FBatch1: Starting copy from etpproac to etpfetrq
98	2025-07-25 21:33:17	FBatch1: Cleared etpfetrq table
99	2025-07-25 21:33:17	FBatch1: Copied 2 records to etpfetrq
100	2025-07-25 21:33:17	FBatch1: Created batch 79, OID=86, RecordCount=2
101	2025-07-25 21:33:17	FBatch1: Completed successfully
102	2025-07-25 21:33:17.27194-04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
103	2025-07-25 21:33:27.460584-04	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
104	2025-07-25 21:33:27	FBatch5: etpfetrt table found, starting poll
105	2025-07-25 21:33:27	FBatch5: Retry 1/60: etpfetrt has 16 rows
106	2025-07-25 21:33:27	FBatch5: etpfetrt contains 16 rows. Processing complete.
107	2025-07-25 21:33:27	FBatch5: Batch OID 86 marked as Completed. EndTime: 2025-07-25 21:33:27, ExecutionTime: 00:00:10
108	2025-07-25 21:33:27	FBatch6: Starting update of source records from etpfetrt using etpprofm
109	2025-07-25 21:33:27	FBatch6: Found 16 matching records in etpfetrt and etpprofm
110	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
111	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
112	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
113	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
114	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
115	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
116	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
117	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
118	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
119	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
120	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
121	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
122	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
123	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
124	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
125	2025-07-25 21:33:27	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
126	2025-07-25 21:33:27	FBatch6: Source table updated using etpfetrt records with mapped field names
127	2025-07-25 21:33:27	FBatch6: Completed successfully
128	2025-07-25 21:33:27.926355-04	MasterBatchF: Fetch process completed successfully
129	2025-07-31 14:19:17	PBatch1.sql: Starting conditional truncate of ETPProRq. StartTime: 2025-07-31 14:19:17
130	2025-07-31 14:19:17	PBatch1.sql: Truncated ETPProRq. Elapsed: 00:00
131	2025-07-31 14:19:17	PBatch1.sql: Starting ETPProRq population. StartTime: 2025-07-31 14:19:17
132	2025-07-31 14:19:17	PBatch1.sql: Using TemplateNumber: 192, DBTableName: patients, UniqueSourceColumn: patient_id. Elapsed: 00:00
133	2025-07-31 14:19:17	PBatch1.sql: Batch record created with BatchNumber: 82. Elapsed: 00:00
134	2025-07-31 14:19:17	etpparam: UPDATE oid=1, min_id=126, max_id=127
135	2025-07-31 14:19:17	PBatch1.sql: Updated ETPParam with Batch OID: 82. Elapsed: 00:00
136	2025-07-31 14:19:17	PBatch1.sql: Updated etpprobt with 2 records for BatchNumber: 82. Elapsed: 00:00
137	2025-07-31 14:19:17	PBatch1.sql: ETPProRq populated with 16 records. EndTime: 2025-07-31 14:19:17, Elapsed: 00:00
138	2025-07-31 14:19:18	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-07-31 14:19:18
139	2025-07-31 14:19:29	PBatch3.bat: ETPProRt populated with 2 records. EndTime: 2025-07-31 14:19:29, Elapsed: 00:11
140	2025-07-31 14:19:29	PBatch4.sql: Retry 1/60: ETPProRt has 2 rows
141	2025-07-31 14:19:29	PBatch4.sql: ETPProRt contains 2 rows. Processing complete.
142	2025-07-31 14:19:29	PBatch4.sql: No Processing batch found in ETPProBt.
143	2025-07-31 14:19:29	PBatch6.sql: Starting ETPProTp population. StartTime: 2025-07-31 14:19:29
144	2025-07-31 14:19:29	PBatch6.sql: Truncated ETPProTp with RESTART IDENTITY. Elapsed: 00:00
145	2025-07-31 14:19:29	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
146	2025-07-31 14:19:29	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
147	2025-07-31 14:19:29	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
148	2025-07-31 14:19:29	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
149	2025-07-31 14:19:29	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
150	2025-07-31 14:19:29	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
151	2025-07-31 14:19:29	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
152	2025-07-31 14:19:29	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
153	2025-07-31 14:19:29	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
154	2025-07-31 14:19:29	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
155	2025-07-31 14:19:29	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
156	2025-07-31 14:19:29	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
157	2025-07-31 14:19:29	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
158	2025-07-31 14:19:29	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
159	2025-07-31 14:19:29	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
160	2025-07-31 14:19:29	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
161	2025-07-31 14:19:29	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
162	2025-07-31 14:19:29	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
163	2025-07-31 14:19:29	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
164	2025-07-31 14:19:29	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
165	2025-07-31 14:19:29	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
166	2025-07-31 14:19:29	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
167	2025-07-31 14:19:29	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
168	2025-07-31 14:19:29	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
169	2025-07-31 14:19:29	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
170	2025-07-31 14:19:29	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
171	2025-07-31 14:19:29	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
172	2025-07-31 14:19:29	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
173	2025-07-31 14:19:29	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
174	2025-07-31 14:19:29	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
175	2025-07-31 14:19:29	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
176	2025-07-31 14:19:29	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
177	2025-07-31 14:19:29	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
178	2025-07-31 14:19:29	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
179	2025-07-31 14:19:29	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
180	2025-07-31 14:19:29	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
181	2025-07-31 14:19:29	PBatch6.sql: ETPProTp populated successfully. EndTime: 2025-07-31 14:19:29, Elapsed: 00:00
182	2025-07-31 14:19:29	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-07-31 14:19:29
183	2025-07-31 14:19:29	PBatch7.sql: Batch OID 301 marked as Completed. EndTime: 2025-07-31 14:19:29, ExecutionTime: 00:00:12
184	2025-07-31 14:19:30	PBatch8.sql: Starting masking process. StartTime: 2025-07-31 14:19:30
185	2025-07-31 14:19:30	PBatch8.sql: Using unique source column: patient_id. Elapsed: 00:00
186	2025-07-31 14:19:30	PBatch8.sql: Processing ImportID: 126. Elapsed: 00:00
187	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: 1801-01-01 to field: birthdate. Elapsed: 00:00
188	2025-07-31 14:19:30	PBatch8.sql: Updated field birthdate with masked value 1801-01-01 for ImportID 126. Elapsed: 00:00
189	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ************** to field: ssn. Elapsed: 00:00
190	2025-07-31 14:19:30	PBatch8.sql: Updated field ssn with masked value ************** for ImportID 126. Elapsed: 00:00
191	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: * to field: medical_conditions. Elapsed: 00:00
192	2025-07-31 14:19:30	PBatch8.sql: Updated field medical_conditions with masked value * for ImportID 126. Elapsed: 00:00
193	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: * to field: medications. Elapsed: 00:00
194	2025-07-31 14:19:30	PBatch8.sql: Updated field medications with masked value * for ImportID 126. Elapsed: 00:00
195	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: **** to field: blood_type. Elapsed: 00:00
196	2025-07-31 14:19:30	PBatch8.sql: Updated field blood_type with masked value **** for ImportID 126. Elapsed: 00:00
197	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ****************** to field: credit_card_number. Elapsed: 00:00
198	2025-07-31 14:19:30	PBatch8.sql: Updated field credit_card_number with masked value ****************** for ImportID 126. Elapsed: 00:00
199	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: **** to field: credit_card_expiry. Elapsed: 00:00
200	2025-07-31 14:19:30	PBatch8.sql: Updated field credit_card_expiry with masked value **** for ImportID 126. Elapsed: 00:00
201	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ************** to field: employer_phone. Elapsed: 00:00
202	2025-07-31 14:19:30	PBatch8.sql: Updated field employer_phone with masked value ************** for ImportID 126. Elapsed: 00:00
203	2025-07-31 14:19:30	PBatch8.sql: Processing ImportID: 127. Elapsed: 00:00
204	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: 1801-01-01 to field: birthdate. Elapsed: 00:00
205	2025-07-31 14:19:30	PBatch8.sql: Updated field birthdate with masked value 1801-01-01 for ImportID 127. Elapsed: 00:00
206	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ************** to field: ssn. Elapsed: 00:00
207	2025-07-31 14:19:30	PBatch8.sql: Updated field ssn with masked value ************** for ImportID 127. Elapsed: 00:00
208	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: * to field: medical_conditions. Elapsed: 00:00
209	2025-07-31 14:19:30	PBatch8.sql: Updated field medical_conditions with masked value * for ImportID 127. Elapsed: 00:00
210	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: * to field: medications. Elapsed: 00:00
211	2025-07-31 14:19:30	PBatch8.sql: Updated field medications with masked value * for ImportID 127. Elapsed: 00:00
212	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: **** to field: blood_type. Elapsed: 00:00
213	2025-07-31 14:19:30	PBatch8.sql: Updated field blood_type with masked value **** for ImportID 127. Elapsed: 00:00
214	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ****************** to field: credit_card_number. Elapsed: 00:00
215	2025-07-31 14:19:30	PBatch8.sql: Updated field credit_card_number with masked value ****************** for ImportID 127. Elapsed: 00:00
216	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: **** to field: credit_card_expiry. Elapsed: 00:00
217	2025-07-31 14:19:30	PBatch8.sql: Updated field credit_card_expiry with masked value **** for ImportID 127. Elapsed: 00:00
218	2025-07-31 14:19:30	PBatch8.sql: Applying masked value: ************** to field: employer_phone. Elapsed: 00:00
219	2025-07-31 14:19:30	PBatch8.sql: Updated field employer_phone with masked value ************** for ImportID 127. Elapsed: 00:00
220	2025-07-31 14:19:30	PBatch8.sql: Masking completed successfully for 16 records. EndTime: 2025-07-31 14:19:30, Elapsed: 00:00
221	2025-07-31 14:19:30	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-07-31 14:19:30
222	2025-07-31 14:19:30	PBatch9.sql: ETPProAC populated with 2 records. EndTime: 2025-07-31 14:19:30, Elapsed: 00:00
223	2025-07-31 14:55:25	etpparam: INSERT oid=22, min_id=0, max_id=0
224	2025-07-31 14:56:10.651434-04	MasterBatchF: Started fetch process
225	2025-07-31 14:56:10	FBatch1: Starting copy from etpproac to etpfetrq
226	2025-07-31 14:56:10	FBatch1: Cleared etpfetrq table
227	2025-07-31 14:56:10	FBatch1: Copied 4 records to etpfetrq
228	2025-07-31 14:56:10	FBatch1: Created batch 80, OID=87, RecordCount=4
229	2025-07-31 14:56:10	FBatch1: Completed successfully
230	2025-07-31 14:56:11	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
231	2025-07-31 15:47:55	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
232	2025-07-31 15:47:55	FBatch5: etpfetrt table found, starting poll
233	2025-07-31 15:47:55	FBatch5: Retry 1/60: etpfetrt has 16 rows
234	2025-07-31 15:47:55	FBatch5: etpfetrt contains 16 rows. Processing complete.
235	2025-07-31 15:47:55	FBatch5: Batch OID 87 marked as Completed. EndTime: 2025-07-31 15:47:55, ExecutionTime: 00:51:45
236	2025-07-31 15:47:56	FBatch6: Starting update of source records from etpfetrt using etpprofm
237	2025-07-31 15:47:56	FBatch6: Found 16 matching records in etpfetrt and etpprofm
238	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
239	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
240	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
241	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
242	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
243	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
244	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
245	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
246	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
247	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
248	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
249	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
250	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
251	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
252	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
253	2025-07-31 15:47:56	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
254	2025-07-31 15:47:56	FBatch6: Source table updated using etpfetrt records with mapped field names
255	2025-07-31 15:47:56	FBatch6: Completed successfully
256	2025-07-31 15:47:56.208193-04	MasterBatchF: Fetch process completed successfully
257	2025-07-31 17:53:48.271964-04	MasterBatchF: Started fetch process
258	2025-07-31 17:53:48	FBatch1: Starting copy from etpproac to etpfetrq
259	2025-07-31 17:53:48	FBatch1: Cleared etpfetrq table
260	2025-07-31 17:53:48	FBatch1: Copied 4 records to etpfetrq
261	2025-07-31 17:53:48	FBatch1: Created batch 81, OID=88, RecordCount=4
262	2025-07-31 17:53:48	FBatch1: Completed successfully
263	2025-07-31 17:53:48	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
264	2025-07-31 18:16:35.791909-04	MasterBatchF: Started fetch process
265	2025-07-31 18:16:36	FBatch1: Starting copy from etpproac to etpfetrq
266	2025-07-31 18:16:36	FBatch1: Cleared etpfetrq table
267	2025-07-31 18:16:36	FBatch1: Copied 4 records to etpfetrq
268	2025-07-31 18:16:36	FBatch1: Created batch 82, OID=89, RecordCount=4
269	2025-07-31 18:16:36	FBatch1: Completed successfully
270	2025-07-31 18:16:36	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
271	2025-07-31 18:56:25	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
272	2025-07-31 18:56:25	FBatch5: etpfetrt table found, starting poll
273	2025-07-31 18:56:25	FBatch5: Retry 1/60: etpfetrt has 16 rows
274	2025-07-31 18:56:25	FBatch5: etpfetrt contains 16 rows. Processing complete.
275	2025-07-31 18:56:25	FBatch5: Batch OID 89 marked as Completed. EndTime: 2025-07-31 18:56:25, ExecutionTime: 00:39:49
276	2025-07-31 18:56:26	FBatch6: Starting update of source records from etpfetrt using etpprofm
277	2025-07-31 18:56:26	FBatch6: Found 16 matching records in etpfetrt and etpprofm
278	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
279	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
280	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
281	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
282	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
283	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
284	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
285	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
286	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
287	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
288	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
289	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
290	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
291	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
292	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
293	2025-07-31 18:56:26	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
294	2025-07-31 18:56:26	FBatch6: Source table updated using etpfetrt records with mapped field names
295	2025-07-31 18:56:26	FBatch6: Completed successfully
296	2025-07-31 18:56:26.450038-04	MasterBatchF: Fetch process completed successfully
297	2025-07-31 18:56:43.806702-04	MasterBatchF: Started fetch process
298	2025-07-31 18:56:44	FBatch1: Starting copy from etpproac to etpfetrq
299	2025-07-31 18:56:44	FBatch1: Cleared etpfetrq table
300	2025-07-31 18:56:44	FBatch1: Copied 4 records to etpfetrq
301	2025-07-31 18:56:44	FBatch1: Created batch 83, OID=90, RecordCount=4
302	2025-07-31 18:56:44	FBatch1: Completed successfully
303	2025-07-31 18:56:44	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
304	2025-07-31 19:15:59.630433-04	MasterBatchF: Started fetch process
305	2025-07-31 19:16:04	FBatch1: Starting copy from etpproac to etpfetrq
306	2025-07-31 19:16:04	FBatch1: Cleared etpfetrq table
307	2025-07-31 19:16:04	FBatch1: Copied 4 records to etpfetrq
308	2025-07-31 19:16:04	FBatch1: Created batch 84, OID=91, RecordCount=4
309	2025-07-31 19:16:04	FBatch1: Completed successfully
310	2025-07-31 19:16:05	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
311	2025-07-31 19:29:06.35171-04	MasterBatchF: Started fetch process
312	2025-07-31 19:29:06	FBatch1: Starting copy from etpproac to etpfetrq
313	2025-07-31 19:29:06	FBatch1: Cleared etpfetrq table
314	2025-07-31 19:29:06	FBatch1: Copied 4 records to etpfetrq
315	2025-07-31 19:29:06	FBatch1: Created batch 85, OID=92, RecordCount=4
316	2025-07-31 19:29:06	FBatch1: Completed successfully
317	2025-07-31 19:29:06	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
318	2025-07-31 20:02:22.522987-04	MasterBatchF: Started fetch process
319	2025-07-31 20:02:22	FBatch1: Starting copy from etpproac to etpfetrq
320	2025-07-31 20:02:22	FBatch1: Cleared etpfetrq table
321	2025-07-31 20:02:22	FBatch1: Copied 4 records to etpfetrq
322	2025-07-31 20:02:22	FBatch1: Created batch 86, OID=93, RecordCount=4
323	2025-07-31 20:02:22	FBatch1: Completed successfully
324	2025-07-31 20:02:23	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
331	2025-07-31 20:35:06	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
332	2025-07-31 20:35:07	FBatch5: etpfetrt table found, starting poll
333	2025-07-31 20:35:07	FBatch5: Retry 1/60: etpfetrt has 16 rows
334	2025-07-31 20:35:07	FBatch5: etpfetrt contains 16 rows. Processing complete.
335	2025-07-31 20:35:07	FBatch5: Batch OID 93 marked as Completed. EndTime: 2025-07-31 20:35:07, ExecutionTime: 00:32:45
336	2025-07-31 20:35:07	FBatch6: Starting update of source records from etpfetrt using etpprofm
337	2025-07-31 20:35:07	FBatch6: Found 16 matching records in etpfetrt and etpprofm
338	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
339	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
340	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
341	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
342	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
343	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
344	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
345	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
346	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
347	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
348	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
349	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
350	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
351	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
352	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
353	2025-07-31 20:35:07	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
354	2025-07-31 20:35:07	FBatch6: Source table updated using etpfetrt records with mapped field names
355	2025-07-31 20:35:07	FBatch6: Completed successfully
356	2025-07-31 20:35:07.814065-04	MasterBatchF: Fetch process completed successfully
357	2025-07-31 20:37:32.376293-04	FBatch1: Starting copy from etpproac to etpfetrq
358	2025-07-31 20:37:32.376293-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
359	2025-07-31 20:37:32.376293-04	FBatch1: Cleared etpfetrq table
360	2025-07-31 20:37:32.376293-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
361	2025-07-31 20:37:32.376293-04	FBatch1: Created batch 87, OID=94, RecordCount=0
362	2025-07-31 20:37:32.376293-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
363	2025-07-31 20:59:27.338417-04	FBatch1: Starting copy from etpproac to etpfetrq
364	2025-07-31 20:59:27.338417-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
365	2025-07-31 20:59:27.338417-04	FBatch1: Cleared etpfetrq table
366	2025-07-31 20:59:27.338417-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
367	2025-07-31 20:59:27.338417-04	FBatch1: Created batch 88, OID=95, RecordCount=0
368	2025-07-31 20:59:27.338417-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
369	2025-07-31 21:02:36.561075-04	FBatch1: Starting copy from etpproac to etpfetrq
370	2025-07-31 21:02:36.561075-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
371	2025-07-31 21:02:36.561075-04	FBatch1: Cleared etpfetrq table
372	2025-07-31 21:02:36.561075-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
373	2025-07-31 21:02:36.561075-04	FBatch1: Created batch 89, OID=96, RecordCount=0
374	2025-07-31 21:02:36.561075-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
375	2025-07-31 21:11:56.590792-04	FBatch1: Starting copy from etpproac to etpfetrq
376	2025-07-31 21:11:56.590792-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
377	2025-07-31 21:11:56.590792-04	FBatch1: Cleared etpfetrq table
378	2025-07-31 21:11:56.590792-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
379	2025-07-31 21:11:56.590792-04	FBatch1: Created batch 90, OID=97, RecordCount=0
380	2025-07-31 21:11:56.590792-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
381	2025-07-31 21:35:53.694286-04	FBatch1: Starting copy from etpproac to etpfetrq
382	2025-07-31 21:35:53.694286-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
383	2025-07-31 21:35:53.694286-04	FBatch1: Cleared etpfetrq table
384	2025-07-31 21:35:53.694286-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
385	2025-07-31 21:35:53.694286-04	FBatch1: Created batch 91, OID=98, RecordCount=0
386	2025-07-31 21:35:53.694286-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
387	2025-08-01 11:58:27.694088-04	FBatch1: Starting copy from etpproac to etpfetrq
388	2025-08-01 11:58:27.694088-04	FBatch1: Found 2 rows in etpparam; Latest: min_id=0, max_id=0
389	2025-08-01 11:58:27.694088-04	FBatch1: Cleared etpfetrq table
390	2025-08-01 11:58:27.694088-04	FBatch1: Copied 0 records to etpfetrq: No records inserted
391	2025-08-01 11:58:27.694088-04	FBatch1: Created batch 92, OID=99, RecordCount=0
392	2025-08-01 11:58:27.694088-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
393	2025-08-01 12:18:49.665933-04	FBatch1: Starting copy from etpproac to etpfetrq
394	2025-08-01 12:18:49.665933-04	FBatch1: Using etpparam: min_id=126, max_id=127; Found 1 valid rows in etpparam
395	2025-08-01 12:18:49.665933-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
396	2025-08-01 12:18:49.665933-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
397	2025-08-01 12:18:49.665933-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
398	2025-08-01 12:18:49.665933-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
399	2025-08-01 12:18:49.665933-04	FBatch1: Cleared etpfetrq table
400	2025-08-01 12:18:49.665933-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
401	2025-08-01 12:18:49.665933-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
402	2025-08-01 12:18:49.665933-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
403	2025-08-01 12:18:49.665933-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
404	2025-08-01 12:18:49.665933-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", OID=103; ImportID="127", OID=104
405	2025-08-01 12:18:49.665933-04	FBatch1: Created batch 93, OID=100, RecordCount=2
406	2025-08-01 12:18:49.665933-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
407	2025-08-01 12:31:03	etpparam: DELETE oid=22, min_id=0, max_id=0
408	2025-08-01 12:32:54.485838-04	FBatch1: Starting copy from etpproac to etpfetrq
409	2025-08-01 12:32:54.485838-04	FBatch1: Found 1 valid rows in etpparam
410	2025-08-01 12:32:54.485838-04	FBatch1: Using etpparam: min_id=126, max_id=127
411	2025-08-01 12:32:54.485838-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
412	2025-08-01 12:32:54.485838-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
413	2025-08-01 12:32:54.485838-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
414	2025-08-01 12:32:54.485838-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
415	2025-08-01 12:32:54.485838-04	FBatch1: Cleared etpfetrq table
416	2025-08-01 12:32:54.485838-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
475	2025-08-01 14:04:02	FBatch6: Source table updated using etpfetrt records with mapped field names
417	2025-08-01 12:32:54.485838-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
418	2025-08-01 12:32:54.485838-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
419	2025-08-01 12:32:54.485838-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
420	2025-08-01 12:32:54.485838-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", OID=103; ImportID="127", OID=104
421	2025-08-01 12:32:54.485838-04	FBatch1: Created batch 94, OID=101, RecordCount=2
422	2025-08-01 12:32:54.485838-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
423	2025-08-01 13:49:46.668593-04	MasterBatchF: Started fetch process
424	2025-08-01 13:49:46	FBatch1: Starting copy from etpproac to etpfetrq
425	2025-08-01 13:49:46	FBatch1: Cleared etpfetrq table
426	2025-08-01 13:49:46	FBatch1: Copied 4 records to etpfetrq
427	2025-08-01 13:49:46	FBatch1: Created batch 95, OID=102, RecordCount=4
428	2025-08-01 13:49:46	FBatch1: Completed successfully
429	2025-08-01 13:49:47	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
430	2025-08-01 13:57:28.200926-04	FBatch1: Starting copy from etpproac to etpfetrq
431	2025-08-01 13:57:28.200926-04	FBatch1: Found 1 etpparam row with oid=1
432	2025-08-01 13:57:28.200926-04	FBatch1: Using etpparam: min_id=126, max_id=127
433	2025-08-01 13:57:28.200926-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
434	2025-08-01 13:57:28.200926-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
435	2025-08-01 13:57:28.200926-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
436	2025-08-01 13:57:28.200926-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
437	2025-08-01 13:57:28.200926-04	FBatch1: Cleared etpfetrq table
438	2025-08-01 13:57:28.200926-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
439	2025-08-01 13:57:28.200926-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
440	2025-08-01 13:57:28.200926-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
441	2025-08-01 13:57:28.200926-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
442	2025-08-01 13:57:28.200926-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", OID=103; ImportID="127", OID=104
443	2025-08-01 13:57:28.200926-04	FBatch1: Created batch 96, OID=103, RecordCount=2
444	2025-08-01 13:57:28.200926-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
445	2025-08-01 14:03:31.841439-04	MasterBatchF: Started fetch process
446	2025-08-01 14:03:32	FBatch1: Starting copy from etpproac to etpfetrq
447	2025-08-01 14:03:32	FBatch1: Cleared etpfetrq table
448	2025-08-01 14:03:32	FBatch1: Copied 4 records to etpfetrq
449	2025-08-01 14:03:32	FBatch1: Created batch 97, OID=104, RecordCount=4
450	2025-08-01 14:03:32	FBatch1: Completed successfully
451	2025-08-01 14:03:32	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
452	2025-08-01 14:04:01	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
453	2025-08-01 14:04:01	FBatch5: etpfetrt table found, starting poll
454	2025-08-01 14:04:01	FBatch5: Retry 1/60: etpfetrt has 16 rows
455	2025-08-01 14:04:01	FBatch5: etpfetrt contains 16 rows. Processing complete.
456	2025-08-01 14:04:01	FBatch5: Batch OID 104 marked as Completed. EndTime: 2025-08-01 14:04:01, ExecutionTime: 00:00:29
457	2025-08-01 14:04:02	FBatch6: Starting update of source records from etpfetrt using etpprofm
458	2025-08-01 14:04:02	FBatch6: Found 16 matching records in etpfetrt and etpprofm
459	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
460	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
461	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
462	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
463	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
464	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
465	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
466	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
467	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
468	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
469	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
470	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
471	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
472	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
473	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
474	2025-08-01 14:04:02	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
476	2025-08-01 14:04:02	FBatch6: Completed successfully
477	2025-08-01 14:04:02.346816-04	MasterBatchF: Fetch process completed successfully
478	2025-08-01 14:09:30.914143-04	FBatch1: Starting copy from etpproac to etpfetrq
479	2025-08-01 14:09:30.914143-04	FBatch1: Found 1 etpparam row with oid=1
480	2025-08-01 14:09:30.914143-04	FBatch1: Using etpparam: min_id=126, max_id=127
481	2025-08-01 14:09:30.914143-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
482	2025-08-01 14:09:30.914143-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
483	2025-08-01 14:09:30.914143-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
484	2025-08-01 14:09:30.914143-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
485	2025-08-01 14:09:30.914143-04	FBatch1: Cleared etpfetrq table
486	2025-08-01 14:09:30.914143-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
487	2025-08-01 14:09:30.914143-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
488	2025-08-01 14:09:30.914143-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
489	2025-08-01 14:09:30.914143-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
490	2025-08-01 14:09:30.914143-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", Hex="313236", OID=103; ImportID="127", Hex="313237", OID=104
491	2025-08-01 14:09:30.914143-04	FBatch1: Created batch 98, OID=105, RecordCount=2
492	2025-08-01 14:09:30.914143-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
493	2025-08-01 14:16:36.743537-04	MasterBatchF: Started fetch process
494	2025-08-01 14:16:37	FBatch1: Starting copy from etpproac to etpfetrq
495	2025-08-01 14:16:37	FBatch1: Cleared etpfetrq table
496	2025-08-01 14:16:37	FBatch1: Copied 4 records to etpfetrq
497	2025-08-01 14:16:37	FBatch1: Created batch 99, OID=106, RecordCount=4
498	2025-08-01 14:16:37	FBatch1: Completed successfully
499	2025-08-01 14:16:37	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
500	2025-08-01 14:17:11	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
501	2025-08-01 14:17:11	FBatch5: etpfetrt table found, starting poll
502	2025-08-01 14:17:11	FBatch5: Retry 1/60: etpfetrt has 16 rows
503	2025-08-01 14:17:11	FBatch5: etpfetrt contains 16 rows. Processing complete.
504	2025-08-01 14:17:11	FBatch5: Batch OID 106 marked as Completed. EndTime: 2025-08-01 14:17:11, ExecutionTime: 00:00:34
505	2025-08-01 14:17:12	FBatch6: Starting update of source records from etpfetrt using etpprofm
506	2025-08-01 14:17:12	FBatch6: Found 16 matching records in etpfetrt and etpprofm
507	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
508	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
509	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
510	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
511	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
512	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
513	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
514	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
515	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
516	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
517	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
518	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
519	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
520	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
521	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
522	2025-08-01 14:17:12	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
523	2025-08-01 14:17:12	FBatch6: Source table updated using etpfetrt records with mapped field names
524	2025-08-01 14:17:12	FBatch6: Completed successfully
525	2025-08-01 14:17:12.187301-04	MasterBatchF: Fetch process completed successfully
526	2025-08-01 14:17:44.525357-04	FBatch1: Starting copy from etpproac to etpfetrq
527	2025-08-01 14:17:44.525357-04	FBatch1: Found 1 etpparam row with oid=1
528	2025-08-01 14:17:44.525357-04	FBatch1: Using etpparam: min_id=126, max_id=127
529	2025-08-01 14:17:44.525357-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
530	2025-08-01 14:17:44.525357-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
531	2025-08-01 14:17:44.525357-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
532	2025-08-01 14:17:44.525357-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
533	2025-08-01 14:17:44.525357-04	FBatch1: Cleared etpfetrq table
534	2025-08-01 14:17:44.525357-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
535	2025-08-01 14:17:44.525357-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
536	2025-08-01 14:17:44.525357-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
537	2025-08-01 14:17:44.525357-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
538	2025-08-01 14:17:44.525357-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", Hex="313236", OID=103; ImportID="127", Hex="313237", OID=104
539	2025-08-01 14:17:44.525357-04	FBatch1: Created batch 100, OID=107, RecordCount=2
540	2025-08-01 14:17:44.525357-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
541	2025-08-01 14:20:06.851902-04	MasterBatchF: Started fetch process
542	2025-08-01 14:20:07	FBatch1: Starting copy from etpproac to etpfetrq
543	2025-08-01 14:20:07	FBatch1: Cleared etpfetrq table
544	2025-08-01 14:20:07	FBatch1: Copied 4 records to etpfetrq
545	2025-08-01 14:20:07	FBatch1: Created batch 101, OID=108, RecordCount=4
546	2025-08-01 14:20:07	FBatch1: Completed successfully
547	2025-08-01 14:20:07	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
548	2025-08-01 14:20:26	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
549	2025-08-01 14:20:27	FBatch5: etpfetrt table found, starting poll
550	2025-08-01 14:20:27	FBatch5: Retry 1/60: etpfetrt has 16 rows
551	2025-08-01 14:20:27	FBatch5: etpfetrt contains 16 rows. Processing complete.
552	2025-08-01 14:20:27	FBatch5: Batch OID 108 marked as Completed. EndTime: 2025-08-01 14:20:27, ExecutionTime: 00:00:20
553	2025-08-01 14:20:27	FBatch6: Starting update of source records from etpfetrt using etpprofm
554	2025-08-01 14:20:27	FBatch6: Found 16 matching records in etpfetrt and etpprofm
555	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
556	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
557	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
558	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
559	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
560	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
561	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
562	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
563	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
564	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
565	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
566	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
567	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
568	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
569	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
570	2025-08-01 14:20:27	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
571	2025-08-01 14:20:27	FBatch6: Source table updated using etpfetrt records with mapped field names
572	2025-08-01 14:20:27	FBatch6: Completed successfully
573	2025-08-01 14:20:27.588834-04	MasterBatchF: Fetch process completed successfully
574	2025-08-01 14:25:45	etpparam: INSERT oid=23, min_id=0, max_id=0
575	2025-08-01 14:27:35.17066-04	MasterBatchF: Started fetch process
576	2025-08-01 14:27:35	FBatch1: Starting copy from etpproac to etpfetrq
577	2025-08-01 14:27:35	FBatch1: Cleared etpfetrq table
578	2025-08-01 14:27:35	FBatch1: Copied 4 records to etpfetrq
579	2025-08-01 14:27:35	FBatch1: Created batch 102, OID=109, RecordCount=4
580	2025-08-01 14:27:35	FBatch1: Completed successfully
581	2025-08-01 14:27:35	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
582	2025-08-01 14:32:58	etpparam: INSERT oid=24, min_id=0, max_id=0
583	2025-08-01 14:32:58	etpparam: UPDATE oid=24, min_id=1, max_id=5
584	2025-08-01 14:39:05	etpparam: INSERT oid=25, min_id=0, max_id=0
585	2025-08-01 14:39:05	etpparam: UPDATE oid=25, min_id=1, max_id=5
586	2025-08-01 14:39:36	etpparam: INSERT oid=26, min_id=0, max_id=0
587	2025-08-01 14:39:36	etpparam: UPDATE oid=26, min_id=1, max_id=5
588	2025-08-01 14:49:58	etpparam: INSERT oid=27, min_id=0, max_id=0
589	2025-08-01 14:49:58	etpparam: UPDATE oid=27, min_id=1, max_id=5
590	2025-08-01 14:50:02.49683-04	MasterBatchF: Started fetch process
591	2025-08-01 14:50:02.680791-04	FBatch1: Starting copy from etpproac to etpfetrq
592	2025-08-01 14:50:02.685876-04	FBatch1: Found 1 etpparam row with oid=1
593	2025-08-01 14:50:02.685876-04	FBatch1: Using etpparam: min_id=126, max_id=127
594	2025-08-01 14:50:02.685876-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=19
595	2025-08-01 14:50:02.685876-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=20
596	2025-08-01 14:50:02.685876-04	FBatch1: Raw etpproac importid: ImportID="126", Hex="313236", Length=3, Trimmed="126", OID=103
597	2025-08-01 14:50:02.685876-04	FBatch1: Raw etpproac importid: ImportID="127", Hex="313237", Length=3, Trimmed="127", OID=104
598	2025-08-01 14:50:02.685876-04	FBatch1: Cleared etpfetrq table
599	2025-08-01 14:50:02.685876-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
600	2025-08-01 14:50:02.685876-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
601	2025-08-01 14:50:02.685876-04	FBatch1: Filtered etpproac record: ImportID="126", Trimmed="126", Hex="313236", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
602	2025-08-01 14:50:02.685876-04	FBatch1: Filtered etpproac record: ImportID="127", Trimmed="127", Hex="313237", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
603	2025-08-01 14:50:02.685876-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", Hex="313236", OID=103; ImportID="127", Hex="313237", OID=104
604	2025-08-01 14:50:02.706931-04	FBatch1: Created batch 103, OID=110, RecordCount=2
605	2025-08-01 14:50:02.706931-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
606	2025-08-01 14:50:02	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
607	2025-08-01 14:50:16	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
608	2025-08-01 14:50:16	FBatch5: etpfetrt table found, starting poll
609	2025-08-01 14:50:16	FBatch5: Retry 1/60: etpfetrt has 16 rows
610	2025-08-01 14:50:16	FBatch5: etpfetrt contains 16 rows. Processing complete.
611	2025-08-01 14:50:16	FBatch5: Batch OID 110 marked as Completed. EndTime: 2025-08-01 14:50:16, ExecutionTime: 00:00:14
612	2025-08-01 14:50:16	FBatch6: Starting update of source records from etpfetrt using etpprofm
613	2025-08-01 14:50:16	FBatch6: Found 16 matching records in etpfetrt and etpprofm
614	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET birthdate = '1958-01-15' WHERE patient_id = '126'
615	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
616	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET ssn = '126-84-6789' WHERE patient_id = '126'
617	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET ssn = '127-65-4782' WHERE patient_id = '127'
618	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
619	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
620	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
621	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
622	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
623	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
624	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
625	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
626	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
627	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
628	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
629	2025-08-01 14:50:16	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
630	2025-08-01 14:50:16	FBatch6: Source table updated using etpfetrt records with mapped field names
631	2025-08-01 14:50:16	FBatch6: Completed successfully
632	2025-08-01 14:50:16.992268-04	MasterBatchF: Fetch process completed successfully
633	2025-08-01 15:00:22.135143-04	MasterBatchF: Started fetch process
634	2025-08-01 15:00:22.313538-04	FBatch1: Starting copy from etpproac to etpfetrq
635	2025-08-01 15:00:22.317281-04	FBatch1: Found 1 etpparam row with oid=1
636	2025-08-01 15:00:22.317281-04	FBatch1: Using etpparam: min_id=126, max_id=127
637	2025-08-01 15:00:22.317281-04	FBatch1: Raw etpproac: ImportID="126", Length=3, Trimmed="126", OID=19
638	2025-08-01 15:00:22.317281-04	FBatch1: Raw etpproac: ImportID="127", Length=3, Trimmed="127", OID=20
639	2025-08-01 15:00:22.317281-04	FBatch1: Raw etpproac: ImportID="126", Length=3, Trimmed="126", OID=103
640	2025-08-01 15:00:22.317281-04	FBatch1: Raw etpproac: ImportID="127", Length=3, Trimmed="127", OID=104
641	2025-08-01 15:00:22.317281-04	FBatch1: Cleared etpfetrq table
642	2025-08-01 15:00:22.317281-04	FBatch1: Filtered etpproac: ImportID="126", Trimmed="126", OID=19, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=F31DA42A1F5E910
643	2025-08-01 15:00:22.317281-04	FBatch1: Filtered etpproac: ImportID="127", Trimmed="127", OID=20, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=A5DF04F88C8BD10
644	2025-08-01 15:00:22.317281-04	FBatch1: Filtered etpproac: ImportID="126", Trimmed="126", OID=103, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=4397620160DC320
645	2025-08-01 15:00:22.317281-04	FBatch1: Filtered etpproac: ImportID="127", Trimmed="127", OID=104, TemplateNumber=192, DBTableName=patients, UserName=Doug, ACode=34F11563E089D20
646	2025-08-01 15:00:22.317281-04	FBatch1: Copied 2 records to etpfetrq: ImportID="126", OID=103; ImportID="127", OID=104
647	2025-08-01 15:00:22.339969-04	FBatch1: Created batch 104, OID=111, RecordCount=2
648	2025-08-01 15:00:22.339969-04	FBatch1: Completed - Data copied from PAC to FRQ and batch initialized in FBT
649	2025-08-01 15:00:22	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
650	2025-08-01 15:00:37	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
651	2025-08-01 15:00:37	FBatch5: etpfetrt table found, starting poll
652	2025-08-01 15:00:37	FBatch5: Retry 1/60: etpfetrt has 16 rows
653	2025-08-01 15:00:37	FBatch5: etpfetrt contains 16 rows. Processing complete.
654	2025-08-01 15:00:37	FBatch5: Batch OID 111 marked as Completed. EndTime: 2025-08-01 15:00:37, ExecutionTime: 00:00:15
655	2025-08-01 15:00:37	FBatch6: Starting update of source records from etpfetrt using etpprofm
656	2025-08-01 15:00:37	FBatch6: Found 16 matching records in etpfetrt and etpprofm
657	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
658	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET birthdate = '1958-01-15' WHERE patient_id = '126'
659	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET ssn = '127-65-4782' WHERE patient_id = '127'
660	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET ssn = '126-84-6789' WHERE patient_id = '126'
661	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
662	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
663	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
664	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
665	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
666	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
667	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
668	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
669	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
670	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
671	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
672	2025-08-01 15:00:37	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
673	2025-08-01 15:00:37	FBatch6: Source table updated using etpfetrt records with mapped field names
674	2025-08-01 15:00:37	FBatch6: Completed successfully
675	2025-08-01 15:00:37.84085-04	MasterBatchF: Fetch process completed successfully
676	2025-08-03 20:55:01	etpparam: INSERT oid=28, min_id=0, max_id=0
677	2025-08-03 20:55:01	etpparam: UPDATE oid=28, min_id=1, max_id=5
678	2025-08-03 20:56:17	etpparam: UPDATE oid=1, min_id=126, max_id=127
679	2025-08-03 22:17:29	etpparam: DELETE oid=23, min_id=0, max_id=0
680	2025-08-03 22:17:31	etpparam: DELETE oid=24, min_id=1, max_id=5
681	2025-08-03 22:17:35	etpparam: DELETE oid=25, min_id=1, max_id=5
682	2025-08-03 22:17:38	etpparam: DELETE oid=26, min_id=1, max_id=5
683	2025-08-03 22:17:40	etpparam: DELETE oid=27, min_id=1, max_id=5
684	2025-08-03 22:17:43	etpparam: DELETE oid=28, min_id=1, max_id=5
685	2025-08-04 13:31:08.096522-04	MasterBatchF: Started fetch process
686	 8/04/2025 13:32:55	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
687	 8/04/2025 13:33:17	CopyPACtoFRQ: Found GuestbookID=114, oid=19
688	 8/04/2025 13:33:29	CopyPACtoFRQ: Found GuestbookID=115, oid=20
689	 8/04/2025 13:34:17	CopyPACtoFRQ: Copied 2 records to etpfetrq: 
690	2025-08-04 15:41:30.064587-04	MasterBatchF: Started fetch process
691	 8/04/2025 15:41:37	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
692	 8/04/2025 15:41:38	CopyPACtoFRQ: Found GuestbookID=114, oid=19
693	 8/04/2025 15:41:40	CopyPACtoFRQ: Found GuestbookID=115, oid=20
694	 8/04/2025 15:41:54	CopyPACtoFRQ: Copied 2 records to etpfetrq: 
695	 8/04/2025 20:50:14	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
696	 8/04/2025 20:50:19	CopyPACtoFRQ: Found GuestbookID=114, oid=19
697	 8/04/2025 20:50:22	CopyPACtoFRQ: Found GuestbookID=115, oid=20
698	 8/04/2025 20:50:28	CopyPACtoFRQ: Copied 2 records to etpfetrq: 
699	2025-08-04 20:50:30.033465-04	MasterBatchF: Started fetch process
700	2025-08-04 21:21:03.254861-04	MasterBatchF: Started fetch process
701	2025-08-04 21:22:35	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
702	2025-08-04 21:22:52	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
703	2025-08-04 21:22:52	FBatch5: etpfetrt table found, starting poll
704	2025-08-04 21:22:52	FBatch5: Retry 1/60: etpfetrt has 16 rows
705	2025-08-04 21:22:52	FBatch5: etpfetrt contains 16 rows. Processing complete.
706	2025-08-04 21:22:52	FBatch5: Batch OID 117 marked as Completed. EndTime: 2025-08-04 21:22:52, ExecutionTime: 00:32:38
707	2025-08-04 21:22:53	FBatch6: Starting update of source records from etpfetrt using etpprofm
708	2025-08-04 21:22:53	FBatch6: Found 16 matching records in etpfetrt and etpprofm
709	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
710	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
711	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
712	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
713	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
714	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
715	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
716	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
717	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
718	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
719	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
720	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
721	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
722	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
723	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
724	2025-08-04 21:22:53	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
725	2025-08-04 21:22:53	FBatch6: Source table updated using etpfetrt records with mapped field names
726	2025-08-04 21:22:53	FBatch6: Completed successfully
727	2025-08-04 21:22:53.272929-04	MasterBatchF: Fetch process completed successfully
728	 8/04/2025 23:45:51	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
729	 8/04/2025 23:45:57	CopyPACtoFRQ: Found GuestbookID=114, oid=19
730	 8/04/2025 23:45:59	CopyPACtoFRQ: Found GuestbookID=115, oid=20
731	 8/04/2025 23:46:00	CopyPACtoFRQ: Copied 2 records to etpfetrq: 
732	2025-08-04 23:46:01.948312-04	MasterBatchF: Started fetch process
733	2025-08-04 23:46:04	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
734	2025-08-04 23:46:18	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
735	2025-08-04 23:46:18	FBatch5: etpfetrt table found, starting poll
736	2025-08-04 23:46:18	FBatch5: Retry 1/60: etpfetrt has 16 rows
737	2025-08-04 23:46:18	FBatch5: etpfetrt contains 16 rows. Processing complete.
738	2025-08-04 23:46:18	FBatch5: Error updating etpfetbt or etppaclog: column "etpfetbt.batchnumber" must appear in the GROUP BY clause or be used in an aggregate function
739	2025-08-04 23:46:18	FBatch6: Starting update of source records from etpfetrt using etpprofm
740	2025-08-04 23:46:18	FBatch6: Found 16 matching records in etpfetrt and etpprofm
741	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
742	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
743	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
744	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
745	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
746	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
747	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
748	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
749	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
750	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
751	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
752	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
753	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
754	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
755	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
756	2025-08-04 23:46:18	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
757	2025-08-04 23:46:18	FBatch6: Source table updated using etpfetrt records with mapped field names
758	2025-08-04 23:46:18	FBatch6: Completed successfully
759	2025-08-04 23:46:19.10421-04	MasterBatchF: Fetch process completed successfully
760	2025-08-05 13:23:55.548541-04	FBatch5: Started parsing ETPFetRt.xml into etpfetrt
761	2025-08-05 13:23:55.805177-04	FBatch5: Found ETPFetRt.xml at C:\\ETP_A_25\\Show50KTst\\etpfetrt.xml
762	2025-08-05 13:23:55.969373-04	FBatch5: Parsing ETPFetRt.xml
763	2025-08-05 13:23:56	FBatch5: etpfetrt table found, starting poll
764	2025-08-05 13:23:56	FBatch5: Retry 1/60: etpfetrt has 16 rows
765	2025-08-05 13:23:56	FBatch5: etpfetrt contains 16 rows. Processing complete.
766	2025-08-05 13:23:56	FBatch5: Error updating etpfetbt or etppaclog: column "etpfetbt.batchnumber" must appear in the GROUP BY clause or be used in an aggregate function
767	2025-08-05 13:23:56.442257-04	FBatch5: Successfully loaded ETPFetRt.xml into etpfetrt
768	2025-08-05 13:30:46	FBatch5: etpfetrt table found, starting poll
769	2025-08-05 13:30:46	FBatch5: Retry 1/60: etpfetrt has 16 rows
770	2025-08-05 13:30:46	FBatch5: etpfetrt contains 16 rows. Processing complete.
771	2025-08-05 13:30:46	FBatch5: Error updating etpfetbt or etppaclog: column "etpfetbt.batchnumber" must appear in the GROUP BY clause or be used in an aggregate function
772	2025-08-05 13:58:51	FBatch5: etpfetrt table found, starting poll
773	2025-08-05 13:58:51	FBatch5: Retry 1/60: etpfetrt has 16 rows
774	2025-08-05 13:58:51	FBatch5: etpfetrt contains 16 rows. Processing complete.
776	2025-08-05 13:58:51	FBatch5: Error updating etpfetbt or etppaclog: aggregate functions are not allowed in RETURNING
777	2025-08-05 14:03:05	FBatch5: etpfetrt table found, starting poll
778	2025-08-05 14:03:05	FBatch5: Retry 1/60: etpfetrt has 16 rows
779	2025-08-05 14:03:05	FBatch5: etpfetrt contains 16 rows. Processing complete.
780	2025-08-05 14:03:05	FBatch5: Batch OID 118 marked as Completed. EndTime: 2025-08-05 14:03:05, ExecutionTime: 14:17:14
781	2025-08-05 14:03:05	FBatch5: Updated 2 etppaclog records to Consumed for batchnumber: 109
782	2025-08-05 14:17:48.246901-04	FBatch5: Started parsing ETPFetRt.xml into etpfetrt
783	2025-08-05 14:17:48.543097-04	FBatch5: Found ETPFetRt.xml at C:\\ETP_A_25\\Show50KTst\\etpfetrt.xml
784	2025-08-05 14:17:48.813112-04	FBatch5: Parsing ETPFetRt.xml
785	2025-08-05 14:17:48	FBatch5: etpfetrt table found, starting poll
786	2025-08-05 14:17:48	FBatch5: Retry 1/60: etpfetrt has 16 rows
787	2025-08-05 14:17:48	FBatch5: etpfetrt contains 16 rows. Processing complete.
789	2025-08-05 14:17:48	FBatch5: Error updating etpfetbt or etppaclog: aggregate functions are not allowed in RETURNING
790	2025-08-05 14:17:49.211406-04	FBatch5: Successfully loaded ETPFetRt.xml into etpfetrt
791	2025-08-05 14:19:01.426793-04	FBatch5: Started parsing ETPFetRt.xml into etpfetrt
792	2025-08-05 14:19:01.70029-04	FBatch5: Found ETPFetRt.xml at C:\\ETP_A_25\\Show50KTst\\etpfetrt.xml
793	2025-08-05 14:19:01.955148-04	FBatch5: Parsing ETPFetRt.xml
794	2025-08-05 14:19:02	FBatch5: etpfetrt table found, starting poll
795	2025-08-05 14:19:02	FBatch5: Retry 1/60: etpfetrt has 16 rows
796	2025-08-05 14:19:02	FBatch5: etpfetrt contains 16 rows. Processing complete.
797	2025-08-05 14:19:02	FBatch5: Batch OID 116 marked as Completed. EndTime: 2025-08-05 14:19:02, ExecutionTime: 22:37:12
798	2025-08-05 14:19:02	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 107
799	2025-08-05 14:19:02.319356-04	FBatch5: Successfully loaded ETPFetRt.xml into etpfetrt
800	2025-08-05 14:19:30.12335-04	FBatch6: Started updating source records from etpfetrt using etpprofm
801	2025-08-05 14:19:30	FBatch6: Starting update of source records from etpfetrt using etpprofm
802	2025-08-05 14:19:30	FBatch6: Found 16 matching records in etpfetrt and etpprofm
803	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
804	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
805	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
806	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
807	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
808	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
809	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
810	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
811	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
812	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
813	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
814	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
815	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
816	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
817	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
818	2025-08-05 14:19:30	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
819	2025-08-05 14:19:30	FBatch6: Source table updated using etpfetrt records with mapped field names
820	2025-08-05 14:19:30	FBatch6: Completed successfully
821	2025-08-05 14:19:30.545705-04	FBatch6: Successfully updated source records from etpfetrt
822	2025-08-05 16:44:39.200743-04	MasterBatchF: Started fetch process
823	2025-08-05 16:44:42	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
824	 8/05/2025 16:57:23	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
825	 8/05/2025 16:58:18	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
826	 8/05/2025 17:00:57	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
827	 8/05/2025 17:01:20	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
828	2025-08-05 17:01:23.264459-04	MasterBatchF: Started fetch process
829	 8/05/2025 19:17:46	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
830	 8/05/2025 19:17:47	SKIPPING CONSUMED: Found GuestbookID=114, oid=19
831	 8/05/2025 19:17:47	SKIPPING CONSUMED: Found GuestbookID=115, oid=20
832	2025-08-05 19:17:48.442886-04	MasterBatchF: Started fetch process
833	 8/05/2025 20:04:19	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
834	 8/05/2025 20:04:19	SKIPPING CONSUMED: Found GuestbookID=114, oid=19
835	 8/05/2025 20:04:19	SKIPPING CONSUMED: Found GuestbookID=115, oid=20
836	 8/06/2025 16:45:15	CopyPACtoFRQ: Using min_guestbookid=114, max_guestbookid=115
837	 8/06/2025 16:45:15	SKIPPING CONSUMED: Found GuestbookID=114, oid=19
838	 8/06/2025 16:45:15	SKIPPING CONSUMED: Found GuestbookID=115, oid=20
839	2025-08-07 15:09:04	etpparam: UPDATE oid=1, min_id=124, max_id=113
840	2025-08-07 15:13:36	etpparam: UPDATE oid=1, min_id=135, max_id=116
841	 8/07/2025 15:13:46	CopyPACtoFRQ: Using min_guestbookid=135, max_guestbookid=116
842	 8/07/2025 15:14:20	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
843	2025-08-07 15:14:22.826484-04	StartFetchProc: Started fetch process
844	2025-08-07 15:14:24	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
845	2025-08-07 15:14:28	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
846	2025-08-07 15:14:28	FBatch5: etpfetrt table found, starting poll
847	2025-08-07 15:14:28	FBatch5: Retry 1/60: etpfetrt has 16 rows
848	2025-08-07 15:14:28	FBatch5: etpfetrt contains 16 rows. Processing complete.
849	2025-08-07 15:14:28	FBatch5: Batch OID 121 marked as Completed. EndTime: 2025-08-07 15:14:28, ExecutionTime: 00:00:27
850	2025-08-07 15:14:28	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 112
851	2025-08-07 15:14:28	FBatch6: Starting update of source records from etpfetrt using etpprofm
852	2025-08-07 15:14:28	FBatch6: Found 16 matching records in etpfetrt and etpprofm
853	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '126'
854	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '126'
855	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '126'
856	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '126'
857	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '126'
858	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '126'
859	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '126'
860	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '126'
861	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET birthdate = '1957-01-15' WHERE patient_id = '127'
862	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '127'
863	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '127'
864	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '127'
865	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '127'
866	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '127'
867	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '127'
868	2025-08-07 15:14:28	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '127'
869	2025-08-07 15:14:28	FBatch6: Source table updated using etpfetrt records with mapped field names
870	2025-08-07 15:14:28	FBatch6: Completed successfully
871	2025-08-07 15:14:29.073962-04	StartFetchProc: Fetch process completed successfully
872	2025-08-07 15:15:29	etpparam: UPDATE oid=1, min_id=210, max_id=128
873	 8/07/2025 15:15:51	CopyPACtoFRQ: Using min_guestbookid=210, max_guestbookid=128
874	 8/07/2025 15:16:07	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
875	2025-08-07 15:16:09.218871-04	StartFetchProc: Started fetch process
876	2025-08-07 15:16:37	etpparam: UPDATE oid=1, min_id=127, max_id=204
877	 8/07/2025 15:16:46	CopyPACtoFRQ: Using min_guestbookid=127, max_guestbookid=204
878	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=127, oid=35
879	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=128, oid=36
880	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=129, oid=37
881	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=130, oid=38
882	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=131, oid=39
883	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=132, oid=40
884	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=133, oid=41
885	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=134, oid=42
886	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=135, oid=43
887	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=136, oid=44
888	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=137, oid=45
889	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=138, oid=46
890	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=139, oid=47
891	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=140, oid=48
892	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=141, oid=49
893	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=142, oid=50
894	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=143, oid=51
895	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=144, oid=52
896	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=145, oid=53
897	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=146, oid=54
898	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=147, oid=55
899	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=148, oid=56
900	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=149, oid=57
901	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=150, oid=58
902	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=151, oid=59
903	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=152, oid=60
904	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=153, oid=61
905	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=154, oid=62
906	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=155, oid=63
907	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=156, oid=64
908	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=157, oid=65
909	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=158, oid=66
910	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=159, oid=67
911	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=160, oid=68
912	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=161, oid=69
913	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=162, oid=70
914	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=163, oid=71
915	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=164, oid=72
916	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=165, oid=73
917	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=166, oid=74
918	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=167, oid=75
919	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=168, oid=76
920	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=169, oid=77
921	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=170, oid=78
922	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=171, oid=79
923	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=172, oid=80
924	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=173, oid=81
925	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=174, oid=82
926	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=175, oid=83
927	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=176, oid=84
928	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=177, oid=85
929	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=178, oid=86
930	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=178, oid=89
931	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=179, oid=90
932	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=179, oid=87
933	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=180, oid=88
934	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=180, oid=91
935	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=181, oid=92
936	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=182, oid=93
937	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=183, oid=94
938	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=186, oid=96
939	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=192, oid=97
940	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=193, oid=98
941	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=195, oid=99
942	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=196, oid=100
943	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=197, oid=101
944	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=203, oid=103
945	 8/07/2025 15:16:46	CopyPACtoFRQ: Found GuestbookID=204, oid=104
946	 8/07/2025 15:16:49	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
947	2025-08-07 15:16:50.663437-04	StartFetchProc: Started fetch process
948	2025-08-07 15:16:52	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
949	2025-08-07 23:03:21	FBatch5: etpfetrt table found, starting poll
950	2025-08-07 23:03:21	FBatch5: Retry 1/60: etpfetrt has 416 rows
951	2025-08-07 23:03:21	FBatch5: etpfetrt contains 416 rows. Processing complete.
952	2025-08-07 23:03:21	FBatch5: Batch OID 123 marked as Completed. EndTime: 2025-08-07 23:03:21, ExecutionTime: 07:46:35
953	2025-08-07 23:03:21	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 114
954	2025-08-07 23:06:59	FBatch6: Starting update of source records from etpfetrt using etpprofm
955	2025-08-07 23:06:59	FBatch6: Found 416 matching records in etpfetrt and etpprofm
956	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '209'
957	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '209'
958	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '209'
959	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '209'
960	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '209'
961	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '209'
962	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '209'
963	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '209'
964	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '210'
965	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '210'
966	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '210'
967	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '210'
968	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '210'
969	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '210'
970	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '210'
971	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '210'
972	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1985-03-14' WHERE patient_id = '211'
973	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '111-22-3333' WHERE patient_id = '211'
974	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '211'
975	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '211'
976	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A+' WHERE patient_id = '211'
977	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4012888888881881' WHERE patient_id = '211'
978	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '07/27' WHERE patient_id = '211'
979	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-891-2345' WHERE patient_id = '211'
980	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1977-11-20' WHERE patient_id = '212'
981	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '222-33-4444' WHERE patient_id = '212'
982	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '212'
983	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '212'
984	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B-' WHERE patient_id = '212'
985	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '6011111111111117' WHERE patient_id = '212'
986	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '09/25' WHERE patient_id = '212'
987	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-123-9876' WHERE patient_id = '212'
988	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1991-06-05' WHERE patient_id = '213'
989	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '333-44-5555' WHERE patient_id = '213'
990	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Migraines' WHERE patient_id = '213'
991	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Sumatriptan' WHERE patient_id = '213'
992	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O-' WHERE patient_id = '213'
993	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '378282246310005' WHERE patient_id = '213'
994	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '03/28' WHERE patient_id = '213'
995	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-999-1111' WHERE patient_id = '213'
996	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1965-09-29' WHERE patient_id = '214'
997	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '444-55-6666' WHERE patient_id = '214'
998	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Arthritis' WHERE patient_id = '214'
999	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Ibuprofen' WHERE patient_id = '214'
1000	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'AB+' WHERE patient_id = '214'
1001	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '6011000990139424' WHERE patient_id = '214'
1002	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '01/26' WHERE patient_id = '214'
1003	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-222-4444' WHERE patient_id = '214'
1004	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '2000-07-18' WHERE patient_id = '215'
1482	2025-08-08 15:57:52	etpparam: UPDATE oid=1, min_id=43, max_id=43
1005	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '555-66-7777' WHERE patient_id = '215'
1006	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'None' WHERE patient_id = '215'
1007	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'None' WHERE patient_id = '215'
1008	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '215'
1009	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '3530111333300000' WHERE patient_id = '215'
1010	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '05/26' WHERE patient_id = '215'
1011	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-999-0000' WHERE patient_id = '215'
1012	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-10-12' WHERE patient_id = '216'
1013	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '666-77-8888' WHERE patient_id = '216'
1014	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'High BP' WHERE patient_id = '216'
1015	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '216'
1016	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '216'
1017	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '5105105105105100' WHERE patient_id = '216'
1018	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/27' WHERE patient_id = '216'
1019	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-321-7654' WHERE patient_id = '216'
1020	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-02-22' WHERE patient_id = '217'
1021	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '777-88-9999' WHERE patient_id = '217'
1022	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Thyroid' WHERE patient_id = '217'
1023	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Levothyroxine' WHERE patient_id = '217'
1024	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '217'
1025	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4000056655665556' WHERE patient_id = '217'
1026	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/25' WHERE patient_id = '217'
1027	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-444-6789' WHERE patient_id = '217'
1028	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1988-12-01' WHERE patient_id = '218'
1029	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '888-99-0000' WHERE patient_id = '218'
1030	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Back pain' WHERE patient_id = '218'
1031	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Physical Therapy' WHERE patient_id = '218'
1032	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B-' WHERE patient_id = '218'
1033	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '6011111111111117' WHERE patient_id = '218'
1034	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '11/26' WHERE patient_id = '218'
1035	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-222-5555' WHERE patient_id = '218'
1036	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1993-08-09' WHERE patient_id = '219'
1037	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '999-00-1111' WHERE patient_id = '219'
1038	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Allergies' WHERE patient_id = '219'
1039	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Cetirizine' WHERE patient_id = '219'
1040	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'AB-' WHERE patient_id = '219'
1041	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '6011000400000000' WHERE patient_id = '219'
1042	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '06/27' WHERE patient_id = '219'
1043	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-666-1234' WHERE patient_id = '219'
1044	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1972-04-03' WHERE patient_id = '220'
1045	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '000-11-2222' WHERE patient_id = '220'
1046	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'High cholesterol' WHERE patient_id = '220'
1047	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Atorvastatin' WHERE patient_id = '220'
1048	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A+' WHERE patient_id = '220'
1049	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '378734493671000' WHERE patient_id = '220'
1050	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '02/28' WHERE patient_id = '220'
1051	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-987-6543' WHERE patient_id = '220'
1052	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '221'
1053	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '221'
1054	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '221'
1055	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '221'
1056	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '221'
1057	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '221'
1058	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '221'
1059	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '221'
1060	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '222'
1061	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '222'
1062	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '222'
1063	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '222'
1064	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '222'
1065	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '222'
1066	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '222'
1067	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '222'
1068	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '223'
1069	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '223'
1070	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '223'
1071	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '223'
1072	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '223'
1073	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '223'
1074	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '223'
1075	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '223'
1076	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '224'
1077	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '224'
1078	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '224'
1079	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '224'
1080	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '224'
1081	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '224'
1082	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '224'
1083	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '224'
1084	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '225'
1085	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '225'
1086	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '225'
1087	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '225'
1088	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '225'
1089	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '225'
1090	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '225'
1091	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '225'
1092	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '226'
1093	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '226'
1094	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '226'
1095	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '226'
1096	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '226'
1097	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '226'
1098	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '226'
1099	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '226'
1100	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '227'
1101	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '227'
1102	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '227'
1103	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '227'
1104	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '227'
1105	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '227'
1106	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '227'
1107	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '227'
1108	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '228'
1109	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '228'
1110	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '228'
1111	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '228'
1112	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '228'
1483	2025-08-08 15:58:27	etpparam: UPDATE oid=1, min_id=43, max_id=43
1113	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '228'
1114	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '228'
1115	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '228'
1116	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '229'
1117	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '229'
1118	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '229'
1119	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '229'
1120	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '229'
1121	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '229'
1122	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '229'
1123	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '229'
1124	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '230'
1125	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '230'
1126	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '230'
1127	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '230'
1128	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '230'
1129	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '230'
1130	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '230'
1131	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '230'
1132	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '231'
1133	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '231'
1134	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '231'
1135	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '231'
1136	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '231'
1137	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '231'
1138	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '231'
1139	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '231'
1140	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '232'
1141	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '232'
1142	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '232'
1143	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '232'
1144	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '232'
1145	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '232'
1146	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '232'
1147	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '232'
1148	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '233'
1149	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '233'
1150	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '233'
1151	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '233'
1152	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '233'
1153	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '233'
1154	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '233'
1155	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '233'
1156	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '234'
1157	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '234'
1158	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '234'
1159	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '234'
1160	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '234'
1161	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '234'
1162	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '234'
1163	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '234'
1164	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '235'
1165	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '235'
1166	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '235'
1167	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '235'
1168	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '235'
1169	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '235'
1170	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '235'
1171	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '235'
1172	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '236'
1173	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '236'
1174	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '236'
1175	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '236'
1176	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '236'
1177	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '236'
1178	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '236'
1179	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '236'
1180	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '237'
1181	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '237'
1182	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '237'
1183	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '237'
1184	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '237'
1185	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '237'
1186	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '237'
1187	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '237'
1188	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '238'
1189	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '238'
1190	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '238'
1191	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '238'
1192	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '238'
1193	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '238'
1194	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '238'
1195	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '238'
1196	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '239'
1197	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '239'
1198	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '239'
1199	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '239'
1200	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '239'
1201	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '239'
1202	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '239'
1203	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '239'
1204	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '240'
1205	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '240'
1206	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '240'
1207	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '240'
1208	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '240'
1209	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '240'
1210	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '240'
1211	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '240'
1212	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '241'
1213	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '241'
1214	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '241'
1215	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '241'
1216	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '241'
1217	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '241'
1218	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '241'
1219	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '241'
1220	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '242'
1221	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '242'
1222	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '242'
1223	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '242'
1224	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '242'
1225	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '242'
1226	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '242'
1227	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '242'
1228	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '243'
1229	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '243'
1230	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Asthma' WHERE patient_id = '243'
1231	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Albuterol' WHERE patient_id = '243'
1232	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '243'
1233	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '243'
1234	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '243'
1235	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '243'
1236	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '244'
1237	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '244'
1238	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '244'
1239	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '244'
1240	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '244'
1241	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '244'
1242	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '244'
1243	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '244'
1244	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '245'
1245	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '245'
1246	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '245'
1247	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '245'
1248	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '245'
1249	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '245'
1250	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '245'
1251	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '245'
1252	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '246'
1253	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '246'
1254	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Gsthma' WHERE patient_id = '246'
1255	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Glbuterol' WHERE patient_id = '246'
1256	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '246'
1257	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '246'
1258	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '246'
1259	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '246'
1260	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '247'
1261	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '247'
1262	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '247'
1263	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '247'
1264	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '247'
1265	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '247'
1266	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '247'
1267	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '247'
1268	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '248'
1269	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '248'
1270	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '248'
1271	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '248'
1272	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '248'
1273	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '248'
1274	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '248'
1275	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '248'
1276	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '249'
1277	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '249'
1278	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Gsthma' WHERE patient_id = '249'
1279	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Glbuterol' WHERE patient_id = '249'
1280	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '249'
1281	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '249'
1282	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '249'
1283	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '249'
1284	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '250'
1285	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '250'
1286	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '250'
1287	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '250'
1288	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '250'
1289	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '250'
1290	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '250'
1291	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '250'
1292	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '251'
1293	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '251'
1294	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '251'
1295	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '251'
1296	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '251'
1297	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '251'
1298	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '251'
1299	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '251'
1300	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '252'
1301	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '252'
1302	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Gsthma' WHERE patient_id = '252'
1303	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Glbuterol' WHERE patient_id = '252'
1304	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '252'
1305	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '252'
1306	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '252'
1307	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '252'
1308	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '253'
1309	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '253'
1310	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '253'
1311	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '253'
1312	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '253'
1313	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '253'
1314	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '253'
1315	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '253'
1316	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '254'
1317	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '254'
1318	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '254'
1319	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '254'
1320	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '254'
1321	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '254'
1322	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '254'
1323	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '254'
1324	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '255'
1325	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '255'
1326	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Gsthma' WHERE patient_id = '255'
1327	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Glbuterol' WHERE patient_id = '255'
1328	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '255'
2135	10/06/2025 14:31:18	Timer: Batch 87 set to Processing
1329	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '255'
1330	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '255'
1331	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '255'
1332	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '256'
1333	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '256'
1334	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '256'
1335	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '256'
1336	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '256'
1337	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '256'
1338	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '256'
1339	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '256'
1340	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '257'
1341	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '257'
1342	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '257'
1343	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '257'
1344	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '257'
1345	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '257'
1346	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '257'
1347	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '257'
1348	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1980-05-23' WHERE patient_id = '258'
1349	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '789-12-3456' WHERE patient_id = '258'
1350	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Gsthma' WHERE patient_id = '258'
1351	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Glbuterol' WHERE patient_id = '258'
1352	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'A-' WHERE patient_id = '258'
1353	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4222222222222222' WHERE patient_id = '258'
1354	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '10/25' WHERE patient_id = '258'
1355	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-888-9999' WHERE patient_id = '258'
1356	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1995-07-08' WHERE patient_id = '259'
1357	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '321-54-9876' WHERE patient_id = '259'
1358	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '259'
1359	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '259'
1360	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '259'
1361	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '259'
1362	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '08/27' WHERE patient_id = '259'
1363	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-000-1111' WHERE patient_id = '259'
1364	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '260'
1365	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '260'
1366	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '260'
1367	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '260'
1368	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '260'
1369	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '260'
1370	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '260'
1371	2025-08-07 23:06:59	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '260'
1372	2025-08-07 23:06:59	FBatch6: Source table updated using etpfetrt records with mapped field names
1373	2025-08-07 23:06:59	FBatch6: Completed successfully
1374	2025-08-07 23:55:33	etpparam: UPDATE oid=1, min_id=208, max_id=208
1375	 8/07/2025 23:56:29	CopyPACtoFRQ: Using min_guestbookid=126, max_guestbookid=126
1376	 8/07/2025 23:56:29	CopyPACtoFRQ: Found GuestbookID=126, oid=34
1377	 8/07/2025 23:56:35	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
1378	2025-08-07 23:56:37.655213-04	StartFetchProc: Started fetch process
1379	2025-08-07 23:56:40	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
1380	2025-08-07 23:56:57	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
1381	2025-08-07 23:56:57	FBatch5: etpfetrt table found, starting poll
1382	2025-08-07 23:56:57	FBatch5: Retry 1/60: etpfetrt has 8 rows
1383	2025-08-07 23:56:57	FBatch5: etpfetrt contains 8 rows. Processing complete.
1384	2025-08-07 23:56:57	FBatch5: Batch OID 124 marked as Completed. EndTime: 2025-08-07 23:56:57, ExecutionTime: 00:00:28
1385	2025-08-07 23:56:57	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 115
2136	2025-10-06 14:31:18	etpparam: UPDATE oid=1, min_id=43, max_id=43
1386	2025-08-07 23:56:58	FBatch6: Starting update of source records from etpfetrt using etpprofm
1387	2025-08-07 23:56:58	FBatch6: Found 8 matching records in etpfetrt and etpprofm
1388	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET birthdate = '1952-01-15' WHERE patient_id = '208'
1389	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET ssn = '158-84-6789' WHERE patient_id = '208'
1390	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Hypertension' WHERE patient_id = '208'
1391	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET medications = 'Lisinopril' WHERE patient_id = '208'
1392	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET blood_type = 'O+' WHERE patient_id = '208'
1393	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET credit_card_number = '4111111111111111' WHERE patient_id = '208'
1394	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '12/26' WHERE patient_id = '208'
1395	2025-08-07 23:56:58	FBatch6: Executing: UPDATE patients SET employer_phone = '555-654-3210' WHERE patient_id = '208'
1396	2025-08-07 23:56:58	FBatch6: Source table updated using etpfetrt records with mapped field names
1397	2025-08-07 23:56:58	FBatch6: Completed successfully
1398	2025-08-07 23:56:58.50079-04	StartFetchProc: Fetch process completed successfully
1399	2025-08-08 15:47:56	etpparam: UPDATE oid=1, min_id=135, max_id=115
1400	2025-08-08 15:48:16	etpparam: UPDATE oid=1, min_id=135, max_id=116
1401	 8/08/2025 15:50:43	CopyPACtoFRQ: Using min_guestbookid=135, max_guestbookid=116
1402	 8/08/2025 15:50:55	CopyPACtoFRQ: Copied 0 records to etpfetrq: 
1403	2025-08-08 15:51:00.033777-04	StartFetchProc: Started fetch process
1404	2025-08-08 15:56:08	etpparam: UPDATE oid=1, min_id=43, max_id=43
1405	2025-08-08 15:56:23	PBatch1.sql: Starting conditional truncate of ETPProRq. StartTime: 2025-08-08 15:56:23
1406	2025-08-08 15:56:23	PBatch1.sql: Truncated ETPProRq. Elapsed: 00:00
1407	2025-08-08 15:56:23	PBatch1.sql: Starting ETPProRq population. StartTime: 2025-08-08 15:56:23
1408	2025-08-08 15:56:23	PBatch1.sql: Using TemplateNumber: 192, DBTableName: patients, UniqueSourceColumn: patient_id. Elapsed: 00:00
1409	2025-08-08 15:56:23	PBatch1.sql: Batch record created with BatchNumber: 83. Elapsed: 00:00
1410	2025-08-08 15:56:23	etpparam: UPDATE oid=1, min_id=43, max_id=43
1411	2025-08-08 15:56:23	PBatch1.sql: Updated ETPParam with Batch OID: 83. Elapsed: 00:00
1412	2025-08-08 15:56:23	PBatch1.sql: Updated etpprobt with 1 records for BatchNumber: 83. Elapsed: 00:00
1413	2025-08-08 15:56:23	PBatch1.sql: ETPProRq populated with 8 records. EndTime: 2025-08-08 15:56:23, Elapsed: 00:00
1414	2025-08-08 15:56:23	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-08-08 15:56:23
1415	2025-08-08 15:56:35	PBatch3.bat: ETPProRt populated with 1 records. EndTime: 2025-08-08 15:56:35, Elapsed: 00:12
1416	2025-08-08 15:56:35	PBatch4.sql: Retry 1/60: ETPProRt has 1 rows
1417	2025-08-08 15:56:35	PBatch4.sql: ETPProRt contains 1 rows. Processing complete.
1418	2025-08-08 15:56:35	PBatch4.sql: No Processing batch found in ETPProBt.
1419	2025-08-08 15:56:36	PBatch6.sql: Starting ETPProTp population. StartTime: 2025-08-08 15:56:36
1420	2025-08-08 15:56:36	PBatch6.sql: Truncated ETPProTp with RESTART IDENTITY. Elapsed: 00:00
1421	2025-08-08 15:56:36	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1422	2025-08-08 15:56:36	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1423	2025-08-08 15:56:36	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1424	2025-08-08 15:56:36	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1425	2025-08-08 15:56:36	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1426	2025-08-08 15:56:36	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1427	2025-08-08 15:56:36	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1428	2025-08-08 15:56:36	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1429	2025-08-08 15:56:36	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1430	2025-08-08 15:56:36	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1431	2025-08-08 15:56:36	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1432	2025-08-08 15:56:36	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1433	2025-08-08 15:56:36	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1434	2025-08-08 15:56:36	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1435	2025-08-08 15:56:36	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1436	2025-08-08 15:56:36	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1437	2025-08-08 15:56:36	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1438	2025-08-08 15:56:36	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1439	2025-08-08 15:56:36	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1440	2025-08-08 15:56:36	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1441	2025-08-08 15:56:36	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1442	2025-08-08 15:56:36	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1443	2025-08-08 15:56:36	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1444	2025-08-08 15:56:36	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1445	2025-08-08 15:56:36	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1446	2025-08-08 15:56:36	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1447	2025-08-08 15:56:36	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1448	2025-08-08 15:56:36	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1449	2025-08-08 15:56:36	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1450	2025-08-08 15:56:36	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1451	2025-08-08 15:56:36	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1452	2025-08-08 15:56:36	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1453	2025-08-08 15:56:36	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1454	2025-08-08 15:56:36	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1455	2025-08-08 15:56:36	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1456	2025-08-08 15:56:36	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1457	2025-08-08 15:56:36	PBatch6.sql: ETPProTp populated successfully. EndTime: 2025-08-08 15:56:36, Elapsed: 00:00
1458	2025-08-08 15:56:36	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-08-08 15:56:36
1459	2025-08-08 15:56:36	PBatch7.sql: Batch OID 302 marked as Completed. EndTime: 2025-08-08 15:56:36, ExecutionTime: 00:00:13
1460	2025-08-08 15:56:37	PBatch8.sql: Starting masking process. StartTime: 2025-08-08 15:56:37
1461	2025-08-08 15:56:37	PBatch8.sql: Using unique source column: patient_id. Elapsed: 00:00
1462	2025-08-08 15:56:37	PBatch8.sql: Processing ImportID: 43. Elapsed: 00:00
1463	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: 1801-01-01 to field: birthdate. Elapsed: 00:00
1464	2025-08-08 15:56:37	PBatch8.sql: Updated field birthdate with masked value 1801-01-01 for ImportID 43. Elapsed: 00:00
1465	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: ************** to field: ssn. Elapsed: 00:00
1466	2025-08-08 15:56:37	PBatch8.sql: Updated field ssn with masked value ************** for ImportID 43. Elapsed: 00:00
1467	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: * to field: medical_conditions. Elapsed: 00:00
1468	2025-08-08 15:56:37	PBatch8.sql: Updated field medical_conditions with masked value * for ImportID 43. Elapsed: 00:00
1469	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: * to field: medications. Elapsed: 00:00
1470	2025-08-08 15:56:37	PBatch8.sql: Updated field medications with masked value * for ImportID 43. Elapsed: 00:00
1471	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: **** to field: blood_type. Elapsed: 00:00
1472	2025-08-08 15:56:37	PBatch8.sql: Updated field blood_type with masked value **** for ImportID 43. Elapsed: 00:00
1473	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: ****************** to field: credit_card_number. Elapsed: 00:00
1474	2025-08-08 15:56:37	PBatch8.sql: Updated field credit_card_number with masked value ****************** for ImportID 43. Elapsed: 00:00
1475	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: **** to field: credit_card_expiry. Elapsed: 00:00
1476	2025-08-08 15:56:37	PBatch8.sql: Updated field credit_card_expiry with masked value **** for ImportID 43. Elapsed: 00:00
1477	2025-08-08 15:56:37	PBatch8.sql: Applying masked value: ************** to field: employer_phone. Elapsed: 00:00
1478	2025-08-08 15:56:37	PBatch8.sql: Updated field employer_phone with masked value ************** for ImportID 43. Elapsed: 00:00
1479	2025-08-08 15:56:37	PBatch8.sql: Masking completed successfully for 8 records. EndTime: 2025-08-08 15:56:37, Elapsed: 00:00
1480	2025-08-08 15:56:37	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-08-08 15:56:37
1481	2025-08-08 15:56:37	PBatch9.sql: ETPProAC populated with 1 records. EndTime: 2025-08-08 15:56:37, Elapsed: 00:00
1484	 8/08/2025 15:58:47	CopyPACtoFRQ: Using min_guestbookid=294, max_guestbookid=294
1485	 8/08/2025 15:58:47	CopyPACtoFRQ: Found GuestbookID=294, oid=105
1486	 8/08/2025 15:58:58	CopyPACtoFRQ: Copied 1 records to etpfetrq: 
1487	2025-08-08 15:59:01.155311-04	StartFetchProc: Started fetch process
1488	2025-08-08 15:59:03	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
1489	2025-08-08 15:59:17	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
1490	2025-08-08 15:59:17	FBatch5: etpfetrt table found, starting poll
1491	2025-08-08 15:59:17	FBatch5: Retry 1/60: etpfetrt has 8 rows
1492	2025-08-08 15:59:17	FBatch5: etpfetrt contains 8 rows. Processing complete.
1493	2025-08-08 15:59:17	FBatch5: Batch OID 126 marked as Completed. EndTime: 2025-08-08 15:59:17, ExecutionTime: 00:00:30
1494	2025-08-08 15:59:17	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 117
1495	2025-08-08 15:59:17	FBatch6: Starting update of source records from etpfetrt using etpprofm
1496	2025-08-08 15:59:17	FBatch6: Found 8 matching records in etpfetrt and etpprofm
1497	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET birthdate = '1975-08-30' WHERE patient_id = '43'
1498	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET ssn = '555-44-3333' WHERE patient_id = '43'
1499	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '43'
1500	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '43'
1501	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '43'
1502	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '43'
1503	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '09/24' WHERE patient_id = '43'
1504	2025-08-08 15:59:17	FBatch6: Executing: UPDATE patients SET employer_phone = '555-234-5678' WHERE patient_id = '43'
1505	2025-08-08 15:59:17	FBatch6: Source table updated using etpfetrt records with mapped field names
1506	2025-08-08 15:59:17	FBatch6: Completed successfully
1507	2025-08-08 15:59:18.182342-04	StartFetchProc: Fetch process completed successfully
1508	 8/10/2025 16:13:19	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1509	 8/10/2025 16:13:41	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1510	 8/10/2025 16:14:13	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1511	 8/10/2025 17:23:42	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1512	 8/10/2025 17:43:27	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1513	 8/10/2025 17:54:49	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1514	 8/10/2025 18:35:56	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1515	 8/10/2025 18:45:34	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1516	 8/10/2025 19:40:41	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1517	 8/10/2025 19:45:06	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1518	 8/10/2025 19:51:13	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1519	 8/10/2025 20:02:21	PFM_SQL_To_PFM_String: No records found for TemplateNumber=192
1520	 8/10/2025 21:52:35	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1521	 8/10/2025 22:06:10	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate
1522	 8/10/2025 22:13:18	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry
1523	 8/10/2025 22:32:28	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry
1524	 8/10/2025 22:32:58	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry,D8=gender
1525	 8/10/2025 22:34:04	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry,D8=gender
1526	 8/10/2025 22:34:09	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry
1527	 8/10/2025 22:37:40	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number
1528	 8/10/2025 22:46:21	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=code
1529	 8/10/2025 22:50:42	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number
1530	 8/11/2025 13:26:33	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D5=blood_type,D6=credit_card_number
1531	2025-08-11 14:17:28	PBatch6.sql: Starting ETPProTp population. StartTime: 2025-08-11 14:17:28
1532	2025-08-11 14:17:28	PBatch6.sql: Truncated ETPProTp with RESTART IDENTITY. Elapsed: 00:00
1533	2025-08-11 14:17:28	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1534	2025-08-11 14:17:28	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1535	2025-08-11 14:17:28	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1536	2025-08-11 14:17:28	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1537	2025-08-11 14:17:28	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1538	2025-08-11 14:17:28	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1539	2025-08-11 14:17:28	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1540	2025-08-11 14:17:28	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1541	2025-08-11 14:17:28	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1542	2025-08-11 14:17:28	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1543	2025-08-11 14:17:28	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1544	2025-08-11 14:17:28	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1545	2025-08-11 14:17:28	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1546	2025-08-11 14:17:28	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1547	2025-08-11 14:17:28	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1548	2025-08-11 14:17:28	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1549	2025-08-11 14:17:28	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1550	2025-08-11 14:17:28	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1551	2025-08-11 14:17:28	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1552	2025-08-11 14:17:28	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1553	2025-08-11 14:17:28	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1554	2025-08-11 14:17:28	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1555	2025-08-11 14:17:28	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1556	2025-08-11 14:17:28	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1557	2025-08-11 14:17:28	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1558	2025-08-11 14:17:28	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1559	2025-08-11 14:17:28	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1560	2025-08-11 14:17:28	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1561	2025-08-11 14:17:28	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1562	2025-08-11 14:17:28	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1563	2025-08-11 14:17:28	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1564	2025-08-11 14:17:28	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1565	2025-08-11 14:17:28	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1566	2025-08-11 14:17:28	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1567	2025-08-11 14:17:28	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1568	2025-08-11 14:17:28	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1569	2025-08-11 14:17:28	PBatch6.sql: ETPProTp populated successfully. EndTime: 2025-08-11 14:17:28, Elapsed: 00:00
1570	 8/25/2025 20:45:45	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=blood_type,D6=credit_card_number,D7=credit_card_expiry,D8=employer_phone,D29=passport_number
1571	 8/25/2025 20:59:47	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D1=ssn,D1=medical_conditions,D1=medications,D1=gender,D1=blood_type,D1=credit_card_number,D1=credit_card_expiry,D1=employer_phone,D1=passport_number
1572	 8/25/2025 21:02:12	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number
1573	 8/25/2025 21:03:57	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1574	 8/25/2025 21:09:52	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1575	 8/25/2025 21:13:02	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1576	 8/25/2025 21:18:45	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1577	 8/26/2025 12:31:49	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1578	 8/26/2025 12:32:31	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number
1579	 8/26/2025 12:58:25	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number,D11=occupation
1580	 8/26/2025 13:09:06	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number
1581	 8/26/2025 13:26:17	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=credit_card_expiry,D9=employer_phone,D10=passport_number
1582	 8/26/2025 13:28:38	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number
1583	 8/26/2025 13:29:54	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=emergency_contact_name
1584	 8/26/2025 13:30:51	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=emergency_contact_name,D9=emergency_contact_phone
1585	 8/26/2025 13:31:24	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=address,D9=emergency_contact_name,D10=emergency_contact_phone
1586	 8/26/2025 13:31:57	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=address,D9=emergency_contact_name,D10=emergency_contact_phone
1587	 8/26/2025 13:36:47	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=address,D9=emergency_contact_name,D10=emergency_contact_phone
1588	 8/26/2025 13:38:36	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=emergency_contact_name,D9=emergency_contact_phone,D10=address
1589	 8/26/2025 13:39:31	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=notes,D2=birthdate,D3=ssn,D4=medical_conditions,D5=medications,D6=gender,D7=blood_type,D8=credit_card_number,D9=emergency_contact_name,D10=emergency_contact_phone,D11=address
1590	 8/26/2025 13:40:02	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192 to D1=birthdate,D2=ssn,D3=medical_conditions,D4=medications,D5=gender,D6=blood_type,D7=credit_card_number,D8=emergency_contact_name,D9=emergency_contact_phone,D10=address,D11=notes
1612	 8/26/2025 14:15:20	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1613	 8/26/2025 14:16:50	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1614	 8/26/2025 14:22:24	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1615	 8/26/2025 14:25:15	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1616	 8/26/2025 14:26:18	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1617	 8/26/2025 15:18:01	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1618	 8/26/2025 15:19:49	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1619	 8/26/2025 16:04:46	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1620	 8/26/2025 16:05:49	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1621	 8/26/2025 19:27:12	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1622	 8/26/2025 19:38:03	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1623	 8/26/2025 20:22:59	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1624	 8/26/2025 21:11:10	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1625	 8/26/2025 21:23:56	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1626	 8/26/2025 22:31:43	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1627	 8/26/2025 22:36:15	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1628	 8/26/2025 22:38:36	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1629	 8/26/2025 22:48:31	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1630	 8/26/2025 22:50:22	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1631	 8/26/2025 22:55:57	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1632	 8/26/2025 22:57:37	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1633	 8/26/2025 23:00:04	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1634	 8/26/2025 23:02:14	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1635	 8/26/2025 23:02:51	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1636	 8/26/2025 23:03:52	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1637	 8/27/2025 12:43:58	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1638	 8/27/2025 12:44:56	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1639	 8/27/2025 12:45:54	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1640	 8/27/2025 12:46:21	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1641	 8/27/2025 12:47:12	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1642	 8/27/2025 12:54:37	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1643	 8/27/2025 13:36:06	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1644	 8/27/2025 13:41:38	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1645	 8/27/2025 13:42:48	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1646	 8/27/2025 13:44:19	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1647	 8/27/2025 13:50:32	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1648	 8/27/2025 14:18:54	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1649	 8/27/2025 15:09:46	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1650	 8/27/2025 17:08:38	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1651	 8/27/2025 17:12:21	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1652	 8/27/2025 17:57:50	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1653	 8/27/2025 18:01:02	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1654	 8/27/2025 18:01:14	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1655	 8/27/2025 18:03:32	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1656	 8/27/2025 18:04:08	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1657	 8/27/2025 18:04:56	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2139	10/06/2025 20:14:53	Timer: Detected Ready batch 88
1658	 8/27/2025 18:38:35	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1659	 8/27/2025 18:46:43	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1660	 8/27/2025 18:47:49	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1661	 8/27/2025 18:48:39	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1662	 8/28/2025 12:58:43	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1663	 8/28/2025 15:19:17	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1664	2025-08-28 15:19:19	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-08-28 15:19:19
1665	2025-08-28 15:19:19	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1666	2025-08-28 15:19:19	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1667	2025-08-28 15:19:19	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1668	2025-08-28 15:19:19	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1669	2025-08-28 15:19:19	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1670	2025-08-28 15:19:19	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1671	2025-08-28 15:19:19	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1672	2025-08-28 15:19:19	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1673	2025-08-28 15:19:19	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1674	2025-08-28 15:19:19	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1675	2025-08-28 15:19:19	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1676	2025-08-28 15:19:19	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1677	2025-08-28 15:19:19	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1678	2025-08-28 15:19:19	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1679	2025-08-28 15:19:19	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1680	2025-08-28 15:19:19	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1681	2025-08-28 15:19:19	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1682	2025-08-28 15:19:19	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1683	2025-08-28 15:19:19	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1684	2025-08-28 15:19:19	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1685	2025-08-28 15:19:19	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1686	2025-08-28 15:19:19	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1687	2025-08-28 15:19:19	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1688	2025-08-28 15:19:19	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1689	2025-08-28 15:19:19	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1690	2025-08-28 15:19:19	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1691	2025-08-28 15:19:19	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1692	2025-08-28 15:19:19	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1693	2025-08-28 15:19:19	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1694	2025-08-28 15:19:19	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1695	2025-08-28 15:19:19	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1696	2025-08-28 15:19:19	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1697	2025-08-28 15:19:19	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1698	2025-08-28 15:19:19	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1699	2025-08-28 15:19:19	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1700	2025-08-28 15:19:19	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1701	2025-08-28 15:19:19	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1702	2025-08-28 15:19:19	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-08-28 15:19:19, Elapsed: 00:00
1703	2025-08-28 20:18:07	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-08-28 20:18:07
1704	2025-08-28 20:18:07	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1705	2025-08-28 20:18:07	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1706	2025-08-28 20:18:07	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1707	2025-08-28 20:18:07	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1708	2025-08-28 20:18:07	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1709	2025-08-28 20:18:07	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1710	2025-08-28 20:18:07	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1711	2025-08-28 20:18:07	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1712	2025-08-28 20:18:07	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1713	2025-08-28 20:18:07	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1714	2025-08-28 20:18:07	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1715	2025-08-28 20:18:07	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1716	2025-08-28 20:18:07	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1717	2025-08-28 20:18:07	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1718	2025-08-28 20:18:07	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1719	2025-08-28 20:18:07	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1720	2025-08-28 20:18:07	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1721	2025-08-28 20:18:07	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1722	2025-08-28 20:18:07	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1723	2025-08-28 20:18:07	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1724	2025-08-28 20:18:07	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1725	2025-08-28 20:18:07	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1726	2025-08-28 20:18:07	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1727	2025-08-28 20:18:07	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1728	2025-08-28 20:18:07	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1729	2025-08-28 20:18:07	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1730	2025-08-28 20:18:07	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1731	2025-08-28 20:18:07	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1732	2025-08-28 20:18:07	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1733	2025-08-28 20:18:07	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1734	2025-08-28 20:18:07	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1735	2025-08-28 20:18:07	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1736	2025-08-28 20:18:07	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1737	2025-08-28 20:18:07	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1738	2025-08-28 20:18:07	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1739	2025-08-28 20:18:07	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1740	2025-08-28 20:18:07	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1741	2025-08-28 20:18:07	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-08-28 20:18:07, Elapsed: 00:00
1742	 8/28/2025 20:21:21	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1743	 8/28/2025 20:43:36	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1744	2025-08-29 11:51:27	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-08-29 11:51:27
1745	2025-08-29 11:51:27	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1746	2025-08-29 11:51:27	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1747	2025-08-29 11:51:27	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1748	2025-08-29 11:51:27	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1749	2025-08-29 11:51:27	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1750	2025-08-29 11:51:27	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1751	2025-08-29 11:51:27	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1752	2025-08-29 11:51:27	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1753	2025-08-29 11:51:27	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1754	2025-08-29 11:51:27	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1755	2025-08-29 11:51:27	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1756	2025-08-29 11:51:27	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1757	2025-08-29 11:51:27	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1758	2025-08-29 11:51:27	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1759	2025-08-29 11:51:27	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1760	2025-08-29 11:51:27	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1761	2025-08-29 11:51:27	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1762	2025-08-29 11:51:27	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1763	2025-08-29 11:51:27	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1764	2025-08-29 11:51:27	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1765	2025-08-29 11:51:27	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1766	2025-08-29 11:51:27	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1767	2025-08-29 11:51:27	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1768	2025-08-29 11:51:27	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1769	2025-08-29 11:51:27	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1770	2025-08-29 11:51:27	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1771	2025-08-29 11:51:27	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1772	2025-08-29 11:51:27	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1773	2025-08-29 11:51:27	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1774	2025-08-29 11:51:27	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1775	2025-08-29 11:51:27	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
2140	10/06/2025 20:14:53	Timer: Batch 88 set to Processing
1776	2025-08-29 11:51:27	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1777	2025-08-29 11:51:27	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1778	2025-08-29 11:51:27	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1779	2025-08-29 11:51:27	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1780	2025-08-29 11:51:27	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1781	2025-08-29 11:51:27	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1782	2025-08-29 11:51:27	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-08-29 11:51:27, Elapsed: 00:00
1783	 8/31/2025 18:14:37	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1784	 9/01/2025 18:20:17	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1785	 9/02/2025 19:13:17	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
1786	2025-09-02 19:14:58	etpparam: UPDATE oid=1, min_id=263, max_id=263
1787	2025-09-02 19:15:09	PBatch1.sql: Starting conditional truncate of ETPProRq. StartTime: 2025-09-02 19:15:09
1788	2025-09-02 19:15:09	PBatch1.sql: Truncated ETPProRq. Elapsed: 00:00
1789	2025-09-02 19:15:09	PBatch1.sql: Starting ETPProRq population. StartTime: 2025-09-02 19:15:09
1790	2025-09-02 19:15:09	PBatch1.sql: Using TemplateNumber: 192, DBTableName: patients, UniqueSourceColumn: patient_id. Elapsed: 00:00
1791	2025-09-02 19:15:09	PBatch1.sql: Batch record created with BatchNumber: 84. Elapsed: 00:00
1792	2025-09-02 19:15:09	etpparam: UPDATE oid=1, min_id=263, max_id=263
1793	2025-09-02 19:15:09	PBatch1.sql: Updated ETPParam with Batch OID: 84. Elapsed: 00:00
1794	2025-09-02 19:15:09	PBatch1.sql: Updated etpprobt with 1 records for BatchNumber: 84. Elapsed: 00:00
1795	2025-09-02 19:15:09	PBatch1.sql: ETPProRq populated with 8 records. EndTime: 2025-09-02 19:15:09, Elapsed: 00:00
1796	2025-09-02 19:15:09	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-09-02 19:15:09
1797	2025-09-02 19:15:16	PBatch3.bat: ETPProRt populated with 1 records. EndTime: 2025-09-02 19:15:16, Elapsed: 00:07
1798	2025-09-02 19:15:17	PBatch4.sql: Retry 1/60: ETPProRt has 1 rows
1799	2025-09-02 19:15:17	PBatch4.sql: ETPProRt contains 1 rows. Processing complete.
1800	2025-09-02 19:15:17	PBatch4.sql: No Processing batch found in ETPProBt.
1801	2025-09-02 19:15:17	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-09-02 19:15:17
1802	2025-09-02 19:15:17	PBatch7.sql: Batch OID 303 marked as Completed. EndTime: 2025-09-02 19:15:17, ExecutionTime: 00:00:08
1803	2025-09-02 19:15:18	PBatch8.sql: Starting masking process. StartTime: 2025-09-02 19:15:18
1804	2025-09-02 19:15:18	PBatch8.sql: Using unique source column: patient_id. Elapsed: 00:00
1805	2025-09-02 19:15:18	PBatch8.sql: Processing ImportID: 263. Elapsed: 00:00
1806	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: 1801-01-01 to field: birthdate. Elapsed: 00:00
1807	2025-09-02 19:15:18	PBatch8.sql: Updated field birthdate with masked value 1801-01-01 for ImportID 263. Elapsed: 00:00
1808	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: ************** to field: ssn. Elapsed: 00:00
1809	2025-09-02 19:15:18	PBatch8.sql: Updated field ssn with masked value ************** for ImportID 263. Elapsed: 00:00
1810	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: * to field: medical_conditions. Elapsed: 00:00
1811	2025-09-02 19:15:18	PBatch8.sql: Updated field medical_conditions with masked value * for ImportID 263. Elapsed: 00:00
1812	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: * to field: medications. Elapsed: 00:00
1813	2025-09-02 19:15:18	PBatch8.sql: Updated field medications with masked value * for ImportID 263. Elapsed: 00:00
1814	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: **** to field: blood_type. Elapsed: 00:00
1815	2025-09-02 19:15:18	PBatch8.sql: Updated field blood_type with masked value **** for ImportID 263. Elapsed: 00:00
1816	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: ****************** to field: credit_card_number. Elapsed: 00:00
1817	2025-09-02 19:15:18	PBatch8.sql: Updated field credit_card_number with masked value ****************** for ImportID 263. Elapsed: 00:00
1818	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: **** to field: credit_card_expiry. Elapsed: 00:00
1819	2025-09-02 19:15:18	PBatch8.sql: Updated field credit_card_expiry with masked value **** for ImportID 263. Elapsed: 00:00
1820	2025-09-02 19:15:18	PBatch8.sql: Applying masked value: ************** to field: employer_phone. Elapsed: 00:00
1821	2025-09-02 19:15:18	PBatch8.sql: Updated field employer_phone with masked value ************** for ImportID 263. Elapsed: 00:00
1822	2025-09-02 19:15:18	PBatch8.sql: Masking completed successfully for 8 records. EndTime: 2025-09-02 19:15:18, Elapsed: 00:00
1823	2025-09-02 19:15:18	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-09-02 19:15:18
1824	2025-09-02 19:15:18	PBatch9.sql: ETPProAC populated with 1 records. EndTime: 2025-09-02 19:15:18, Elapsed: 00:00
1825	2025-09-06 11:46:10	etpparam: UPDATE oid=1, min_id=43, max_id=43
1826	2025-09-06 11:46:13	PBatch1.sql: Starting conditional truncate of ETPProRq. StartTime: 2025-09-06 11:46:13
1827	2025-09-06 11:46:13	PBatch1.sql: Truncated ETPProRq. Elapsed: 00:00
1828	2025-09-06 11:46:13	PBatch1.sql: Starting ETPProRq population. StartTime: 2025-09-06 11:46:13
1829	2025-09-06 11:46:13	PBatch1.sql: Using TemplateNumber: 192, DBTableName: patients, UniqueSourceColumn: patient_id. Elapsed: 00:00
1830	2025-09-06 11:46:13	PBatch1.sql: Batch record created with BatchNumber: 85. Elapsed: 00:00
1831	2025-09-06 11:46:13	etpparam: UPDATE oid=1, min_id=43, max_id=43
1832	2025-09-06 11:46:13	PBatch1.sql: Updated ETPParam with Batch OID: 85. Elapsed: 00:00
1833	2025-09-06 11:46:13	PBatch1.sql: Updated etpprobt with 1 records for BatchNumber: 85. Elapsed: 00:00
1834	2025-09-06 11:46:13	PBatch1.sql: ETPProRq populated with 8 records. EndTime: 2025-09-06 11:46:13, Elapsed: 00:00
1835	2025-09-06 11:46:14	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-09-06 11:46:14
1836	2025-09-06 11:46:24	PBatch3.bat: ETPProRt populated with 1 records. EndTime: 2025-09-06 11:46:24, Elapsed: 00:10
1837	2025-09-06 11:46:24	PBatch4.sql: Retry 1/60: ETPProRt has 1 rows
1838	2025-09-06 11:46:24	PBatch4.sql: ETPProRt contains 1 rows. Processing complete.
1839	2025-09-06 11:46:24	PBatch4.sql: No Processing batch found in ETPProBt.
1840	2025-09-06 11:46:25	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-09-06 11:46:25
1841	2025-09-06 11:46:25	PBatch7.sql: Batch OID 304 marked as Completed. EndTime: 2025-09-06 11:46:25, ExecutionTime: 00:00:12
1842	2025-09-06 11:46:25	PBatch8.sql: Starting masking process. StartTime: 2025-09-06 11:46:25
1843	2025-09-06 11:46:25	PBatch8.sql: Using unique source column: patient_id. Elapsed: 00:00
1844	2025-09-06 11:46:25	PBatch8.sql: Processing ImportID: 43. Elapsed: 00:00
1845	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: 1801-01-01 to field: birthdate. Elapsed: 00:00
1846	2025-09-06 11:46:25	PBatch8.sql: Updated field birthdate with masked value 1801-01-01 for ImportID 43. Elapsed: 00:00
1847	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: ************** to field: ssn. Elapsed: 00:00
1848	2025-09-06 11:46:25	PBatch8.sql: Updated field ssn with masked value ************** for ImportID 43. Elapsed: 00:00
1849	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: * to field: medical_conditions. Elapsed: 00:00
1850	2025-09-06 11:46:25	PBatch8.sql: Updated field medical_conditions with masked value * for ImportID 43. Elapsed: 00:00
1851	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: * to field: medications. Elapsed: 00:00
1852	2025-09-06 11:46:25	PBatch8.sql: Updated field medications with masked value * for ImportID 43. Elapsed: 00:00
1853	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: **** to field: blood_type. Elapsed: 00:00
1854	2025-09-06 11:46:25	PBatch8.sql: Updated field blood_type with masked value **** for ImportID 43. Elapsed: 00:00
1855	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: ****************** to field: credit_card_number. Elapsed: 00:00
1856	2025-09-06 11:46:25	PBatch8.sql: Updated field credit_card_number with masked value ****************** for ImportID 43. Elapsed: 00:00
1857	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: **** to field: credit_card_expiry. Elapsed: 00:00
1858	2025-09-06 11:46:25	PBatch8.sql: Updated field credit_card_expiry with masked value **** for ImportID 43. Elapsed: 00:00
1859	2025-09-06 11:46:25	PBatch8.sql: Applying masked value: ************** to field: employer_phone. Elapsed: 00:00
1860	2025-09-06 11:46:25	PBatch8.sql: Updated field employer_phone with masked value ************** for ImportID 43. Elapsed: 00:00
1861	2025-09-06 11:46:25	PBatch8.sql: Masking completed successfully for 8 records. EndTime: 2025-09-06 11:46:25, Elapsed: 00:00
1862	2025-09-06 11:46:25	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-09-06 11:46:25
1863	2025-09-06 11:46:25	PBatch9.sql: ETPProAC populated with 1 records. EndTime: 2025-09-06 11:46:25, Elapsed: 00:00
1864	2025-09-06 11:59:58	etpparam: UPDATE oid=1, min_id=43, max_id=43
1865	 9/06/2025 12:00:14	CopyPACtoFRQ: Using min_guestbookid=297, max_guestbookid=297
1866	 9/06/2025 12:00:15	CopyPACtoFRQ: Found GuestbookID=297, oid=108
1867	 9/06/2025 12:00:32	CopyPACtoFRQ: Copied 1 records to etpfetrq: 
1868	2025-09-06 12:00:34.196831-04	StartFetchProc: Started fetch process
1869	2025-09-06 12:01:25	FBatch4: Started running ETPFet.exe with ETPFetRq.xml
1870	2025-09-06 12:01:40	FBatch4: Successfully ran ETPFet.exe with ETPFetRq.xml
1871	2025-09-06 12:01:41	FBatch5: etpfetrt table found, starting poll
1872	2025-09-06 12:01:41	FBatch5: Retry 1/60: etpfetrt has 8 rows
1873	2025-09-06 12:01:41	FBatch5: etpfetrt contains 8 rows. Processing complete.
1874	2025-09-06 12:01:41	FBatch5: Batch OID 127 marked as Completed. EndTime: 2025-09-06 12:01:41, ExecutionTime: 00:01:26
1875	2025-09-06 12:01:41	FBatch5: Updated 0 etppaclog records to Consumed for batchnumber: 118
1876	2025-09-06 12:01:41	FBatch6: Starting update of source records from etpfetrt using etpprofm
1877	2025-09-06 12:01:41	FBatch6: Found 8 matching records in etpfetrt and etpprofm
1878	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET birthdate = '1975-08-30' WHERE patient_id = '43'
1879	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET ssn = '555-44-3333' WHERE patient_id = '43'
1880	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET medical_conditions = 'Diabetes' WHERE patient_id = '43'
1881	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET medications = 'Metformin' WHERE patient_id = '43'
1882	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET blood_type = 'B+' WHERE patient_id = '43'
1883	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET credit_card_number = '4333333333333333' WHERE patient_id = '43'
1884	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET credit_card_expiry = '09/24' WHERE patient_id = '43'
1885	2025-09-06 12:01:41	FBatch6: Executing: UPDATE patients SET employer_phone = '555-234-5678' WHERE patient_id = '43'
1886	2025-09-06 12:01:41	FBatch6: Source table updated using etpfetrt records with mapped field names
1887	2025-09-06 12:01:41	FBatch6: Completed successfully
1888	2025-09-06 12:01:41.944687-04	StartFetchProc: Fetch process completed successfully
1889	2025-09-29 14:37:03	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 14:37:03
1890	2025-09-29 14:37:03	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1891	2025-09-29 14:37:03	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1892	2025-09-29 14:37:03	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1893	2025-09-29 14:37:03	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1894	2025-09-29 14:37:03	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1895	2025-09-29 14:37:03	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1896	2025-09-29 14:37:03	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1897	2025-09-29 14:37:03	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1898	2025-09-29 14:37:03	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1899	2025-09-29 14:37:03	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1900	2025-09-29 14:37:03	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1901	2025-09-29 14:37:03	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1902	2025-09-29 14:37:03	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1903	2025-09-29 14:37:03	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1904	2025-09-29 14:37:03	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1905	2025-09-29 14:37:03	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1906	2025-09-29 14:37:03	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1907	2025-09-29 14:37:03	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1908	2025-09-29 14:37:03	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1909	2025-09-29 14:37:03	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1910	2025-09-29 14:37:03	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1911	2025-09-29 14:37:03	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1912	2025-09-29 14:37:03	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1913	2025-09-29 14:37:03	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1914	2025-09-29 14:37:03	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1915	2025-09-29 14:37:03	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1916	2025-09-29 14:37:03	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1917	2025-09-29 14:37:03	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1918	2025-09-29 14:37:03	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1919	2025-09-29 14:37:03	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1920	2025-09-29 14:37:03	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1921	2025-09-29 14:37:03	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1922	2025-09-29 14:37:03	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1923	2025-09-29 14:37:03	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1924	2025-09-29 14:37:03	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1925	2025-09-29 14:37:03	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1926	2025-09-29 14:37:03	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1927	2025-09-29 14:37:03	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-09-29 14:37:03, Elapsed: 00:00
1928	2025-09-29 14:44:14	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 14:44:14
1929	2025-09-29 14:44:14	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1930	2025-09-29 14:44:14	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1931	2025-09-29 14:44:14	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1932	2025-09-29 14:44:14	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1933	2025-09-29 14:44:14	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1934	2025-09-29 14:44:14	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1935	2025-09-29 14:44:14	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1936	2025-09-29 14:44:14	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1937	2025-09-29 14:44:14	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1938	2025-09-29 14:44:14	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1939	2025-09-29 14:44:14	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1940	2025-09-29 14:44:14	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1941	2025-09-29 14:44:14	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1942	2025-09-29 14:44:14	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1943	2025-09-29 14:44:14	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1944	2025-09-29 14:44:14	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1945	2025-09-29 14:44:14	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1946	2025-09-29 14:44:14	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1947	2025-09-29 14:44:14	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1948	2025-09-29 14:44:14	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1949	2025-09-29 14:44:14	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1950	2025-09-29 14:44:14	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1951	2025-09-29 14:44:14	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1952	2025-09-29 14:44:14	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1953	2025-09-29 14:44:14	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1954	2025-09-29 14:44:14	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1955	2025-09-29 14:44:14	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1956	2025-09-29 14:44:14	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1957	2025-09-29 14:44:14	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1958	2025-09-29 14:44:14	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1959	2025-09-29 14:44:14	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1960	2025-09-29 14:44:14	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
1961	2025-09-29 14:44:14	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
1962	2025-09-29 14:44:14	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
1963	2025-09-29 14:44:14	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
1964	2025-09-29 14:44:14	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
1965	2025-09-29 14:44:14	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
1966	2025-09-29 14:44:14	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-09-29 14:44:14, Elapsed: 00:00
1967	2025-09-29 14:44:49	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 14:44:49
1968	2025-09-29 14:44:49	PBatch6.sql: Processing table patients with TemplateNumber 192. Elapsed: 00:00
1969	2025-09-29 14:44:49	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
1970	2025-09-29 14:44:49	PBatch6.sql: Added patient_id (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
1971	2025-09-29 14:44:49	PBatch6.sql: Added first_name (FieldNumber: 2, MaskType: text). Elapsed: 00:00
1972	2025-09-29 14:44:49	PBatch6.sql: Added last_name (FieldNumber: 3, MaskType: text). Elapsed: 00:00
1973	2025-09-29 14:44:49	PBatch6.sql: Added birthdate (FieldNumber: 4, MaskType: date). Elapsed: 00:00
1974	2025-09-29 14:44:49	PBatch6.sql: Added gender (FieldNumber: 5, MaskType: text). Elapsed: 00:00
1975	2025-09-29 14:44:49	PBatch6.sql: Added ssn (FieldNumber: 6, MaskType: text). Elapsed: 00:00
1976	2025-09-29 14:44:49	PBatch6.sql: Added address (FieldNumber: 7, MaskType: text). Elapsed: 00:00
1977	2025-09-29 14:44:49	PBatch6.sql: Added city (FieldNumber: 8, MaskType: text). Elapsed: 00:00
1978	2025-09-29 14:44:49	PBatch6.sql: Added state (FieldNumber: 9, MaskType: text). Elapsed: 00:00
1979	2025-09-29 14:44:49	PBatch6.sql: Added zip_code (FieldNumber: 10, MaskType: text). Elapsed: 00:00
1980	2025-09-29 14:44:49	PBatch6.sql: Added phone_number (FieldNumber: 11, MaskType: text). Elapsed: 00:00
1981	2025-09-29 14:44:49	PBatch6.sql: Added email (FieldNumber: 12, MaskType: text). Elapsed: 00:00
1982	2025-09-29 14:44:49	PBatch6.sql: Added emergency_contact_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
1983	2025-09-29 14:44:49	PBatch6.sql: Added emergency_contact_phone (FieldNumber: 14, MaskType: text). Elapsed: 00:00
1984	2025-09-29 14:44:49	PBatch6.sql: Added insurance_provider (FieldNumber: 15, MaskType: text). Elapsed: 00:00
1985	2025-09-29 14:44:49	PBatch6.sql: Added insurance_policy_number (FieldNumber: 16, MaskType: text). Elapsed: 00:00
1986	2025-09-29 14:44:49	PBatch6.sql: Added primary_physician (FieldNumber: 17, MaskType: text). Elapsed: 00:00
1987	2025-09-29 14:44:49	PBatch6.sql: Added medical_conditions (FieldNumber: 18, MaskType: text). Elapsed: 00:00
1988	2025-09-29 14:44:49	PBatch6.sql: Added medications (FieldNumber: 19, MaskType: text). Elapsed: 00:00
1989	2025-09-29 14:44:49	PBatch6.sql: Added allergies (FieldNumber: 20, MaskType: text). Elapsed: 00:00
1990	2025-09-29 14:44:49	PBatch6.sql: Added blood_type (FieldNumber: 21, MaskType: text). Elapsed: 00:00
1991	2025-09-29 14:44:49	PBatch6.sql: Added date_of_last_visit (FieldNumber: 22, MaskType: date). Elapsed: 00:00
1992	2025-09-29 14:44:49	PBatch6.sql: Added credit_card_number (FieldNumber: 23, MaskType: text). Elapsed: 00:00
1993	2025-09-29 14:44:49	PBatch6.sql: Added credit_card_expiry (FieldNumber: 24, MaskType: text). Elapsed: 00:00
1994	2025-09-29 14:44:49	PBatch6.sql: Added billing_address (FieldNumber: 25, MaskType: text). Elapsed: 00:00
1995	2025-09-29 14:44:49	PBatch6.sql: Added account_balance (FieldNumber: 26, MaskType: number). Elapsed: 00:00
1996	2025-09-29 14:44:49	PBatch6.sql: Added account_status (FieldNumber: 27, MaskType: text). Elapsed: 00:00
1997	2025-09-29 14:44:49	PBatch6.sql: Added driver_license_number (FieldNumber: 28, MaskType: text). Elapsed: 00:00
1998	2025-09-29 14:44:49	PBatch6.sql: Added passport_number (FieldNumber: 29, MaskType: text). Elapsed: 00:00
1999	2025-09-29 14:44:49	PBatch6.sql: Added marital_status (FieldNumber: 30, MaskType: text). Elapsed: 00:00
2000	2025-09-29 14:44:49	PBatch6.sql: Added ethnicity (FieldNumber: 31, MaskType: text). Elapsed: 00:00
2001	2025-09-29 14:44:49	PBatch6.sql: Added occupation (FieldNumber: 32, MaskType: text). Elapsed: 00:00
2002	2025-09-29 14:44:49	PBatch6.sql: Added employer_name (FieldNumber: 33, MaskType: text). Elapsed: 00:00
2003	2025-09-29 14:44:49	PBatch6.sql: Added employer_phone (FieldNumber: 34, MaskType: text). Elapsed: 00:00
2004	2025-09-29 14:44:49	PBatch6.sql: Added notes (FieldNumber: 35, MaskType: text). Elapsed: 00:00
2005	2025-09-29 14:44:49	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-09-29 14:44:49, Elapsed: 00:00
2006	2025-09-29 14:49:09	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 14:49:09
2007	2025-09-29 14:49:09	PBatch6.sql: Processing table  with TemplateNumber . Elapsed: 00:00
2008	2025-09-29 14:49:09	PBatch6.sql: Cleared ETPProTp for TemplateNumber . Elapsed: 00:00
2009	2025-09-29 14:49:09	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber . EndTime: 2025-09-29 14:49:09, Elapsed: 00:00
2010	 9/29/2025 15:17:41	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2011	2025-09-29 15:59:11	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 15:59:11
2012	2025-09-29 15:59:11	PBatch6.sql: Processing table  with TemplateNumber . Elapsed: 00:00
2013	2025-09-29 15:59:11	PBatch6.sql: Cleared ETPProTp for TemplateNumber . Elapsed: 00:00
2014	2025-09-29 15:59:11	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber . EndTime: 2025-09-29 15:59:11, Elapsed: 00:00
2015	2025-09-29 16:05:51	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 16:05:51
2016	2025-09-29 16:05:51	PBatch6.sql: Processing table  with TemplateNumber . Elapsed: 00:00
2017	2025-09-29 16:05:51	PBatch6.sql: Cleared ETPProTp for TemplateNumber . Elapsed: 00:00
2018	2025-09-29 16:05:51	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber . EndTime: 2025-09-29 16:05:51, Elapsed: 00:00
2019	2025-09-29 16:34:32	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 16:34:32
2020	2025-09-29 16:34:32	PBatch6.sql: Processing table eccpend with TemplateNumber 192. Elapsed: 00:00
2021	2025-09-29 16:34:32	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
2022	2025-09-29 16:34:32	PBatch6.sql: Added oid (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
2023	2025-09-29 16:34:32	PBatch6.sql: Added dateord (FieldNumber: 2, MaskType: unknown). Elapsed: 00:00
2024	2025-09-29 16:34:32	PBatch6.sql: Added etp_vendor_code (FieldNumber: 3, MaskType: text). Elapsed: 00:00
2025	2025-09-29 16:34:32	PBatch6.sql: Added etp_vault_number (FieldNumber: 4, MaskType: unknown). Elapsed: 00:00
2026	2025-09-29 16:34:32	PBatch6.sql: Added ecode (FieldNumber: 5, MaskType: number). Elapsed: 00:00
2027	2025-09-29 16:34:32	PBatch6.sql: Added response (FieldNumber: 6, MaskType: text). Elapsed: 00:00
2028	2025-09-29 16:34:32	PBatch6.sql: Added ordernum (FieldNumber: 7, MaskType: unknown). Elapsed: 00:00
2029	2025-09-29 16:34:32	PBatch6.sql: Added status (FieldNumber: 8, MaskType: text). Elapsed: 00:00
2030	2025-09-29 16:34:32	PBatch6.sql: Added tid (FieldNumber: 9, MaskType: text). Elapsed: 00:00
2031	2025-09-29 16:34:32	PBatch6.sql: Added order_type (FieldNumber: 10, MaskType: text). Elapsed: 00:00
2032	2025-09-29 16:34:32	PBatch6.sql: Added transaction_type (FieldNumber: 11, MaskType: text). Elapsed: 00:00
2033	2025-09-29 16:34:32	PBatch6.sql: Added billing_name (FieldNumber: 12, MaskType: text). Elapsed: 00:00
2034	2025-09-29 16:34:32	PBatch6.sql: Added billing_first_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
2035	2025-09-29 16:34:32	PBatch6.sql: Added billing_last_name (FieldNumber: 14, MaskType: text). Elapsed: 00:00
2036	2025-09-29 16:34:32	PBatch6.sql: Added billing_zip (FieldNumber: 15, MaskType: text). Elapsed: 00:00
2037	2025-09-29 16:34:32	PBatch6.sql: Added billing_email (FieldNumber: 16, MaskType: text). Elapsed: 00:00
2038	2025-09-29 16:34:32	PBatch6.sql: Added cc_type (FieldNumber: 17, MaskType: text). Elapsed: 00:00
2039	2025-09-29 16:34:32	PBatch6.sql: Added cc_number (FieldNumber: 18, MaskType: text). Elapsed: 00:00
2040	2025-09-29 16:34:32	PBatch6.sql: Added ccexp_month (FieldNumber: 19, MaskType: text). Elapsed: 00:00
2041	2025-09-29 16:34:32	PBatch6.sql: Added ccexp_year (FieldNumber: 20, MaskType: text). Elapsed: 00:00
2042	2025-09-29 16:34:32	PBatch6.sql: Added cnp_recurring (FieldNumber: 21, MaskType: text). Elapsed: 00:00
2043	2025-09-29 16:34:32	PBatch6.sql: Added cnp_security (FieldNumber: 22, MaskType: text). Elapsed: 00:00
2044	2025-09-29 16:34:32	PBatch6.sql: Added counter (FieldNumber: 23, MaskType: text). Elapsed: 00:00
2045	2025-09-29 16:34:32	PBatch6.sql: Added grand_total (FieldNumber: 24, MaskType: text). Elapsed: 00:00
2046	2025-09-29 16:34:32	PBatch6.sql: Added product_description (FieldNumber: 25, MaskType: text). Elapsed: 00:00
2047	2025-09-29 16:34:32	PBatch6.sql: Added purchase_order_number (FieldNumber: 26, MaskType: text). Elapsed: 00:00
2048	2025-09-29 16:34:32	PBatch6.sql: Added sales_tax (FieldNumber: 27, MaskType: text). Elapsed: 00:00
2049	2025-09-29 16:34:32	PBatch6.sql: Added track1 (FieldNumber: 28, MaskType: text). Elapsed: 00:00
2050	2025-09-29 16:34:32	PBatch6.sql: Added track2 (FieldNumber: 29, MaskType: text). Elapsed: 00:00
2051	2025-09-29 16:34:32	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-09-29 16:34:32, Elapsed: 00:00
2052	 9/29/2025 16:37:31	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2053	 9/29/2025 16:37:36	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2054	 9/29/2025 16:47:13	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2055	2025-09-29 16:56:22	PBatch6.sql: Starting ETPProTp repopulation for dynamic field adjustments. StartTime: 2025-09-29 16:56:22
2056	2025-09-29 16:56:22	PBatch6.sql: Processing table eccpend with TemplateNumber 192. Elapsed: 00:00
2057	2025-09-29 16:56:22	PBatch6.sql: Cleared ETPProTp for TemplateNumber 192. Elapsed: 00:00
2058	2025-09-29 16:56:22	PBatch6.sql: Added oid (FieldNumber: 1, MaskType: unknown). Elapsed: 00:00
2059	2025-09-29 16:56:22	PBatch6.sql: Added dateord (FieldNumber: 2, MaskType: unknown). Elapsed: 00:00
2060	2025-09-29 16:56:22	PBatch6.sql: Added etp_vendor_code (FieldNumber: 3, MaskType: text). Elapsed: 00:00
2061	2025-09-29 16:56:22	PBatch6.sql: Added etp_vault_number (FieldNumber: 4, MaskType: unknown). Elapsed: 00:00
2062	2025-09-29 16:56:22	PBatch6.sql: Added ecode (FieldNumber: 5, MaskType: number). Elapsed: 00:00
2063	2025-09-29 16:56:22	PBatch6.sql: Added response (FieldNumber: 6, MaskType: text). Elapsed: 00:00
2064	2025-09-29 16:56:22	PBatch6.sql: Added ordernum (FieldNumber: 7, MaskType: unknown). Elapsed: 00:00
2065	2025-09-29 16:56:22	PBatch6.sql: Added status (FieldNumber: 8, MaskType: text). Elapsed: 00:00
2066	2025-09-29 16:56:22	PBatch6.sql: Added tid (FieldNumber: 9, MaskType: text). Elapsed: 00:00
2067	2025-09-29 16:56:22	PBatch6.sql: Added order_type (FieldNumber: 10, MaskType: text). Elapsed: 00:00
2068	2025-09-29 16:56:22	PBatch6.sql: Added transaction_type (FieldNumber: 11, MaskType: text). Elapsed: 00:00
2069	2025-09-29 16:56:22	PBatch6.sql: Added billing_name (FieldNumber: 12, MaskType: text). Elapsed: 00:00
2070	2025-09-29 16:56:22	PBatch6.sql: Added billing_first_name (FieldNumber: 13, MaskType: text). Elapsed: 00:00
2071	2025-09-29 16:56:22	PBatch6.sql: Added billing_last_name (FieldNumber: 14, MaskType: text). Elapsed: 00:00
2072	2025-09-29 16:56:22	PBatch6.sql: Added billing_zip (FieldNumber: 15, MaskType: text). Elapsed: 00:00
2073	2025-09-29 16:56:22	PBatch6.sql: Added billing_email (FieldNumber: 16, MaskType: text). Elapsed: 00:00
2074	2025-09-29 16:56:22	PBatch6.sql: Added cc_type (FieldNumber: 17, MaskType: text). Elapsed: 00:00
2075	2025-09-29 16:56:22	PBatch6.sql: Added cc_number (FieldNumber: 18, MaskType: text). Elapsed: 00:00
2076	2025-09-29 16:56:22	PBatch6.sql: Added ccexp_month (FieldNumber: 19, MaskType: text). Elapsed: 00:00
2077	2025-09-29 16:56:22	PBatch6.sql: Added ccexp_year (FieldNumber: 20, MaskType: text). Elapsed: 00:00
2078	2025-09-29 16:56:22	PBatch6.sql: Added cnp_recurring (FieldNumber: 21, MaskType: text). Elapsed: 00:00
2079	2025-09-29 16:56:22	PBatch6.sql: Added cnp_security (FieldNumber: 22, MaskType: text). Elapsed: 00:00
2080	2025-09-29 16:56:22	PBatch6.sql: Added counter (FieldNumber: 23, MaskType: text). Elapsed: 00:00
2081	2025-09-29 16:56:22	PBatch6.sql: Added grand_total (FieldNumber: 24, MaskType: text). Elapsed: 00:00
2082	2025-09-29 16:56:22	PBatch6.sql: Added product_description (FieldNumber: 25, MaskType: text). Elapsed: 00:00
2083	2025-09-29 16:56:22	PBatch6.sql: Added purchase_order_number (FieldNumber: 26, MaskType: text). Elapsed: 00:00
2084	2025-09-29 16:56:22	PBatch6.sql: Added sales_tax (FieldNumber: 27, MaskType: text). Elapsed: 00:00
2085	2025-09-29 16:56:22	PBatch6.sql: Added track1 (FieldNumber: 28, MaskType: text). Elapsed: 00:00
2086	2025-09-29 16:56:22	PBatch6.sql: Added track2 (FieldNumber: 29, MaskType: text). Elapsed: 00:00
2087	2025-09-29 16:56:22	PBatch6.sql: ETPProTp repopulated successfully for TemplateNumber 192. EndTime: 2025-09-29 16:56:22, Elapsed: 00:00
2088	 9/29/2025 17:01:21	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2089	 9/29/2025 17:04:58	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2090	2025-09-29 18:07:54	PBatch1.sql: Starting conditional truncate of ETPProRq. StartTime: 2025-09-29 18:07:54
2091	2025-09-29 18:07:54	PBatch1.sql: Truncated ETPProRq. Elapsed: 00:00
2092	2025-09-29 18:07:54	PBatch1.sql: Starting ETPProRq population. StartTime: 2025-09-29 18:07:54
2093	2025-09-29 18:07:54	PBatch1.sql: Using TemplateNumber: 192, DBTableName: eccpend, UniqueSourceColumn: oid. Elapsed: 00:00
2094	2025-09-29 18:07:54	PBatch1.sql: Batch record created with BatchNumber: 86. Elapsed: 00:00
2095	2025-09-29 18:07:54	etpparam: UPDATE oid=1, min_id=43, max_id=43
2096	2025-09-29 18:07:54	PBatch1.sql: Updated ETPParam with Batch OID: 86. Elapsed: 00:00
2097	2025-09-29 18:07:54	PBatch1.sql: Updated etpprobt with 1 records for BatchNumber: 86. Elapsed: 00:00
2098	2025-09-29 18:07:54	PBatch1.sql: ETPProRq populated with 6 records. EndTime: 2025-09-29 18:07:54, Elapsed: 00:00
2099	2025-09-29 18:07:55	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-09-29 18:07:55
2100	2025-09-29 18:08:02	PBatch3.bat: ETPProRt populated with 1 records. EndTime: 2025-09-29 18:08:02, Elapsed: 00:07
2101	2025-09-29 18:08:02	PBatch4.sql: Retry 1/60: ETPProRt has 1 rows
2102	2025-09-29 18:08:02	PBatch4.sql: ETPProRt contains 1 rows. Processing complete.
2103	2025-09-29 18:08:02	PBatch4.sql: No Processing batch found in ETPProBt.
2104	2025-09-29 18:08:03	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-09-29 18:08:03
2105	2025-09-29 18:08:03	PBatch7.sql: Batch OID 305 marked as Completed. EndTime: 2025-09-29 18:08:03, ExecutionTime: 00:00:09
2106	2025-09-29 18:08:03	PBatch8.sql: Starting masking process. StartTime: 2025-09-29 18:08:03
2107	2025-09-29 18:08:03	PBatch8.sql: Using unique source column: oid. Elapsed: 00:00
2108	2025-09-29 18:08:03	PBatch8.sql: Processing ImportID: 43. Elapsed: 00:00
2109	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2110	2025-09-29 18:08:03	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 43. Elapsed: 00:00
2111	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2112	2025-09-29 18:08:03	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 43. Elapsed: 00:00
2113	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2114	2025-09-29 18:08:03	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 43. Elapsed: 00:00
2115	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2116	2025-09-29 18:08:03	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 43. Elapsed: 00:00
2117	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2118	2025-09-29 18:08:03	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 43. Elapsed: 00:00
2119	2025-09-29 18:08:03	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2120	2025-09-29 18:08:03	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 43. Elapsed: 00:00
2121	2025-09-29 18:08:03	PBatch8.sql: Masking completed successfully for 6 records. EndTime: 2025-09-29 18:08:03, Elapsed: 00:00
2122	2025-09-29 18:08:03	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-09-29 18:08:03
2123	2025-09-29 18:08:03	PBatch9.sql: ETPProAC populated with 1 records. EndTime: 2025-09-29 18:08:03, Elapsed: 00:00
2124	 9/29/2025 20:45:26	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2125	 9/29/2025 21:55:50	PFM_SQL_To_PFM_String: Updated FieldMappings for TemplateNumber=192
2126	2025-10-01 13:17:08	etpparam: UPDATE oid=1, min_id=43, max_id=43
2127	10/04/2025 19:15:23	Timer: Detected Ready batch 88
2128	10/04/2025 19:15:23	Timer: Batch 88 set to Processing
2129	2025-10-04 19:15:23	etpparam: UPDATE oid=1, min_id=43, max_id=43
2130	2025-10-04 19:15:26	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-04 19:15:26
2131	2025-10-04 19:15:27	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-04 19:15:27
2132	2025-10-04 19:15:48	PBatch3.bat: ETPProRt populated with 0 records. EndTime: 2025-10-04 19:15:48, Elapsed: 00:21
2134	10/06/2025 14:31:18	Timer: Detected Ready batch 87
2137	2025-10-06 14:31:19	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-06 14:31:19
2138	2025-10-06 14:31:19	TriggerProc.bat: No Ready batch found. Waiting.
2141	2025-10-06 20:14:53	etpparam: UPDATE oid=1, min_id=43, max_id=43
2142	2025-10-06 20:14:56	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-06 20:14:56
2143	2025-10-06 20:14:56	TriggerProc.bat: No Ready batch found. Waiting.
2144	2025-10-06 20:40:10	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-06 20:40:10
2145	2025-10-06 20:40:10	TriggerProc.bat: No Ready batch found. Waiting.
2146	10/06/2025 20:48:19	Timer: Detected Ready batch 87
2147	10/06/2025 20:48:19	Timer: Batch 87 set to Processing
2148	2025-10-06 20:48:19	etpparam: UPDATE oid=1, min_id=43, max_id=43
2149	2025-10-06 20:48:20	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-06 20:48:20
2150	2025-10-06 20:48:21	TriggerProc.bat: No Ready batch found. Waiting.
2151	2025-10-07 11:18:17	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 11:18:17
2152	2025-10-07 11:18:18	TriggerProc.bat: No Ready batch found. Waiting.
2153	2025-10-07 11:34:29	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 11:34:29
2154	2025-10-07 11:34:30	TriggerProc.bat: No Ready batch found. Waiting.
2155	2025-10-07 11:38:14	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 11:38:14
2156	2025-10-07 11:38:14	TriggerProc.bat: No Ready batch found. Waiting.
2157	2025-10-07 11:48:22	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 11:48:22
2158	2025-10-07 11:48:22	TriggerProc.bat: No Ready batch found. Waiting.
2159	2025-10-07 13:43:23	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 13:43:23
2160	2025-10-07 13:43:23	TriggerProc.bat: No Ready batch found. Waiting.
2161	10/07/2025 18:39:54	Timer: Detected Ready batch 88
2162	10/07/2025 18:39:54	Timer: Batch 88 set to Processing
2163	2025-10-07 18:39:54	etpparam: UPDATE oid=1, min_id=43, max_id=43
2164	2025-10-07 18:39:56	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-07 18:39:56
2165	2025-10-07 18:39:57	TriggerProc.bat: No Ready batch found. Waiting.
2166	2025-10-07 19:04:25	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2167	2025-10-07 19:04:25	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2168	2025-10-07 19:04:48	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2169	2025-10-07 19:04:48	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2170	2025-10-07 19:04:53	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2171	2025-10-07 19:04:54	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2172	2025-10-07 19:04:56	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2173	2025-10-07 19:04:57	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2174	2025-10-07 19:08:35	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2175	2025-10-07 19:08:35	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2176	2025-10-07 19:08:45	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2177	2025-10-07 19:08:45	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2178	2025-10-07 19:08:49	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2179	2025-10-07 19:08:49	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2180	2025-10-07 19:08:54	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2181	2025-10-07 19:08:55	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2182	2025-10-07 19:17:51	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2183	2025-10-07 19:17:51	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2184	2025-10-07 19:17:56	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2185	2025-10-07 19:17:57	RunTriggeredBatch.bat: ERROR - No Processing batch detected.
2186	2025-10-07 19:37:42	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2187	2025-10-07 21:22:10	etpparam: UPDATE oid=1, min_id=43, max_id=43
2188	2025-10-07 21:22:12	RunTriggeredBatch.bat: Starting triggered processing pipeline.
2189	10/09/2025 20:06:54	Timer: Detected Processing batch 87
2190	2025-10-09 20:06:57	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-09 20:06:57
2191	2025-10-09 20:06:58	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-09 20:06:58
2192	2025-10-09 20:07:07	PBatch3.bat: ETPProRt populated with 0 records. EndTime: 2025-10-09 20:07:07, Elapsed: 00:09
2195		Timer: PBatch sequence completed for batch 87
2196	10/09/2025 20:07:22	Timer: Detected Processing batch 87
2197	2025-10-09 20:07:24	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-09 20:07:24
2198	2025-10-09 20:07:24	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-09 20:07:24
2199	2025-10-09 20:07:30	PBatch3.bat: ETPProRt populated with 0 records. EndTime: 2025-10-09 20:07:30, Elapsed: 00:06
2201		Timer: PBatch sequence completed for batch 87
2202	10/10/2025 17:58:36	Timer: Detected Ready batch 87
2204	10/10/2025 18:21:14	Timer: Detected Ready batch 87
2206	10/10/2025 18:33:29	Timer: Detected Ready batch 87
2207	2025-10-10 18:33:31	TrigPipeline: Starting pipeline.
2208	2025-10-10 18:33:31	TrigPipeline: Found Ready batch 88.
2209	2025-10-10 18:33:31	TrigPipeline: Updated batch 88 to Processing after PRQ process.
2210	2025-10-10 18:33:31	TrigPipeline: Completed batch 88.
2211	10/10/2025 18:41:20	Timer: Detected Processing batch 88
2212	2025-10-10 18:41:22	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-10 18:41:22
2213	2025-10-10 18:41:22	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-10 18:41:22
2214	2025-10-10 18:42:11	PBatch3.bat: ETPProRt populated with 10 records. EndTime: 2025-10-10 18:42:11, Elapsed: 00:49
2215	2025-10-10 18:42:11	PBatch4.sql: Retry 1/60: ETPProRt has 10 rows
2216	2025-10-10 18:42:11	PBatch4.sql: ETPProRt contains 10 rows. Processing complete.
2217	2025-10-10 18:42:11	PBatch4.sql: Error updating ETPProBt: value too long for type character varying(19)
2219	2025-10-10 18:42:12	PBatch8.sql: Starting masking process. StartTime: 2025-10-10 18:42:12
2220	2025-10-10 18:42:12	PBatch8.sql: Using unique source column: oid. Elapsed: 00:00
2221	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 1. Elapsed: 00:00
2222	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2223	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
2224	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2225	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
2226	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2227	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
2228	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2229	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
2230	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2231	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
2232	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2233	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
2234	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2235	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
2236	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 2. Elapsed: 00:00
2237	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2238	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
2239	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2240	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
2241	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2242	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
2243	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2244	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
2245	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2246	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
2247	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2248	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
2249	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2250	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
2251	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 3. Elapsed: 00:00
2252	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2253	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
2254	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2255	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
2256	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2257	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
2258	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2259	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
2260	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2261	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
2262	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2263	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
2264	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2265	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
2266	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 4. Elapsed: 00:00
2267	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2268	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
2269	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2270	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
2375		Timer: PBatch sequence completed for batch 88
2271	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2272	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
2273	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2274	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
2275	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2276	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
2277	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2278	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
2279	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2280	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
2281	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 5. Elapsed: 00:00
2282	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2283	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
2284	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2285	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
2286	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2287	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
2288	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2289	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
2290	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2291	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
2292	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2293	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
2294	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2295	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
2296	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 6. Elapsed: 00:00
2297	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2298	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
2299	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2300	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
2301	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2302	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
2303	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2304	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
2305	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2306	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
2307	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2308	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
2309	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2310	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
2311	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 7. Elapsed: 00:00
2312	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2313	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
2314	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2315	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
2316	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2317	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
2318	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2319	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
2320	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2321	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
2322	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2323	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
2324	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2325	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
2326	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 8. Elapsed: 00:00
2327	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2328	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
2329	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2330	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
2331	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2332	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
2333	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2334	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
2335	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2336	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
2337	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2338	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
2339	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2340	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
2341	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 9. Elapsed: 00:00
2342	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2343	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
2344	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2345	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
2346	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2347	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
2348	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2349	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
2350	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2351	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
2352	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2353	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
2354	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2355	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
2356	2025-10-10 18:42:12	PBatch8.sql: Processing ImportID: 10. Elapsed: 00:00
2357	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2358	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
2359	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2360	2025-10-10 18:42:12	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
2361	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2362	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
2363	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2364	2025-10-10 18:42:12	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
2365	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2366	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
2367	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2368	2025-10-10 18:42:12	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
2369	2025-10-10 18:42:12	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2370	2025-10-10 18:42:12	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
2371	2025-10-10 18:42:12	PBatch8.sql: Masking completed successfully for 70 records. EndTime: 2025-10-10 18:42:12, Elapsed: 00:00
2372	2025-10-10 18:42:12	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-10-10 18:42:12
2373	2025-10-10 18:42:12	PBatch9.sql: ETPProAC populated with 10 records. EndTime: 2025-10-10 18:42:12, Elapsed: 00:00
2374	2025-10-10 18:42:12	TriggerProc.bat: ETP/CTP Trigger Mode processing completed. EndTime: 2025-10-10 18:42:12
2376	10/10/2025 18:42:12	Timer: Detected Ready batch 87
2377	2025-10-10 18:42:14	TrigPipeline: Starting pipeline.
2378	10/10/2025 18:42:31	Timer: Detected Processing batch 88
2379	2025-10-10 18:42:33	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-10 18:42:33
2380	2025-10-10 18:42:33	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-10 18:42:33
2381	2025-10-10 18:44:20	PBatch3.bat: ETPProRt populated with 0 records. EndTime: 2025-10-10 18:44:20, Elapsed: 01:47
2383		Timer: PBatch sequence completed for batch 88
2384	10/10/2025 23:42:37	Timer: Detected Ready batch 87
2385	2025-10-10 23:42:39	TrigPipeline: Starting pipeline.
2386	2025-10-10 23:42:39	TrigPipeline: Found Ready batch 88.
2387	2025-10-10 23:42:39	TrigPipeline: Updated batch 88 to Processing after PRQ process.
2388	2025-10-10 23:42:39	TrigPipeline: Completed batch 88.
2389	10/11/2025 00:04:07	Timer: Detected Processing batch 87
2390	2025-10-11 00:04:09	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 00:04:09
2391	2025-10-11 00:04:09	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 00:04:09
2392	2025-10-11 00:04:50	PBatch3.bat: ETPProRt populated with 10 records. EndTime: 2025-10-11 00:04:50, Elapsed: 00:41
2393	2025-10-11 00:04:51	PBatch4.sql: Retry 1/60: ETPProRt has 10 rows
2394	2025-10-11 00:04:51	PBatch4.sql: ETPProRt contains 10 rows. Processing complete.
2395	2025-10-11 00:04:51	PBatch4.sql: Batch OID 332 marked as Completed. EndTime: 2025-10-11 00:04:51, ExecutionTime: 00:22:45
2396	2025-10-11 00:04:51	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-10-11 00:04:51
2397	2025-10-11 00:04:51	PBatch7.sql: Batch OID 332 marked as Completed. EndTime: 2025-10-11 00:04:51, ExecutionTime: 00:22:45
2398	2025-10-11 00:04:51	PBatch8.sql: Starting masking process. StartTime: 2025-10-11 00:04:51
2399	2025-10-11 00:04:51	PBatch8.sql: Using unique source column: oid. Elapsed: 00:00
2400	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 1. Elapsed: 00:00
2401	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2402	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
2403	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2404	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
2405	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2406	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
2407	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2408	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
2409	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2410	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
2411	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2412	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
2413	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2414	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
2415	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 2. Elapsed: 00:00
2416	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2417	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
2418	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2419	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
2420	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2421	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
2422	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2423	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
2424	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2425	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
2426	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2427	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
2428	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2429	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
2430	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 3. Elapsed: 00:00
2431	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2432	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
2433	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2434	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
2435	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2436	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
2437	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2438	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
2439	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2440	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
2441	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2442	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
2443	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2444	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
2445	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 4. Elapsed: 00:00
2446	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2447	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
2448	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2449	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
2450	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2451	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
2452	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2453	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
2454	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2455	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
2456	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2457	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
2458	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2459	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
2460	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 5. Elapsed: 00:00
2461	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2462	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
2463	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2464	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
2465	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2466	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
2467	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2468	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
2469	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2470	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
2471	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2472	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
2473	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2474	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
2475	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 6. Elapsed: 00:00
2476	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2477	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
2478	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2479	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
2480	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2481	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
2482	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2483	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
2484	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2485	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
2486	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2487	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
2488	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2489	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
2490	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 7. Elapsed: 00:00
2491	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2492	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
2493	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2494	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
2495	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2496	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
2497	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2498	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
2499	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2500	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
2501	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2502	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
2503	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2504	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
2505	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 8. Elapsed: 00:00
2506	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2507	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
2508	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2509	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
2510	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2511	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
2512	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2513	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
2514	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2515	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
2516	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2517	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
2518	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2519	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
2520	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 9. Elapsed: 00:00
2521	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2522	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
2523	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2524	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
2525	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2526	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
2527	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2528	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
2529	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2530	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
2531	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2532	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
2533	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2534	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
2535	2025-10-11 00:04:51	PBatch8.sql: Processing ImportID: 10. Elapsed: 00:00
2536	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2537	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
2538	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2539	2025-10-11 00:04:51	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
2540	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2541	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
2542	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2543	2025-10-11 00:04:51	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
2544	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2545	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
2546	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2547	2025-10-11 00:04:51	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
2548	2025-10-11 00:04:51	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2549	2025-10-11 00:04:51	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
2550	2025-10-11 00:04:51	PBatch8.sql: Masking completed successfully for 70 records. EndTime: 2025-10-11 00:04:51, Elapsed: 00:00
2551	2025-10-11 00:04:52	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-10-11 00:04:52
2552	2025-10-11 00:04:52	PBatch9.sql: ETPProAC populated with 10 records. EndTime: 2025-10-11 00:04:52, Elapsed: 00:00
2554		Timer: PBatch sequence completed for batch 87
2553	2025-10-11 00:04:52	TriggerProc.bat: ETP/CTP Trigger Mode processing completed. EndTime: 2025-10-11 00:04:52
2555	10/11/2025 00:11:37	Timer: Detected Ready batch 88
2556	2025-10-11 00:11:39	TrigPipeline: Starting pipeline.
2557	2025-10-11 00:11:39	TrigPipeline: Found Ready batch 88.
2558	2025-10-11 00:11:39	TrigPipeline: Updated batch 88 to Processing after PRQ process.
2559	2025-10-11 00:11:39	TrigPipeline: Completed batch 88.
2560	10/11/2025 00:11:39	Timer: Detected Processing batch 88
2561	2025-10-11 00:11:41	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 00:11:41
2562	2025-10-11 00:11:41	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 00:11:41
2563	2025-10-11 00:12:19	PBatch3.bat: ETPProRt populated with 10 records. EndTime: 2025-10-11 00:12:19, Elapsed: 00:38
2564	2025-10-11 00:12:19	PBatch4.sql: Retry 1/60: ETPProRt has 10 rows
2565	2025-10-11 00:12:19	PBatch4.sql: ETPProRt contains 10 rows. Processing complete.
2566	2025-10-11 00:12:19	PBatch4.sql: Batch OID 334 marked as Completed. EndTime: 2025-10-11 00:12:19, ExecutionTime: 00:00:58
2567	2025-10-11 00:12:19	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-10-11 00:12:19
2568	2025-10-11 00:12:19	PBatch7.sql: Batch OID 334 marked as Completed. EndTime: 2025-10-11 00:12:19, ExecutionTime: 00:00:58
2569	2025-10-11 00:12:19	PBatch8.sql: Starting masking process. StartTime: 2025-10-11 00:12:19
2570	2025-10-11 00:12:19	PBatch8.sql: Using unique source column: oid. Elapsed: 00:00
2571	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 1. Elapsed: 00:00
2572	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2573	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
2574	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2575	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
2576	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2577	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
2578	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2579	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
2580	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2581	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
2582	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2583	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
2584	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2585	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
2586	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 2. Elapsed: 00:00
2587	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2588	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
2589	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2590	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
2591	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2592	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
2593	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2594	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
2595	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2596	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
2597	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2598	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
2599	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2600	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
2601	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 3. Elapsed: 00:00
2602	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2603	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
2604	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2605	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
2606	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2607	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
2608	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2609	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
2610	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2611	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
2612	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2613	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
2614	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2725		Timer: PBatch sequence completed for batch 88
2615	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
2616	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 4. Elapsed: 00:00
2617	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2618	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
2619	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2620	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
2621	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2622	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
2623	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2624	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
2625	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2626	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
2627	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2628	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
2629	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2630	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
2631	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 5. Elapsed: 00:00
2632	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2633	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
2634	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2635	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
2636	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2637	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
2638	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2639	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
2640	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2641	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
2642	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2643	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
2644	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2645	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
2646	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 6. Elapsed: 00:00
2647	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2648	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
2649	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2650	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
2651	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2652	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
2653	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2654	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
2655	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2656	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
2657	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2658	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
2659	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2660	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
2661	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 7. Elapsed: 00:00
2662	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2663	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
2664	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2665	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
2666	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2667	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
2668	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2669	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
2670	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2671	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
2672	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2673	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
2674	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2675	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
2676	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 8. Elapsed: 00:00
2677	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2678	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
2679	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2680	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
2681	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2682	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
2683	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2684	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
2685	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2686	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
2687	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2688	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
2689	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2690	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
2691	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 9. Elapsed: 00:00
2692	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2693	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
2694	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2695	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
2696	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2697	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
2698	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2699	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
2700	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2701	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
2702	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2703	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
2704	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2705	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
2706	2025-10-11 00:12:19	PBatch8.sql: Processing ImportID: 10. Elapsed: 00:00
2707	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2708	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
2709	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2710	2025-10-11 00:12:19	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
2711	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2712	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
2713	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2714	2025-10-11 00:12:19	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
2715	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2716	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
2717	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2718	2025-10-11 00:12:19	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
2719	2025-10-11 00:12:19	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2720	2025-10-11 00:12:19	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
2721	2025-10-11 00:12:19	PBatch8.sql: Masking completed successfully for 70 records. EndTime: 2025-10-11 00:12:19, Elapsed: 00:00
2722	2025-10-11 00:12:19	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-10-11 00:12:19
2723	2025-10-11 00:12:19	PBatch9.sql: ETPProAC populated with 10 records. EndTime: 2025-10-11 00:12:19, Elapsed: 00:00
2724	2025-10-11 00:12:19	TriggerProc.bat: ETP/CTP Trigger Mode processing completed. EndTime: 2025-10-11 00:12:19
2726	10/11/2025 00:42:37	Timer: Detected Ready batch 89
2727	2025-10-11 00:42:38	TrigPipeline: Starting pipeline.
2728	2025-10-11 00:42:38	TrigPipeline: Found Ready batch 89.
2729	2025-10-11 00:42:38	TrigPipeline: Updated batch 89 to Processing with RecordCount 70.
2730	10/11/2025 00:42:38	Timer: Detected Processing batch 89
2731	2025-10-11 00:42:39	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 00:42:39
2732	2025-10-11 00:42:40	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 00:42:40
2733	2025-10-11 00:43:22	PBatch3.bat: ETPProRt populated with 10 records. EndTime: 2025-10-11 00:43:22, Elapsed: 00:42
2734	2025-10-11 00:43:22	PBatch4.sql: Retry 1/60: ETPProRt has 10 rows
2735	2025-10-11 00:43:22	PBatch4.sql: ETPProRt contains 10 rows. Processing complete.
2736	2025-10-11 00:43:22	PBatch4.sql: Batch OID 335 marked as Completed. EndTime: 2025-10-11 00:43:22, ExecutionTime: 00:00:43
2737	2025-10-11 00:43:22	PBatch7.sql: Starting ETPProBt update. StartTime: 2025-10-11 00:43:22
2738	2025-10-11 00:43:22	PBatch7.sql: Batch OID 335 marked as Completed. EndTime: 2025-10-11 00:43:22, ExecutionTime: 00:00:44
2739	2025-10-11 00:43:22	PBatch8.sql: Starting masking process. StartTime: 2025-10-11 00:43:22
2740	2025-10-11 00:43:22	PBatch8.sql: Using unique source column: oid. Elapsed: 00:00
2741	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 1. Elapsed: 00:00
2742	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2743	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
2744	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2745	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
2746	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2747	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
2748	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2749	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
2750	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2751	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
2752	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2753	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
2754	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2755	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
2756	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 2. Elapsed: 00:00
2757	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2758	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
2759	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2760	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
2761	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2762	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
2763	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2764	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
2765	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2766	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
2767	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2768	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
2769	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2770	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
2771	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 3. Elapsed: 00:00
2772	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2773	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
2774	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2775	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
2776	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2777	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
2778	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2779	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
2780	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2781	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
2782	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2783	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
2784	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2785	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
2786	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 4. Elapsed: 00:00
2787	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2788	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
2789	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2790	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
2791	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2792	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
2793	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2794	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
2795	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2796	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
2797	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2798	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
2799	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2800	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
2801	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 5. Elapsed: 00:00
2802	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2803	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
2804	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2805	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
2806	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2807	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
2808	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2809	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
2810	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2811	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
2812	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2813	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
2814	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2815	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
2816	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 6. Elapsed: 00:00
2817	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2818	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
2819	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2820	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
2821	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2822	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
2823	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2824	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
2825	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2826	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
2827	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2828	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
2829	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2830	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
2831	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 7. Elapsed: 00:00
2832	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2833	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
2834	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2835	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
2836	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2837	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
2838	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2839	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
2840	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2841	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
2842	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2843	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
2844	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2845	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
2846	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 8. Elapsed: 00:00
2847	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2848	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
2849	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2850	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
2851	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2852	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
2853	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2854	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
2855	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2856	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
2857	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2858	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
2859	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2860	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
2861	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 9. Elapsed: 00:00
2862	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2863	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
2864	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2865	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
2866	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2867	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
2868	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2869	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
2870	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2871	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
2872	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2873	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
2874	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2875	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
2876	2025-10-11 00:43:22	PBatch8.sql: Processing ImportID: 10. Elapsed: 00:00
2877	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2878	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
2879	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2880	2025-10-11 00:43:22	PBatch8.sql: Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
2881	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2882	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
2883	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2884	2025-10-11 00:43:22	PBatch8.sql: Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
2885	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2886	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
2887	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2888	2025-10-11 00:43:22	PBatch8.sql: Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
2889	2025-10-11 00:43:22	PBatch8.sql: Applying masked value: 0 to field: ecode. Elapsed: 00:00
2890	2025-10-11 00:43:22	PBatch8.sql: Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
2891	2025-10-11 00:43:22	PBatch8.sql: Masking completed successfully for 70 records. EndTime: 2025-10-11 00:43:22, Elapsed: 00:00
2892	2025-10-11 00:43:23	PBatch9.sql: Starting ETPProAC population. StartTime: 2025-10-11 00:43:23
2893	2025-10-11 00:43:23	PBatch9.sql: ETPProAC populated with 10 records. EndTime: 2025-10-11 00:43:23, Elapsed: 00:00
2894	2025-10-11 00:43:23	TriggerProc.bat: ETP/CTP Trigger Mode processing completed. EndTime: 2025-10-11 00:43:23
2895		Timer: PBatch sequence completed for batch 89
2896	10/11/2025 12:39:54	Timer: Detected Ready batch 90
2897	2025-10-11 12:39:58	TrigPipeline: Starting pipeline.
2898	2025-10-11 12:39:58	TrigPipeline: Found Ready batch 90.
2899	2025-10-11 12:39:58	TrigPipeline: Updated batch 90 to Processing with RecordCount 70.
2900	10/11/2025 12:39:58	Timer: Detected Processing batch 90
2901	2025-10-11 12:40:00	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 12:40:00
2902	2025-10-11 12:40:00	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 12:40:00
2903	2025-10-11 12:40:45	PBatch3.bat: ETPProRt populated with 10 records. EndTime: 2025-10-11 12:40:45, Elapsed: 00:45
2904	2025-10-11 12:40:46	PBatch4.sql: Retry 1/60: ETPProRt has 10 rows
2905	2025-10-11 12:40:46	PBatch4.sql: ETPProRt contains 10 rows. Processing complete.
2906	2025-10-11 12:40:46	PBatch4.sql: Batch OID 336 marked as Completed. EndTime: 2025-10-11 12:40:46, ExecutionTime: 00:00:47
2907	2025-10-11 12:40:46	PBatch789.sql: Starting combined batch 7-9. StartTime: 2025-10-11 12:40:46
2908	2025-10-11 12:40:46	PBatch789.sql (7): Batch OID 336 marked as Completed. EndTime: 2025-10-11 12:40:46, ExecutionTime: 00:00:48
2909	2025-10-11 12:40:46	PBatch789.sql (8): Starting masking process. StartTime: 2025-10-11 12:40:46
2910	2025-10-11 12:40:46	PBatch789.sql (8): Using unique source column: oid. Elapsed: 00:00
2911	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 1. Elapsed: 00:00
2912	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2913	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
2914	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2915	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
2916	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2917	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
2918	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2919	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
2920	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2921	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
2922	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2923	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
2924	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
2925	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
2926	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 2. Elapsed: 00:00
2927	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2928	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
2929	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2930	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
2931	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2932	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
2933	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2934	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
2935	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2936	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
2937	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2938	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
2939	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
2940	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
2941	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 3. Elapsed: 00:00
2942	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2943	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
2944	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2945	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
2946	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2947	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
2948	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2949	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
2950	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2951	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
2952	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2953	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
2954	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
2955	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
2956	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 4. Elapsed: 00:00
2957	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2958	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
2959	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2960	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
2961	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2962	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
2963	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2964	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
2965	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2966	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
2967	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2968	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
2969	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
2970	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
2971	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 5. Elapsed: 00:00
2972	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2973	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
2974	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2975	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
2976	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2977	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
2978	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2979	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
2980	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2981	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
2982	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2983	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
2984	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
2985	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
2986	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 6. Elapsed: 00:00
2987	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
2988	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
2989	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
2990	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
2991	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
2992	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
2993	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
2994	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
2995	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
2996	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
2997	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
2998	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
2999	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3000	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
3001	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 7. Elapsed: 00:00
3002	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3003	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
3004	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3005	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
3006	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3007	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
3008	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3009	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
3010	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3011	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
3012	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3013	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
3014	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3015	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
3016	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 8. Elapsed: 00:00
3017	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3018	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
3019	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3020	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
3021	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3022	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
3023	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3024	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
3025	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3026	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
3027	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3028	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
3029	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3030	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
3031	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 9. Elapsed: 00:00
3032	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3033	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
3034	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3035	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
3036	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3037	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
3038	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3039	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
3040	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3041	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
3042	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3043	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
3044	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3045	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
3046	2025-10-11 12:40:46	PBatch789.sql (8): Processing ImportID: 10. Elapsed: 00:00
3047	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3048	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
3049	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3050	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
3051	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3052	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
3053	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3054	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
3055	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3056	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
3057	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3058	2025-10-11 12:40:46	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
3059	2025-10-11 12:40:46	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3060	2025-10-11 12:40:46	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
3061	2025-10-11 12:40:46	PBatch789.sql (8): Masking completed successfully for 70 records. EndTime: 2025-10-11 12:40:46, Elapsed: 00:00
3062	2025-10-11 12:40:46	PBatch789.sql (9): Starting ETPProAC population. StartTime: 2025-10-11 12:40:46
3063	2025-10-11 12:40:46	PBatch789.sql (9): ETPProAC populated with 10 records. EndTime: 2025-10-11 12:40:46, Elapsed: 00:00
3064	2025-10-11 12:40:46	PBatch789.sql: Combined batch 7-9 completed. EndTime: 2025-10-11 12:40:46
3065	2025-10-11 12:40:47	TriggerProc.bat: ETP/CTP Trigger Mode processing completed. EndTime: 2025-10-11 12:40:47
3067	10/11/2025 13:07:48	Timer: Detected Ready batch 91
3068	2025-10-11 13:07:51	TrigPipeline: Starting pipeline.
3069	2025-10-11 13:07:51	TrigPipeline: Found Ready batch 91.
3070	2025-10-11 13:07:51	TrigPipeline: Updated batch 91 to Processing with RecordCount 140.
3071	10/11/2025 13:07:51	Timer: Detected Processing batch 91
3072	2025-10-11 13:07:52	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 13:07:52
3073	2025-10-11 13:07:53	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 13:07:53
3074	2025-10-11 13:08:57	PBatch3.bat: ETPProRt populated with 20 records. EndTime: 2025-10-11 13:08:57, Elapsed: 01:04
3075	2025-10-11 13:08:57	PBatch4.sql: Retry 1/60: ETPProRt has 20 rows
3076	2025-10-11 13:08:57	PBatch4.sql: ETPProRt contains 20 rows. Processing complete.
3077	2025-10-11 13:08:57	PBatch4.sql: Batch OID 337 marked as Completed. EndTime: 2025-10-11 13:08:57, ExecutionTime: 00:01:06
3078	2025-10-11 13:08:57	PBatch789.sql: Starting combined batch 7-9. StartTime: 2025-10-11 13:08:57
3079	2025-10-11 13:08:57	PBatch789.sql (7): Batch OID 337 marked as Completed. EndTime: 2025-10-11 13:08:57, ExecutionTime: 00:01:06
3080	2025-10-11 13:08:57	PBatch789.sql (8): Starting masking process. StartTime: 2025-10-11 13:08:57
3081	2025-10-11 13:08:57	PBatch789.sql (8): Using unique source column: oid. Elapsed: 00:00
3082	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 1. Elapsed: 00:00
3083	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3084	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 1. Elapsed: 00:00
3085	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3086	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 1. Elapsed: 00:00
3087	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3088	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 1. Elapsed: 00:00
3089	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3090	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 1. Elapsed: 00:00
3091	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3092	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 1. Elapsed: 00:00
3093	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3094	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 1. Elapsed: 00:00
3095	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3096	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 1. Elapsed: 00:00
3097	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 2. Elapsed: 00:00
3098	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3099	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 2. Elapsed: 00:00
3100	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3101	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 2. Elapsed: 00:00
3102	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3103	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 2. Elapsed: 00:00
3104	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3105	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 2. Elapsed: 00:00
3106	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3107	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 2. Elapsed: 00:00
3108	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3109	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 2. Elapsed: 00:00
3110	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3111	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 2. Elapsed: 00:00
3112	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 3. Elapsed: 00:00
3113	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3114	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 3. Elapsed: 00:00
3115	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3116	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 3. Elapsed: 00:00
3117	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3118	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 3. Elapsed: 00:00
3119	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3120	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 3. Elapsed: 00:00
3121	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3122	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 3. Elapsed: 00:00
3123	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3386	10/11/2025 13:08:58	Timer: PBatch sequence completed for batch 91
3124	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 3. Elapsed: 00:00
3125	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3126	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 3. Elapsed: 00:00
3127	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 4. Elapsed: 00:00
3128	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3129	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 4. Elapsed: 00:00
3130	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3131	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 4. Elapsed: 00:00
3132	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3133	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 4. Elapsed: 00:00
3134	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3135	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 4. Elapsed: 00:00
3136	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3137	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 4. Elapsed: 00:00
3138	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3139	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 4. Elapsed: 00:00
3140	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3141	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 4. Elapsed: 00:00
3142	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 5. Elapsed: 00:00
3143	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3144	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 5. Elapsed: 00:00
3145	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3146	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 5. Elapsed: 00:00
3147	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3148	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 5. Elapsed: 00:00
3149	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3150	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 5. Elapsed: 00:00
3151	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3152	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 5. Elapsed: 00:00
3153	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3154	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 5. Elapsed: 00:00
3155	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3156	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 5. Elapsed: 00:00
3157	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 6. Elapsed: 00:00
3158	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3159	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 6. Elapsed: 00:00
3160	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3161	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 6. Elapsed: 00:00
3162	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3163	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 6. Elapsed: 00:00
3164	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3165	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 6. Elapsed: 00:00
3166	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3167	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 6. Elapsed: 00:00
3168	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3169	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 6. Elapsed: 00:00
3170	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3171	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 6. Elapsed: 00:00
3172	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 7. Elapsed: 00:00
3173	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3174	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 7. Elapsed: 00:00
3175	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3176	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 7. Elapsed: 00:00
3177	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3178	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 7. Elapsed: 00:00
3179	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3180	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 7. Elapsed: 00:00
3181	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3182	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 7. Elapsed: 00:00
3183	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3184	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 7. Elapsed: 00:00
3185	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3186	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 7. Elapsed: 00:00
3187	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 8. Elapsed: 00:00
3188	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3189	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 8. Elapsed: 00:00
3190	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3191	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 8. Elapsed: 00:00
3192	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3193	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 8. Elapsed: 00:00
3194	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3195	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 8. Elapsed: 00:00
3196	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3197	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 8. Elapsed: 00:00
3198	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3199	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 8. Elapsed: 00:00
3200	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3201	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 8. Elapsed: 00:00
3202	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 9. Elapsed: 00:00
3203	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3204	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 9. Elapsed: 00:00
3205	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3206	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 9. Elapsed: 00:00
3207	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3208	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 9. Elapsed: 00:00
3209	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3210	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 9. Elapsed: 00:00
3211	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3212	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 9. Elapsed: 00:00
3213	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3214	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 9. Elapsed: 00:00
3215	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3216	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 9. Elapsed: 00:00
3217	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 10. Elapsed: 00:00
3218	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3219	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 10. Elapsed: 00:00
3220	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3221	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 10. Elapsed: 00:00
3222	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3223	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 10. Elapsed: 00:00
3224	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3225	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 10. Elapsed: 00:00
3226	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3227	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 10. Elapsed: 00:00
3228	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3229	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 10. Elapsed: 00:00
3230	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3231	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 10. Elapsed: 00:00
3232	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 11. Elapsed: 00:00
3233	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3387	10/11/2025 16:58:48	Timer: Detected Ready batch 92
3234	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 11. Elapsed: 00:00
3235	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3236	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 11. Elapsed: 00:00
3237	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3238	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 11. Elapsed: 00:00
3239	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3240	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 11. Elapsed: 00:00
3241	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3242	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 11. Elapsed: 00:00
3243	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3244	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 11. Elapsed: 00:00
3245	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3246	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 11. Elapsed: 00:00
3247	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 12. Elapsed: 00:00
3248	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3249	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 12. Elapsed: 00:00
3250	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3251	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 12. Elapsed: 00:00
3252	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3253	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 12. Elapsed: 00:00
3254	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3255	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 12. Elapsed: 00:00
3256	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3257	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 12. Elapsed: 00:00
3258	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3259	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 12. Elapsed: 00:00
3260	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3261	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 12. Elapsed: 00:00
3262	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 13. Elapsed: 00:00
3263	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3264	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 13. Elapsed: 00:00
3265	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3266	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 13. Elapsed: 00:00
3267	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3268	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 13. Elapsed: 00:00
3269	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3270	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 13. Elapsed: 00:00
3271	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3272	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 13. Elapsed: 00:00
3273	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3274	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 13. Elapsed: 00:00
3275	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3276	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 13. Elapsed: 00:00
3277	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 14. Elapsed: 00:00
3278	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3279	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 14. Elapsed: 00:00
3280	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3281	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 14. Elapsed: 00:00
3282	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3283	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 14. Elapsed: 00:00
3284	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3285	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 14. Elapsed: 00:00
3286	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3287	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 14. Elapsed: 00:00
3288	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3289	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 14. Elapsed: 00:00
3290	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3291	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 14. Elapsed: 00:00
3292	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 15. Elapsed: 00:00
3293	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3294	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 15. Elapsed: 00:00
3295	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3296	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 15. Elapsed: 00:00
3297	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3298	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 15. Elapsed: 00:00
3299	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3300	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 15. Elapsed: 00:00
3301	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3302	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 15. Elapsed: 00:00
3303	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3304	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 15. Elapsed: 00:00
3305	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3306	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 15. Elapsed: 00:00
3307	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 16. Elapsed: 00:00
3308	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3309	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 16. Elapsed: 00:00
3310	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3311	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 16. Elapsed: 00:00
3312	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3313	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 16. Elapsed: 00:00
3314	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3315	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 16. Elapsed: 00:00
3316	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3317	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 16. Elapsed: 00:00
3318	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3319	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 16. Elapsed: 00:00
3320	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3321	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 16. Elapsed: 00:00
3322	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 17. Elapsed: 00:00
3323	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3324	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 17. Elapsed: 00:00
3325	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3326	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 17. Elapsed: 00:00
3327	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3328	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 17. Elapsed: 00:00
3329	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3330	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 17. Elapsed: 00:00
3331	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3332	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 17. Elapsed: 00:00
3333	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3334	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 17. Elapsed: 00:00
3335	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3336	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 17. Elapsed: 00:00
3337	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 18. Elapsed: 00:00
3338	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3339	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 18. Elapsed: 00:00
3340	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3341	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 18. Elapsed: 00:00
3342	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3343	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 18. Elapsed: 00:00
3344	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3345	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 18. Elapsed: 00:00
3346	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3347	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 18. Elapsed: 00:00
3348	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3349	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 18. Elapsed: 00:00
3350	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3351	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 18. Elapsed: 00:00
3352	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 19. Elapsed: 00:00
3353	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3354	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 19. Elapsed: 00:00
3355	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3356	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 19. Elapsed: 00:00
3357	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3358	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 19. Elapsed: 00:00
3359	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3360	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 19. Elapsed: 00:00
3361	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3362	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 19. Elapsed: 00:00
3363	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3364	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 19. Elapsed: 00:00
3365	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3366	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 19. Elapsed: 00:00
3367	2025-10-11 13:08:57	PBatch789.sql (8): Processing ImportID: 20. Elapsed: 00:00
3368	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3369	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 20. Elapsed: 00:00
3370	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3371	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 20. Elapsed: 00:00
3372	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3373	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 20. Elapsed: 00:00
3374	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3375	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 20. Elapsed: 00:00
3376	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3377	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 20. Elapsed: 00:00
3378	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3379	2025-10-11 13:08:57	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 20. Elapsed: 00:00
3380	2025-10-11 13:08:57	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3381	2025-10-11 13:08:57	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 20. Elapsed: 00:00
3382	2025-10-11 13:08:57	PBatch789.sql (8): Masking completed successfully for 140 records. EndTime: 2025-10-11 13:08:57, Elapsed: 00:00
3383	2025-10-11 13:08:57	PBatch789.sql (9): Starting ETPProAC population. StartTime: 2025-10-11 13:08:57
3384	2025-10-11 13:08:57	PBatch789.sql (9): ETPProAC populated with 20 records. EndTime: 2025-10-11 13:08:57, Elapsed: 00:00
3385	2025-10-11 13:08:57	PBatch789.sql: Combined batch 7-9 completed. EndTime: 2025-10-11 13:08:57
3388	2025-10-11 16:58:51	TrigPipeline: Starting pipeline.
3389	2025-10-11 16:58:51	TrigPipeline: Found Ready batch 92.
3390	2025-10-11 16:58:51	TrigPipeline: Updated batch 92 to Processing with RecordCount 350.
3391	10/11/2025 16:58:51	Timer: Detected Processing batch 92
3392	2025-10-11 16:58:53	TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: 2025-10-11 16:58:53
3393	2025-10-11 16:58:53	PBatch3.bat: Starting ETPProRt population. StartTime: 2025-10-11 16:58:53
3394	2025-10-11 17:01:50	PBatch3.bat: ETPProRt populated with 50 records. EndTime: 2025-10-11 17:01:50, Elapsed: 02:57
3395	2025-10-11 17:01:50	PBatch4.sql: Retry 1/60: ETPProRt has 50 rows
3396	2025-10-11 17:01:50	PBatch4.sql: ETPProRt contains 50 rows. Processing complete.
3397	2025-10-11 17:01:50	PBatch4.sql: Batch OID 338 marked as Completed. EndTime: 2025-10-11 17:01:50, ExecutionTime: 00:02:58
3398	2025-10-11 17:01:50	PBatch789.sql: Starting combined batch 7-9. StartTime: 2025-10-11 17:01:50
3399	2025-10-11 17:01:50	PBatch789.sql (7): Batch OID 338 marked as Completed. EndTime: 2025-10-11 17:01:50, ExecutionTime: 00:02:59
3400	2025-10-11 17:01:50	PBatch789.sql (8): Starting masking process. StartTime: 2025-10-11 17:01:50
3401	2025-10-11 17:01:50	PBatch789.sql (8): Using unique source column: oid. Elapsed: 00:00
3402	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 21. Elapsed: 00:00
3403	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3404	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 21. Elapsed: 00:00
3405	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3406	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 21. Elapsed: 00:00
3407	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3408	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 21. Elapsed: 00:00
3409	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3410	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 21. Elapsed: 00:00
3411	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3412	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 21. Elapsed: 00:00
3413	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3414	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 21. Elapsed: 00:00
3415	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3416	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 21. Elapsed: 00:00
3417	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 22. Elapsed: 00:00
3418	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3419	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 22. Elapsed: 00:00
3420	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3421	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 22. Elapsed: 00:00
3422	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3423	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 22. Elapsed: 00:00
3424	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3425	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 22. Elapsed: 00:00
3426	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3427	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 22. Elapsed: 00:00
3428	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3429	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 22. Elapsed: 00:00
3430	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3431	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 22. Elapsed: 00:00
3432	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 23. Elapsed: 00:00
3433	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3434	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 23. Elapsed: 00:00
3435	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3436	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 23. Elapsed: 00:00
3437	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3438	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 23. Elapsed: 00:00
3439	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3440	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 23. Elapsed: 00:00
3441	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3442	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 23. Elapsed: 00:00
3443	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3444	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 23. Elapsed: 00:00
3445	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3446	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 23. Elapsed: 00:00
3447	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 24. Elapsed: 00:00
3448	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3449	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 24. Elapsed: 00:00
3450	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3451	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 24. Elapsed: 00:00
3452	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3453	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 24. Elapsed: 00:00
3454	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3455	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 24. Elapsed: 00:00
3456	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3457	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 24. Elapsed: 00:00
3458	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3459	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 24. Elapsed: 00:00
3460	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3461	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 24. Elapsed: 00:00
3462	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 25. Elapsed: 00:00
3463	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3464	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 25. Elapsed: 00:00
3465	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3466	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 25. Elapsed: 00:00
3467	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3468	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 25. Elapsed: 00:00
3469	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3470	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 25. Elapsed: 00:00
3471	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3472	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 25. Elapsed: 00:00
3473	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3474	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 25. Elapsed: 00:00
3475	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3476	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 25. Elapsed: 00:00
3477	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 26. Elapsed: 00:00
3478	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3479	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 26. Elapsed: 00:00
3480	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3481	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 26. Elapsed: 00:00
3482	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3483	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 26. Elapsed: 00:00
3484	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3485	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 26. Elapsed: 00:00
3486	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3487	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 26. Elapsed: 00:00
3488	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3489	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 26. Elapsed: 00:00
3490	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3491	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 26. Elapsed: 00:00
3492	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 27. Elapsed: 00:00
3493	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3494	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 27. Elapsed: 00:00
3495	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3496	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 27. Elapsed: 00:00
3497	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3498	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 27. Elapsed: 00:00
3499	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3500	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 27. Elapsed: 00:00
3501	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3502	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 27. Elapsed: 00:00
3503	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3504	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 27. Elapsed: 00:00
3505	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3506	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 27. Elapsed: 00:00
3507	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 28. Elapsed: 00:00
3508	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3509	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 28. Elapsed: 00:00
3510	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3511	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 28. Elapsed: 00:00
3512	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3513	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 28. Elapsed: 00:00
3514	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3515	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 28. Elapsed: 00:00
3516	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3517	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 28. Elapsed: 00:00
3518	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3519	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 28. Elapsed: 00:00
3520	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3521	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 28. Elapsed: 00:00
3522	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 29. Elapsed: 00:00
3523	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3524	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 29. Elapsed: 00:00
3525	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3526	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 29. Elapsed: 00:00
3527	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3528	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 29. Elapsed: 00:00
3529	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3530	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 29. Elapsed: 00:00
3531	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3532	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 29. Elapsed: 00:00
3533	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3534	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 29. Elapsed: 00:00
3535	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3536	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 29. Elapsed: 00:00
3537	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 30. Elapsed: 00:00
3538	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3539	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 30. Elapsed: 00:00
3540	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3541	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 30. Elapsed: 00:00
3542	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3543	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 30. Elapsed: 00:00
3544	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3545	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 30. Elapsed: 00:00
3546	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3547	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 30. Elapsed: 00:00
3548	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3549	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 30. Elapsed: 00:00
3550	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3551	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 30. Elapsed: 00:00
3552	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 31. Elapsed: 00:00
3553	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3554	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 31. Elapsed: 00:00
3555	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3556	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 31. Elapsed: 00:00
3557	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3558	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 31. Elapsed: 00:00
3559	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3560	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 31. Elapsed: 00:00
3561	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3562	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 31. Elapsed: 00:00
3563	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3564	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 31. Elapsed: 00:00
3565	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3566	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 31. Elapsed: 00:00
3567	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 32. Elapsed: 00:00
3568	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3569	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 32. Elapsed: 00:00
3570	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3571	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 32. Elapsed: 00:00
3572	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3573	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 32. Elapsed: 00:00
3574	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3575	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 32. Elapsed: 00:00
3576	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3577	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 32. Elapsed: 00:00
3578	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3579	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 32. Elapsed: 00:00
3580	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3581	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 32. Elapsed: 00:00
3582	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 33. Elapsed: 00:00
3583	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3584	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 33. Elapsed: 00:00
3585	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3586	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 33. Elapsed: 00:00
3587	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3588	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 33. Elapsed: 00:00
3589	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3590	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 33. Elapsed: 00:00
3591	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3592	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 33. Elapsed: 00:00
3593	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3594	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 33. Elapsed: 00:00
3595	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3596	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 33. Elapsed: 00:00
3597	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 34. Elapsed: 00:00
3598	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3599	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 34. Elapsed: 00:00
3600	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3601	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 34. Elapsed: 00:00
3602	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3603	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 34. Elapsed: 00:00
3604	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3605	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 34. Elapsed: 00:00
3606	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3607	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 34. Elapsed: 00:00
3608	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3609	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 34. Elapsed: 00:00
3610	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3611	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 34. Elapsed: 00:00
3612	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 35. Elapsed: 00:00
3613	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3614	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 35. Elapsed: 00:00
3615	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3616	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 35. Elapsed: 00:00
3617	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3618	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 35. Elapsed: 00:00
3619	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3620	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 35. Elapsed: 00:00
3621	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3622	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 35. Elapsed: 00:00
3623	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3624	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 35. Elapsed: 00:00
3625	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3626	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 35. Elapsed: 00:00
3627	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 36. Elapsed: 00:00
3628	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3629	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 36. Elapsed: 00:00
3630	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3631	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 36. Elapsed: 00:00
3632	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3633	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 36. Elapsed: 00:00
3634	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3635	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 36. Elapsed: 00:00
3636	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3637	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 36. Elapsed: 00:00
3638	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3639	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 36. Elapsed: 00:00
3640	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3641	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 36. Elapsed: 00:00
3642	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 37. Elapsed: 00:00
3643	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3644	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 37. Elapsed: 00:00
3645	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3646	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 37. Elapsed: 00:00
3647	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3648	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 37. Elapsed: 00:00
3649	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3650	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 37. Elapsed: 00:00
3651	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3652	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 37. Elapsed: 00:00
3653	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3654	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 37. Elapsed: 00:00
3655	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3656	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 37. Elapsed: 00:00
3657	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 38. Elapsed: 00:00
3658	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3659	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 38. Elapsed: 00:00
3660	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3661	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 38. Elapsed: 00:00
3662	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3663	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 38. Elapsed: 00:00
3664	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3665	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 38. Elapsed: 00:00
3666	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3667	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 38. Elapsed: 00:00
3668	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3669	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 38. Elapsed: 00:00
3670	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3671	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 38. Elapsed: 00:00
3672	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 39. Elapsed: 00:00
3673	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3674	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 39. Elapsed: 00:00
3675	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3676	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 39. Elapsed: 00:00
3677	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3678	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 39. Elapsed: 00:00
3679	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3680	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 39. Elapsed: 00:00
3681	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3682	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 39. Elapsed: 00:00
3683	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3684	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 39. Elapsed: 00:00
3685	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3686	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 39. Elapsed: 00:00
3687	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 40. Elapsed: 00:00
3688	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3689	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 40. Elapsed: 00:00
3690	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3691	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 40. Elapsed: 00:00
3692	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3693	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 40. Elapsed: 00:00
3694	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3695	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 40. Elapsed: 00:00
3696	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3697	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 40. Elapsed: 00:00
3698	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3699	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 40. Elapsed: 00:00
3700	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3701	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 40. Elapsed: 00:00
3702	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 41. Elapsed: 00:00
3703	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3704	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 41. Elapsed: 00:00
3705	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3706	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 41. Elapsed: 00:00
3707	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3708	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 41. Elapsed: 00:00
3709	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3710	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 41. Elapsed: 00:00
3711	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3712	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 41. Elapsed: 00:00
3713	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3714	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 41. Elapsed: 00:00
3715	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3716	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 41. Elapsed: 00:00
3717	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 42. Elapsed: 00:00
3718	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3719	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 42. Elapsed: 00:00
3720	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3721	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 42. Elapsed: 00:00
3722	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3723	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 42. Elapsed: 00:00
3724	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3725	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 42. Elapsed: 00:00
3726	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3727	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 42. Elapsed: 00:00
3728	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3729	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 42. Elapsed: 00:00
3730	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3731	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 42. Elapsed: 00:00
3732	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 43. Elapsed: 00:00
3733	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3734	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 43. Elapsed: 00:00
3735	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3736	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 43. Elapsed: 00:00
3737	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3738	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 43. Elapsed: 00:00
3739	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3740	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 43. Elapsed: 00:00
3741	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3742	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 43. Elapsed: 00:00
3743	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3744	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 43. Elapsed: 00:00
3745	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3746	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 43. Elapsed: 00:00
3747	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 44. Elapsed: 00:00
3748	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3749	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 44. Elapsed: 00:00
3750	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3751	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 44. Elapsed: 00:00
3752	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3753	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 44. Elapsed: 00:00
3754	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3755	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 44. Elapsed: 00:00
3756	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3757	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 44. Elapsed: 00:00
3758	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3759	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 44. Elapsed: 00:00
3760	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3761	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 44. Elapsed: 00:00
3762	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 45. Elapsed: 00:00
3763	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3764	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 45. Elapsed: 00:00
3765	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3766	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 45. Elapsed: 00:00
3767	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3768	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 45. Elapsed: 00:00
3769	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3770	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 45. Elapsed: 00:00
3771	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3772	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 45. Elapsed: 00:00
3773	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3774	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 45. Elapsed: 00:00
3775	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3776	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 45. Elapsed: 00:00
3777	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 46. Elapsed: 00:00
3778	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3779	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 46. Elapsed: 00:00
3780	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3781	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 46. Elapsed: 00:00
3782	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3783	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 46. Elapsed: 00:00
3784	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3785	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 46. Elapsed: 00:00
3786	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3787	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 46. Elapsed: 00:00
3788	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3789	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 46. Elapsed: 00:00
3790	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3791	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 46. Elapsed: 00:00
3792	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 47. Elapsed: 00:00
3793	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3794	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 47. Elapsed: 00:00
3795	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3796	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 47. Elapsed: 00:00
3797	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3798	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 47. Elapsed: 00:00
3799	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3800	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 47. Elapsed: 00:00
3801	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3802	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 47. Elapsed: 00:00
3803	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3804	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 47. Elapsed: 00:00
3805	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3806	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 47. Elapsed: 00:00
3807	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 48. Elapsed: 00:00
3808	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3809	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 48. Elapsed: 00:00
3810	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3811	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 48. Elapsed: 00:00
3812	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3813	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 48. Elapsed: 00:00
3814	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3815	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 48. Elapsed: 00:00
3816	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3817	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 48. Elapsed: 00:00
3818	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3819	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 48. Elapsed: 00:00
3820	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3821	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 48. Elapsed: 00:00
3822	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 49. Elapsed: 00:00
3823	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3824	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 49. Elapsed: 00:00
3825	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3826	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 49. Elapsed: 00:00
3827	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3828	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 49. Elapsed: 00:00
3829	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3830	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 49. Elapsed: 00:00
3831	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3832	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 49. Elapsed: 00:00
3833	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3834	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 49. Elapsed: 00:00
3835	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3836	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 49. Elapsed: 00:00
3837	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 50. Elapsed: 00:00
3838	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3839	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 50. Elapsed: 00:00
3840	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3841	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 50. Elapsed: 00:00
3842	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3843	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 50. Elapsed: 00:00
3844	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3845	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 50. Elapsed: 00:00
3846	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3847	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 50. Elapsed: 00:00
3848	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3849	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 50. Elapsed: 00:00
3850	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3851	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 50. Elapsed: 00:00
3852	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 51. Elapsed: 00:00
3853	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3854	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 51. Elapsed: 00:00
3855	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3856	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 51. Elapsed: 00:00
3857	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3858	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 51. Elapsed: 00:00
3859	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3860	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 51. Elapsed: 00:00
3861	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3862	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 51. Elapsed: 00:00
3863	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3864	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 51. Elapsed: 00:00
3865	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3866	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 51. Elapsed: 00:00
3867	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 52. Elapsed: 00:00
3868	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3869	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 52. Elapsed: 00:00
3870	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3871	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 52. Elapsed: 00:00
3872	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3873	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 52. Elapsed: 00:00
3874	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3875	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 52. Elapsed: 00:00
3876	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3877	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 52. Elapsed: 00:00
3878	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3879	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 52. Elapsed: 00:00
3880	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3881	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 52. Elapsed: 00:00
3882	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 53. Elapsed: 00:00
3883	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3884	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 53. Elapsed: 00:00
3885	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3886	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 53. Elapsed: 00:00
3887	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3888	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 53. Elapsed: 00:00
3889	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3890	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 53. Elapsed: 00:00
3891	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3892	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 53. Elapsed: 00:00
3893	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3894	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 53. Elapsed: 00:00
3895	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3896	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 53. Elapsed: 00:00
3897	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 54. Elapsed: 00:00
3898	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3899	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 54. Elapsed: 00:00
3900	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3901	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 54. Elapsed: 00:00
3902	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3903	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 54. Elapsed: 00:00
3904	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3905	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 54. Elapsed: 00:00
3906	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3907	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 54. Elapsed: 00:00
3908	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3909	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 54. Elapsed: 00:00
3910	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3911	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 54. Elapsed: 00:00
3912	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 55. Elapsed: 00:00
3913	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3914	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 55. Elapsed: 00:00
3915	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3916	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 55. Elapsed: 00:00
3917	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3918	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 55. Elapsed: 00:00
3919	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3920	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 55. Elapsed: 00:00
3921	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3922	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 55. Elapsed: 00:00
3923	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3924	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 55. Elapsed: 00:00
3925	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3926	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 55. Elapsed: 00:00
3927	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 56. Elapsed: 00:00
3928	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3929	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 56. Elapsed: 00:00
3930	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3931	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 56. Elapsed: 00:00
3932	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3933	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 56. Elapsed: 00:00
3934	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3935	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 56. Elapsed: 00:00
3936	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3937	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 56. Elapsed: 00:00
3938	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3939	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 56. Elapsed: 00:00
3940	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3941	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 56. Elapsed: 00:00
3942	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 57. Elapsed: 00:00
3943	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3944	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 57. Elapsed: 00:00
3945	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3946	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 57. Elapsed: 00:00
3947	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3948	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 57. Elapsed: 00:00
3949	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3950	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 57. Elapsed: 00:00
3951	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3952	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 57. Elapsed: 00:00
3953	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3954	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 57. Elapsed: 00:00
3955	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3956	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 57. Elapsed: 00:00
3957	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 58. Elapsed: 00:00
3958	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3959	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 58. Elapsed: 00:00
3960	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3961	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 58. Elapsed: 00:00
3962	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3963	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 58. Elapsed: 00:00
3964	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3965	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 58. Elapsed: 00:00
3966	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3967	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 58. Elapsed: 00:00
3968	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3969	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 58. Elapsed: 00:00
3970	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3971	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 58. Elapsed: 00:00
3972	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 59. Elapsed: 00:00
3973	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3974	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 59. Elapsed: 00:00
3975	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3976	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 59. Elapsed: 00:00
3977	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3978	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 59. Elapsed: 00:00
3979	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3980	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 59. Elapsed: 00:00
3981	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3982	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 59. Elapsed: 00:00
3983	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3984	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 59. Elapsed: 00:00
3985	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
3986	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 59. Elapsed: 00:00
3987	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 60. Elapsed: 00:00
3988	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
3989	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 60. Elapsed: 00:00
3990	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
3991	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 60. Elapsed: 00:00
3992	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
3993	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 60. Elapsed: 00:00
3994	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
3995	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 60. Elapsed: 00:00
3996	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
3997	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 60. Elapsed: 00:00
3998	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
3999	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 60. Elapsed: 00:00
4000	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4001	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 60. Elapsed: 00:00
4002	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 61. Elapsed: 00:00
4003	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4004	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 61. Elapsed: 00:00
4005	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4006	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 61. Elapsed: 00:00
4007	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4008	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 61. Elapsed: 00:00
4009	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4010	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 61. Elapsed: 00:00
4011	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4012	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 61. Elapsed: 00:00
4013	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4014	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 61. Elapsed: 00:00
4015	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4016	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 61. Elapsed: 00:00
4017	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 62. Elapsed: 00:00
4018	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4019	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 62. Elapsed: 00:00
4020	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4021	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 62. Elapsed: 00:00
4022	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4023	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 62. Elapsed: 00:00
4024	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4025	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 62. Elapsed: 00:00
4026	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4027	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 62. Elapsed: 00:00
4028	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4029	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 62. Elapsed: 00:00
4030	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4031	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 62. Elapsed: 00:00
4032	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 63. Elapsed: 00:00
4033	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4034	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 63. Elapsed: 00:00
4035	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4036	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 63. Elapsed: 00:00
4037	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4038	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 63. Elapsed: 00:00
4039	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4040	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 63. Elapsed: 00:00
4041	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4042	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 63. Elapsed: 00:00
4043	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4044	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 63. Elapsed: 00:00
4045	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4046	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 63. Elapsed: 00:00
4047	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 64. Elapsed: 00:00
4048	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4049	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 64. Elapsed: 00:00
4050	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4051	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 64. Elapsed: 00:00
4052	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4053	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 64. Elapsed: 00:00
4054	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4055	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 64. Elapsed: 00:00
4056	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4057	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 64. Elapsed: 00:00
4058	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4059	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 64. Elapsed: 00:00
4060	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4061	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 64. Elapsed: 00:00
4062	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 65. Elapsed: 00:00
4063	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4064	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 65. Elapsed: 00:00
4065	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4066	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 65. Elapsed: 00:00
4067	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4068	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 65. Elapsed: 00:00
4069	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4070	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 65. Elapsed: 00:00
4071	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4072	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 65. Elapsed: 00:00
4073	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4074	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 65. Elapsed: 00:00
4075	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4076	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 65. Elapsed: 00:00
4077	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 66. Elapsed: 00:00
4078	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4079	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 66. Elapsed: 00:00
4080	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4081	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 66. Elapsed: 00:00
4082	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4083	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 66. Elapsed: 00:00
4084	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4085	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 66. Elapsed: 00:00
4086	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4087	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 66. Elapsed: 00:00
4088	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4089	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 66. Elapsed: 00:00
4090	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4091	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 66. Elapsed: 00:00
4092	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 67. Elapsed: 00:00
4093	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4094	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 67. Elapsed: 00:00
4095	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4096	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 67. Elapsed: 00:00
4097	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4098	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 67. Elapsed: 00:00
4099	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4100	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 67. Elapsed: 00:00
4101	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4102	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 67. Elapsed: 00:00
4103	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4104	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 67. Elapsed: 00:00
4105	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4106	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 67. Elapsed: 00:00
4107	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 68. Elapsed: 00:00
4108	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4109	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 68. Elapsed: 00:00
4110	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4111	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 68. Elapsed: 00:00
4112	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4113	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 68. Elapsed: 00:00
4114	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4115	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 68. Elapsed: 00:00
4116	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4117	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 68. Elapsed: 00:00
4118	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4119	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 68. Elapsed: 00:00
4120	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4121	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 68. Elapsed: 00:00
4122	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 69. Elapsed: 00:00
4123	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4124	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 69. Elapsed: 00:00
4125	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4126	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 69. Elapsed: 00:00
4127	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4128	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 69. Elapsed: 00:00
4129	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4130	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 69. Elapsed: 00:00
4131	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4132	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 69. Elapsed: 00:00
4133	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4134	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 69. Elapsed: 00:00
4135	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4136	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 69. Elapsed: 00:00
4137	2025-10-11 17:01:50	PBatch789.sql (8): Processing ImportID: 70. Elapsed: 00:00
4138	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ****************** to field: cc_number. Elapsed: 00:00
4139	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_number with masked value ****************** for ImportID 70. Elapsed: 00:00
4140	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: ******************* to field: cc_type. Elapsed: 00:00
4141	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cc_type with masked value ******************* for ImportID 70. Elapsed: 00:00
4142	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: ccexp_month. Elapsed: 00:00
4143	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_month with masked value * for ImportID 70. Elapsed: 00:00
4144	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: ccexp_year. Elapsed: 00:00
4145	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ccexp_year with masked value *** for ImportID 70. Elapsed: 00:00
4146	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: * to field: cnp_recurring. Elapsed: 00:00
4147	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_recurring with masked value * for ImportID 70. Elapsed: 00:00
4148	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: *** to field: cnp_security. Elapsed: 00:00
4149	2025-10-11 17:01:50	PBatch789.sql (8): Updated field cnp_security with masked value *** for ImportID 70. Elapsed: 00:00
4150	2025-10-11 17:01:50	PBatch789.sql (8): Applying masked value: 0 to field: ecode. Elapsed: 00:00
4151	2025-10-11 17:01:50	PBatch789.sql (8): Updated field ecode with masked value 0 for ImportID 70. Elapsed: 00:00
4152	2025-10-11 17:01:50	PBatch789.sql (8): Masking completed successfully for 350 records. EndTime: 2025-10-11 17:01:50, Elapsed: 00:00
4153	2025-10-11 17:01:50	PBatch789.sql (9): Starting ETPProAC population. StartTime: 2025-10-11 17:01:50
4154	2025-10-11 17:01:50	PBatch789.sql (9): ETPProAC populated with 50 records. EndTime: 2025-10-11 17:01:50, Elapsed: 00:00
4155	2025-10-11 17:01:50	PBatch789.sql: Combined batch 7-9 completed. EndTime: 2025-10-11 17:01:50
4156	10/11/2025 17:01:51	Timer: PBatch sequence completed for batch 92
\.


--
-- Data for Name: etpconfig; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpconfig (oid, option_name, option_value) FROM stdin;
1	TriggerEnabled	true
\.


--
-- Data for Name: etpfetbt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpfetbt (oid, batchnumber, templatenumber, username, dbtablename, recordcount, starttime, endtime, executiontime, status, notes) FROM stdin;
1	1	192	Sam	patients	1	2024-11-18 16:45:12	\N	\N	Pending	\N
2	2	192	Sam	patients	1	2024-11-18 16:50:54	\N	\N	Pending	\N
3	3	192	Sam	patients	1	2024-11-18 17:04:19	\N	\N	Pending	\N
4	4	192	Sam	patients	1	2024-11-18 19:03:38	2024-11-18 19:04:35	00:00:57	Completed	\N
5	5	192	Sam	patients	1	2024-11-19 18:08:41	2024-11-19 18:09:18	00:00:37	Completed	\N
6	6	192	Sam	patients	1	2024-11-20 13:50:30	2024-11-20 13:51:41	00:01:11	Completed	\N
7	7	192	Sam	patients	2	2024-11-22 17:58:45	2024-11-22 17:59:36	00:00:51	Completed	\N
8	8	192	Sam	patients	1	2024-12-21 21:33:29	\N	\N	Pending	\N
9	9	192	Sam	patients	1	2024-12-21 22:26:02	2024-12-21 22:28:15	00:02:13	Completed	\N
10	10	192	Sam	patients	1	2024-12-22 10:23:54	\N	\N	Pending	\N
11	11	192	Sam	patients	1	2024-12-22 10:30:33	\N	\N	Pending	\N
12	12	192	Sam	patients	1	2024-12-22 10:32:36	\N	\N	Pending	\N
13	13	192	Sam	patients	1	2024-12-22 10:50:27	\N	\N	Pending	\N
14	14	192	Sam	patients	1	2024-12-22 10:59:04	\N	\N	Pending	\N
15	15	192	Sam	patients	1	2024-12-22 11:13:03	\N	\N	Pending	\N
16	16	192	Sam	patients	1	2024-12-22 11:48:01	\N	\N	Pending	\N
17	17	192	Sam	patients	1	2024-12-23 13:52:37	\N	\N	Pending	\N
18	18	192	Sam	patients	1	2024-12-24 14:53:19	\N	\N	Pending	\N
19	19	192	Sam	patients	1	2024-12-24 19:45:18	\N	\N	Pending	\N
20	20	192	Sam	patients	1	2024-12-24 21:50:14	\N	\N	Pending	\N
21	21	192	Sam	patients	1	2024-12-25 13:57:13	\N	\N	Pending	\N
22	22	192	Sam	patients	2	2024-12-25 16:06:52	2024-12-25 16:09:17	00:02:25	Completed	\N
23	23	192	Sam	patients	3	2024-12-25 16:19:29	2024-12-25 16:20:24	00:00:55	Completed	\N
24	24	192	Sam	patients	1	2024-12-25 16:28:59	2024-12-25 16:29:18	00:00:19	Completed	\N
25	25	192	Sam	patients	1	2024-12-25 16:46:12	2024-12-25 16:46:27	00:00:15	Completed	\N
26	26	192	Sam	patients	1	2024-12-25 17:02:21	2024-12-25 17:02:31	00:00:10	Completed	\N
27	27	192	Sam	patients	1	2024-12-25 20:30:36	2024-12-25 20:30:47	00:00:11	Completed	\N
28	28	192	Doug	employees	2	2024-12-26 16:33:58	2024-12-26 16:34:11	00:00:13	Completed	\N
29	29	192	Doug	patients	1	2025-01-24 13:08:41	\N	\N	Pending	\N
30	30	192	Doug	patients	1	2025-01-24 14:30:20	\N	\N	Pending	\N
31	31	192	Doug	patients	1	2025-01-24 14:36:08	2025-01-24 14:36:28	00:00:20	Completed	\N
32	32	192	Doug	patients	1	2025-01-24 14:49:59	2025-01-24 14:50:30	00:00:31	Completed	\N
33	33	192	Doug	patients	1	2025-01-25 12:01:39	2025-01-25 12:02:10	00:00:31	Completed	\N
34	34	192	Doug	patients	1	2025-01-25 12:48:08	2025-01-25 12:48:33	00:00:25	Completed	\N
35	35	192	Doug	employees	1	2025-01-28 13:05:49	2025-01-28 13:06:07	00:00:18	Completed	\N
36	36	192	Doug	employees	1	2025-01-28 14:28:19	2025-01-28 14:28:47	00:00:28	Completed	\N
37	37	192	Doug	employees	1	2025-01-28 14:42:29	2025-01-28 14:43:03	00:00:34	Completed	\N
38	38	192	Doug	employees	1	2025-01-28 15:31:14	2025-01-28 15:31:33	00:00:19	Completed	\N
39	39	192	Doug	patients	1	2025-01-30 17:05:34	2025-01-30 17:05:44	00:00:10	Completed	\N
40	40	192	Doug	patients	1	2025-01-31 14:02:05	2025-01-31 14:02:16	00:00:11	Completed	\N
41	41	192	Doug	patients	7	2025-02-02 20:48:08	2025-02-02 20:48:34	00:00:26	Completed	\N
42	42	192	Doug	employees	2	2025-02-04 18:09:29	2025-02-04 18:11:42	00:02:13	Completed	\N
43	43	192	Doug	employees	2	2025-02-05 14:45:50	\N	\N	Pending	\N
44	44	192	Doug	employees	2	2025-02-05 15:01:35	\N	\N	Pending	\N
45	45	192	Doug	employees	2	2025-02-05 15:24:29	\N	\N	Pending	\N
46	46	192	Doug	employees	2	2025-02-05 15:25:45	2025-02-05 15:26:17	00:00:32	Completed	\N
47	47	192	Doug	employees	2	2025-02-05 15:52:53	2025-02-05 15:53:14	00:00:21	Completed	\N
48	48	192	Doug	employees	0	2025-02-05 19:03:29	2025-02-05 19:03:42	00:00:13	Completed	\N
49	49	192	Doug	employees	1	2025-02-06 13:28:06	2025-02-06 13:28:27	00:00:21	Completed	\N
50	50	192	Doug	employees	2	2025-02-24 16:49:59	2025-02-24 16:52:11	00:02:12	Completed	\N
51	51	192	Doug	employees	2	2025-02-24 17:14:03	\N	\N	Pending	\N
52	52	192	Doug	employees	2	2025-02-24 17:17:11	2025-02-24 17:17:47	00:00:36	Completed	\N
53	53	192	Doug	employees	1	2025-02-24 18:05:48	2025-02-24 18:06:02	00:00:14	Completed	\N
54	54	192	Doug	employees	2	2025-02-26 14:20:22	2025-02-26 14:21:10	00:00:48	Completed	\N
55	55	192	Doug	patients	1	2025-04-29 13:28:38	\N	\N	Pending	\N
56	56	192	Doug	patients	1	2025-04-29 13:30:30	2025-04-29 13:30:48	00:00:18	Completed	\N
57	57	192	Doug	patients	1	2025-04-29 13:33:52	2025-04-29 13:34:17	00:00:25	Completed	\N
58	58	192	Doug	patients	1	2025-04-29 13:37:20	2025-04-29 13:39:39	00:02:19	Completed	\N
59	59	192	Doug	patients	1	2025-04-29 13:45:55	2025-04-29 13:46:12	00:00:17	Completed	\N
60	60	192	Doug	patients	1	2025-04-29 14:28:33	\N	\N	Pending	\N
102	95	192	Doug	patients	4	2025-08-01 13:49:46	\N	\N	Pending	\N
61	61	192	Doug	patients	1	2025-04-29 14:52:58	2025-04-29 15:03:42	00:10:44	Completed	\N
62	62	192	Doug	patients	1	2025-04-29 15:05:02	2025-04-29 15:05:22	00:00:20	Completed	\N
63	63	192	Doug	patients	1	2025-04-29 15:24:24	2025-04-29 15:53:45	00:29:21	Completed	\N
103	96	192	Doug	patients	2	2025-08-01 13:57:28	\N	\N	Pending	\N
64	64	192	Doug	patients	1	2025-04-29 16:02:39	2025-04-29 17:28:41	01:26:02	Completed	\N
65	65	192	Doug	patients	1	2025-04-29 17:31:33	2025-04-29 17:31:49	00:00:16	Completed	\N
66	66	192	Doug	patients	1	2025-04-30 18:24:44	\N	\N	Pending	\N
67	67	192	Doug	patients	0	2025-05-02 12:51:54	2025-05-02 12:51:56	00:00:02	Completed	\N
68	68	192	Doug	patients	0	2025-05-02 13:01:48	\N	\N	Pending	\N
69	69	192	Doug	patients	0	2025-05-02 13:10:39	\N	\N	Pending	\N
70	70	192	Doug	patients	0	2025-05-02 13:11:43	\N	\N	Pending	\N
71	71	192	Doug	patients	0	2025-05-02 13:21:33	\N	\N	Pending	\N
72	72	192	Doug	patients	1	2025-05-02 13:43:47	2025-05-02 14:41:28	00:57:41	Completed	\N
73	73	192	Doug	patients	1	2025-05-02 16:04:23	2025-07-23 17:34:45	01:30:22	Completed	\N
81	74	192	Doug	patients	86	2025-07-24 21:12:48	\N	\N	Pending	\N
82	75	192	Doug	patients	86	2025-07-24 21:34:36	\N	\N	Pending	\N
83	76	192	Doug	patients	2	2025-07-24 22:16:23	\N	\N	Pending	\N
84	77	192	Doug	patients	1	2025-07-25 17:00:49	2025-07-25 17:01:02	00:00:13	Completed	\N
85	78	192	Doug	patients	1	2025-07-25 21:08:59	2025-07-25 21:09:08	00:00:09	Completed	\N
86	79	192	Doug	patients	2	2025-07-25 21:33:17	2025-07-25 21:33:27	00:00:10	Completed	\N
87	80	192	Doug	patients	4	2025-07-31 14:56:10	2025-07-31 15:47:55	00:51:45	Completed	\N
88	81	192	Doug	patients	4	2025-07-31 17:53:48	\N	\N	Pending	\N
89	82	192	Doug	patients	4	2025-07-31 18:16:36	2025-07-31 18:56:25	00:39:49	Completed	\N
90	83	192	Doug	patients	4	2025-07-31 18:56:44	\N	\N	Pending	\N
91	84	192	Doug	patients	4	2025-07-31 19:16:04	\N	\N	Pending	\N
92	85	192	Doug	patients	4	2025-07-31 19:29:06	\N	\N	Pending	\N
93	86	192	Doug	patients	4	2025-07-31 20:02:22	2025-07-31 20:35:07	00:32:45	Completed	\N
94	87	192	Doug	patients	0	2025-07-31 20:37:32	\N	\N	Pending	\N
95	88	192	Doug	patients	0	2025-07-31 20:59:27	\N	\N	Pending	\N
96	89	192	Doug	patients	0	2025-07-31 21:02:36	\N	\N	Pending	\N
97	90	192	Doug	patients	0	2025-07-31 21:11:56	\N	\N	Pending	\N
98	91	192	Doug	patients	0	2025-07-31 21:35:53	\N	\N	Pending	\N
99	92	192	Doug	patients	0	2025-08-01 11:58:27	\N	\N	Pending	\N
100	93	192	Doug	patients	2	2025-08-01 12:18:49	\N	\N	Pending	\N
101	94	192	Doug	patients	2	2025-08-01 12:32:54	\N	\N	Pending	\N
104	97	192	Doug	patients	4	2025-08-01 14:03:32	2025-08-01 14:04:01	00:00:29	Completed	\N
105	98	192	Doug	patients	2	2025-08-01 14:09:30	\N	\N	Pending	\N
106	99	192	Doug	patients	4	2025-08-01 14:16:37	2025-08-01 14:17:11	00:00:34	Completed	\N
107	100	192	Doug	patients	2	2025-08-01 14:17:44	\N	\N	Pending	\N
108	101	192	Doug	patients	4	2025-08-01 14:20:07	2025-08-01 14:20:27	00:00:20	Completed	\N
109	102	192	Doug	patients	4	2025-08-01 14:27:35	\N	\N	Pending	\N
110	103	192	Doug	patients	2	2025-08-01 14:50:02	2025-08-01 14:50:16	00:00:14	Completed	\N
111	104	192	Doug	patients	2	2025-08-01 15:00:22	2025-08-01 15:00:37	00:00:15	Completed	\N
113	105	0			0					\N
114	106	0			0		\N	\N		\N
119	110	192	Doug	patients	0	 8/05/2025 16:57:23			Pending	\N
117	108	192	Doug	patients	2	 8/04/2025 20:50:14	2025-08-04 21:22:52	00:32:38	Completed	\N
120	111	192	Doug	patients	0	 8/05/2025 17:00:57			Pending	\N
118	109	192	Doug	patients	2	 8/04/2025 23:45:51	2025-08-05 14:03:05	14:17:14	Completed	\N
121	112	192	Doug	patients	0	 8/07/2025 15:14:01	2025-08-07 15:14:28	00:00:27	Completed	\N
116	107	192	Doug	patients	2	 8/04/2025 15:41:50	2025-08-05 14:19:02	22:37:12	Completed	\N
122	113	192	Doug	patients	0	 8/07/2025 15:15:53			Pending	\N
123	114	192	Doug	patients	0	 8/07/2025 15:16:46	2025-08-07 23:03:21	07:46:35	Completed	\N
124	115	192	Doug	patients	0	 8/07/2025 23:56:29	2025-08-07 23:56:57	00:00:28	Completed	\N
125	116	192	Doug	patients	0	 8/08/2025 15:50:51			Pending	\N
126	117	192	Doug	patients	1	 8/08/2025 15:58:47	2025-08-08 15:59:17	00:00:30	Completed	\N
127	118	192	Doug- Sa	patients	1	 9/06/2025 12:00:15	2025-09-06 12:01:41	00:01:26	Completed	\N
\.


--
-- Data for Name: etpfetrq; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpfetrq (oid, templatenumber, dbtablename, username, importid, acode) FROM stdin;
1	192	patients	Doug	43	96C63CAC3CF6510
\.


--
-- Data for Name: etpfetrt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpfetrt (oid, templatenumber, dbtablename, username, importid, guestbook, datestamp, tstamp, returnoka, returnokb, acode, datafieldnumber, datafieldname, datavalue) FROM stdin;
\.


--
-- Data for Name: etppaclog; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etppaclog (oid, log_date, log_time, guestbook, batchnumber, importid, status) FROM stdin;
1	82034	8555787	114	109	126	Consumed
2	82034	8555951	115	109	127	Consumed
3	82037	5500632	127	0	209	Pending
4	82037	5500633	128	0	210	Pending
5	82037	5500634	129	0	211	Pending
6	82037	5500634	130	0	212	Pending
7	82037	5500635	131	0	213	Pending
8	82037	5500636	132	0	214	Pending
9	82037	5500636	133	0	215	Pending
10	82037	5500637	134	0	216	Pending
11	82037	5500637	135	0	217	Pending
12	82037	5500638	136	0	218	Pending
13	82037	5500638	137	0	219	Pending
14	82037	5500639	138	0	220	Pending
15	82037	5500640	139	0	221	Pending
16	82037	5500640	140	0	222	Pending
17	82037	5500641	141	0	223	Pending
18	82037	5500641	142	0	224	Pending
19	82037	5500641	143	0	225	Pending
20	82037	5500642	144	0	226	Pending
21	82037	5500643	145	0	227	Pending
22	82037	5500643	146	0	228	Pending
23	82037	5500644	147	0	229	Pending
24	82037	5500645	148	0	230	Pending
25	82037	5500645	149	0	231	Pending
26	82037	5500646	150	0	232	Pending
27	82037	5500647	151	0	233	Pending
28	82037	5500648	152	0	234	Pending
29	82037	5500648	153	0	235	Pending
30	82037	5500650	154	0	236	Pending
31	82037	5500651	155	0	237	Pending
32	82037	5500651	156	0	238	Pending
33	82037	5500652	157	0	239	Pending
34	82037	5500652	158	0	240	Pending
35	82037	5500653	159	0	241	Pending
36	82037	5500653	160	0	242	Pending
37	82037	5500654	161	0	243	Pending
38	82037	5500654	162	0	244	Pending
39	82037	5500654	163	0	245	Pending
40	82037	5500655	164	0	246	Pending
41	82037	5500655	165	0	247	Pending
42	82037	5500656	166	0	248	Pending
43	82037	5500656	167	0	249	Pending
44	82037	5500657	168	0	250	Pending
45	82037	5500657	169	0	251	Pending
46	82037	5500658	170	0	252	Pending
47	82037	5500658	171	0	253	Pending
48	82037	5500658	172	0	254	Pending
49	82037	5500659	173	0	255	Pending
50	82037	5500659	174	0	256	Pending
51	82037	5500660	175	0	257	Pending
52	82037	5500660	176	0	258	Pending
53	82037	5500661	177	0	259	Pending
54	82037	5500662	178	0	260	Pending
55	82037	5500662	178	0	260	Pending
56	82037	5500662	179	0	261	Pending
57	82037	5500663	179	0	261	Pending
58	82037	5500663	180	0	262	Pending
59	82037	5500664	180	0	262	Pending
60	82037	5500664	181	0	269	Pending
61	82037	5500665	182	0	270	Pending
62	82037	5500665	183	0	271	Pending
63	82037	5500666	186	0	142	Pending
64	82037	5500666	192	0	143	Pending
65	82037	5500667	193	0	143	Pending
66	82037	5500667	195	0	41	Pending
67	82037	5500668	196	0	41	Pending
68	82037	5500668	197	0	42	Pending
69	82037	5500669	203	0	126	Pending
70	82037	5500669	204	0	127	Pending
71	82037	8618941	126	0	208	Pending
72	82038	5752724	294	0	43	Pending
73	82067	4321502	297	0	43	Pending
\.


--
-- Data for Name: etpparam; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpparam (oid, batch_oid, min_id, max_id, min_gb, max_gb) FROM stdin;
1	87	43	43	297	297
29	0	0	0	\N	\N
\.


--
-- Data for Name: etpproac; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpproac (oid, importid, acode, guestbook, templatenumber, username, dbtablename) FROM stdin;
15	121	0197C2F7B1C6810	109	192	Doug	patients
16	123	D08411091673510	110	192	Doug	patients
17	124	05BF3A414FEFA21	113	192	Doug	patients
18	124	05BF3A414FEFA21	113	192	Doug	patients
19	126	F31DA42A1F5E910	114	192	Doug	patients
20	127	A5DF04F88C8BD10	115	192	Doug	patients
25	139	088D3834594D050	117	192	Doug	patients
26	140	289F4118ACFA300	118	192	Doug	patients
27	141	0B7D095580173F1	119	192	Doug	patients
28	148	0A95C592ACB4100	120	192	Doug	patients
29	149	813B339A7D3B1A1	121	192	Doug	patients
30	150	4F02072D825A100	122	192	Doug	patients
31	187	4D51B2FB7CEF010	123	192	Doug	patients
32	188	859245AB2FF6920	124	192	Doug	patients
33	189	0B2059E7E913750	125	192	Doug	patients
34	208	C4A22F4A8B89710	126	192	Doug	patients
35	209	A2282876C158310	127	192	Doug	patients
36	210	E7C5C6592D2A810	128	192	Doug	patients
37	211	D351D4C809D6C10	129	192	Doug	patients
38	212	949DA18BCF04D20	130	192	Doug	patients
39	213	C3661400AA2EE10	131	192	Doug	patients
40	214	FBD62CAE9AE9210	132	192	Doug	patients
41	215	B7303AB1E438700	133	192	Doug	patients
42	216	F1BE93A769A8600	134	192	Doug	patients
43	217	550019CEAFEFF10	135	192	Doug	patients
44	218	C85BD0EACD04470	136	192	Doug	patients
45	219	01316D0F70C09F1	137	192	Doug	patients
46	220	2E15DC565C03B20	138	192	Doug	patients
47	221	0AEEC54D03F5A01	139	192	Doug	patients
48	222	0CE32E1A106F411	140	192	Doug	patients
49	223	944852B868DC310	141	192	Doug	patients
50	224	07C679760D06760	142	192	Doug	patients
51	225	0517C8682FA9EC1	143	192	Doug	patients
52	226	01FEFC2D1230061	144	192	Doug	patients
53	227	973E1979BC4EA10	145	192	Doug	patients
54	228	882EC868C751FE1	146	192	Doug	patients
55	229	457BB115911E220	147	192	Doug	patients
56	230	7A87B79E51E6010	148	192	Doug	patients
57	231	82AE5ACD93F7F20	149	192	Doug	patients
58	232	20AEAC12B8C1700	150	192	Doug	patients
59	233	CF6DA5A573CB910	151	192	Doug	patients
60	234	08ECE40F995E7F1	152	192	Doug	patients
61	235	0800060878ACB20	153	192	Doug	patients
62	236	33BADDA416F6000	154	192	Doug	patients
63	237	7C0841248963400	155	192	Doug	patients
64	238	B6F34ED3361C920	156	192	Doug	patients
65	239	6D75F5C630FBC10	157	192	Doug	patients
66	240	84984A22B8D4191	158	192	Doug	patients
67	241	B8200E823328F20	159	192	Doug	patients
68	242	81621782927F420	160	192	Doug	patients
69	243	BF9AE4B78563910	161	192	Doug	patients
70	244	884703114405200	162	192	Doug	patients
71	245	0D2567ED4A1B040	163	192	Doug	patients
72	246	240060710D55210	164	192	Doug	patients
73	247	DA391C0F8381500	165	192	Doug	patients
74	248	AEB388532A08320	166	192	Doug	patients
75	249	838B94D797A79D1	167	192	Doug	patients
76	250	8563EE2CAE3EC10	168	192	Doug	patients
77	251	943BB4ACBD7AD10	169	192	Doug	patients
78	252	06F1A8BBB5746D1	170	192	Doug	patients
79	253	9976C749E211300	171	192	Doug	patients
80	254	1D780985C9C6A20	172	192	Doug	patients
81	255	8C1CC0DD96E9020	173	192	Doug	patients
82	256	407E0E184BDD320	174	192	Doug	patients
83	257	1958F3707B6E500	175	192	Doug	patients
84	258	194938D69011710	176	192	Doug	patients
85	259	0CE68736433D001	177	192	Doug	patients
86	260	8DBFC47339FE500	178	192	Doug	patients
87	261	9830821A3989E20	179	192	Doug	patients
88	262	502B0F4BF130410	180	192	Doug	patients
89	260	8DBFC47339FE500	178	192	Doug	patients
90	261	9830821A3989E20	179	192	Doug	patients
91	262	502B0F4BF130410	180	192	Doug	patients
92	269	58C3C4CDB40D610	181	192	Doug	patients
93	270	0E3E52DF7019B20	182	192	Doug	patients
94	271	4761B3BE67B9A60	183	192	Doug	patients
96	142	864F642C07C2300	186	192	Doug	patients
100	41	0B44488620CE211	196	192	Doug	patients
101	42	EE45A387772F610	197	192	Doug	patients
103	126	4397620160DC320	203	192	Doug	patients
104	127	34F11563E089D20	204	192	Doug	patients
105	43	E562B3A54B20510	294	192	Doug	patients
107	263	4E6946DA4035D10	296	192	Doug	patients
108	43	96C63CAC3CF6510	297	192	Doug	patients
109	43	80E38E692BEEBA1	299	192	Doug	eccpend
110	1	13EFFAAB868E200	300	192	Doug	eccpend
111	2	738F043B003ED10	301	192	Doug	eccpend
112	3	7515A033D1C1820	302	192	Doug	eccpend
113	4	3BE80BE3B98A310	303	192	Doug	eccpend
114	5	6C4C518E168A920	304	192	Doug	eccpend
115	6	004FCDB261E00D1	305	192	Doug	eccpend
116	7	26F998E7355EF20	306	192	Doug	eccpend
117	8	4EE9D1634004E20	307	192	Doug	eccpend
118	9	716BED612C33E20	308	192	Doug	eccpend
119	10	004778696C8EB70	309	192	Doug	eccpend
120	1	201BC2A678C9B10	310	192	Doug	eccpend
121	2	23C7E2BE9F7D700	311	192	Doug	eccpend
122	3	66824D5C8327F10	312	192	Doug	eccpend
123	4	FBC018154A38020	313	192	Doug	eccpend
124	5	FFD62AC0943A010	314	192	Doug	eccpend
125	6	ED889F93CF52010	315	192	Doug	eccpend
126	7	CA656189E147910	316	192	Doug	eccpend
127	8	101CD29AE263B20	317	192	Doug	eccpend
128	9	3DE055E51B72010	318	192	Doug	eccpend
129	10	0E77274720DA851	319	192	Doug	eccpend
130	1	15DC63B4D5FA910	320	192	Doug	eccpend
131	2	833FCBF29FFAF10	321	192	Doug	eccpend
132	3	08137C960D04220	322	192	Doug	eccpend
133	4	6AB7AD415D70D10	323	192	Doug	eccpend
134	5	719D55EC626B310	324	192	Doug	eccpend
135	6	011055FAA118531	325	192	Doug	eccpend
136	7	0B0469C98242D41	326	192	Doug	eccpend
137	8	B3FF01CA6068510	327	192	Doug	eccpend
138	9	09637C281D39F81	328	192	Doug	eccpend
139	10	F605DDA3839E600	329	192	Doug	eccpend
140	1	CA3994274773250	330	192	Doug	eccpend
141	2	BC60D40B276C910	331	192	Doug	eccpend
142	3	4450CE35573B100	332	192	Doug	eccpend
143	4	8C8DFCAEEFDF3D1	333	192	Doug	eccpend
144	5	01F3554940BE131	334	192	Doug	eccpend
145	6	29A54A98751F920	335	192	Doug	eccpend
146	7	034CA5C3F2AAB41	336	192	Doug	eccpend
147	8	C7E9F09AECEB510	337	192	Doug	eccpend
148	9	3B9465946CB7010	338	192	Doug	eccpend
149	10	C4D1792D254E220	339	192	Doug	eccpend
150	1	B64749D49979910	340	192	Doug	eccpend
151	2	AAF3C4B336D1100	341	192	Doug	eccpend
152	3	117E21E64C42920	342	192	Doug	eccpend
153	4	0EC02614A2C9B91	343	192	Doug	eccpend
154	5	93085C28554C020	344	192	Doug	eccpend
155	6	4D8AB5B05096320	345	192	Doug	eccpend
156	7	098F2EB01B59C10	346	192	Doug	eccpend
157	8	C8B049AB3FFD920	347	192	Doug	eccpend
158	9	CABFD20A4FF5710	348	192	Doug	eccpend
159	10	1EA8832BB433C20	349	192	Doug	eccpend
160	1	9BEA6EB22D9F810	350	192	Doug	eccpend
161	2	036BF9F236CC120	351	192	Doug	eccpend
162	3	4D732407629B300	352	192	Doug	eccpend
163	4	2161A8EEF2DB220	353	192	Doug	eccpend
164	5	5CFF71C1D5E2100	354	192	Doug	eccpend
165	6	8F01974D439CC01	355	192	Doug	eccpend
166	7	A563F2E1FCD8710	356	192	Doug	eccpend
167	8	4C5CD64012E1510	357	192	Doug	eccpend
168	9	0297FA4EB28E410	358	192	Doug	eccpend
169	10	03C249CB5C9F4E1	359	192	Doug	eccpend
170	11	8D7DF6029491220	360	192	Doug	eccpend
171	12	284CE7392014120	361	192	Doug	eccpend
172	13	9F16F66EDC43500	362	192	Doug	eccpend
173	14	2BE0417D7B2B200	363	192	Doug	eccpend
174	15	4AD7CD5A0531F10	364	192	Doug	eccpend
175	16	8F3699B3A827B10	365	192	Doug	eccpend
176	17	A2E6BEC2D5A6F30	366	192	Doug	eccpend
177	18	DBCA6B3BD3F2010	367	192	Doug	eccpend
178	19	27B8CE28E266010	368	192	Doug	eccpend
179	20	0A9936792E5E711	369	192	Doug	eccpend
180	21	202389FDCA4C220	370	192	Doug	eccpend
181	22	7C506BBDCD0A700	371	192	Doug	eccpend
182	23	82D8E6C4EFA1770	372	192	Doug	eccpend
183	24	7CB04C9BC7D3D10	373	192	Doug	eccpend
184	25	776728D16BA9210	374	192	Doug	eccpend
185	26	CAFD0DBF8B55A20	375	192	Doug	eccpend
186	27	48D3E8389AFB600	376	192	Doug	eccpend
187	28	C372929F1205710	377	192	Doug	eccpend
188	29	8056095CC1DF391	378	192	Doug	eccpend
189	30	819E4C98DDE3AE1	379	192	Doug	eccpend
190	31	B97BAB2546B1300	380	192	Doug	eccpend
191	32	3E6C68367AECE10	381	192	Doug	eccpend
192	33	01EA5143BAB3AD1	382	192	Doug	eccpend
193	34	21E02B4A6CDB810	383	192	Doug	eccpend
194	35	B9F3813230CA820	384	192	Doug	eccpend
195	36	0471E78A37A6E31	385	192	Doug	eccpend
196	37	A8A2D85E3F19F10	386	192	Doug	eccpend
197	38	0CDFD0EE03D0320	387	192	Doug	eccpend
198	39	05715392BC3B020	388	192	Doug	eccpend
199	40	06E4049D68D04E1	389	192	Doug	eccpend
200	41	AA7AE6DA76C7820	390	192	Doug	eccpend
201	42	11ADC8A12CF3700	391	192	Doug	eccpend
202	43	5AE5479CBE76D10	392	192	Doug	eccpend
203	44	25704938782DC10	393	192	Doug	eccpend
204	45	C5AFD713A60B200	394	192	Doug	eccpend
205	46	ED5505970354A20	395	192	Doug	eccpend
206	47	00F011546594311	396	192	Doug	eccpend
207	48	0992561A3E90500	397	192	Doug	eccpend
208	49	DAD53D01D3D8700	398	192	Doug	eccpend
209	50	386F9BDB3B35410	399	192	Doug	eccpend
210	51	855745322355870	400	192	Doug	eccpend
211	52	8F6E79A44EF7E10	401	192	Doug	eccpend
212	53	9E33AED40218100	402	192	Doug	eccpend
213	54	85A95E4E1C7B091	403	192	Doug	eccpend
214	55	24E0C3A81E25810	404	192	Doug	eccpend
215	56	0304C57F4595CA1	405	192	Doug	eccpend
216	57	07B4316B79780F1	406	192	Doug	eccpend
217	58	0069DDF39731E30	407	192	Doug	eccpend
218	59	73A7C7A1B26D200	408	192	Doug	eccpend
219	60	6B7F47AB2836320	409	192	Doug	eccpend
220	61	0ACDDDBC0D3F851	410	192	Doug	eccpend
221	62	8DD5B42C84F3F20	411	192	Doug	eccpend
222	63	06C687C37454410	412	192	Doug	eccpend
223	64	062F31AF278EB70	413	192	Doug	eccpend
224	65	0F28F75D25DB5F1	414	192	Doug	eccpend
225	66	0E9C035E1100711	415	192	Doug	eccpend
226	67	0727C39F1A0E100	416	192	Doug	eccpend
227	68	82D9E4BF49AA220	417	192	Doug	eccpend
228	69	3546EFB58BCD710	418	192	Doug	eccpend
229	70	AC3B9FDFE15F200	419	192	Doug	eccpend
\.


--
-- Data for Name: etpprobf; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprobf (oid, guestbook, location, templatenumber, username, dbtablename, importid, datafieldnumber, datafieldname, datavalue) FROM stdin;
\.


--
-- Data for Name: etpprobt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprobt (oid, batchnumber, templatenumber, username, dbtablename, recordcount, starttime, endtime, executiontime, status, notes) FROM stdin;
236	18	192	Doug	patients	1	2025-05-08 13:47:33.363134-04	\N	\N	Completed	\N
218	1	192	Doug	patients	1	2025-05-07 19:00:09.458708-04	\N	\N	Completed	\N
219	2	192	Doug	patients	1	2025-05-07 20:12:58.806171-04	\N	\N	Completed	\N
220	3	192	Doug	patients	1	2025-05-07 20:13:23.724815-04	\N	\N	Completed	\N
221	4	192	Doug	patients	1	2025-05-07 21:22:49.945913-04	\N	\N	Completed	\N
237	19	192	Doug	patients	1	2025-05-08 18:53:21.933843-04	2025-05-08 18:53:48.073442	00:00:26	Completed	\N
222	5	192	Doug	patients	1	2025-05-07 21:23:24.380299-04	\N	\N	Completed	\N
224	6	192	Doug	patients	1	2025-05-08 12:13:38.649047-04	\N	\N	Completed	\N
225	7	192	Doug	patients	1	2025-05-08 12:14:03.148879-04	\N	\N	Completed	\N
238	20	192	Doug	patients	1	2025-05-12 13:51:33.101857-04	2025-05-12 13:52:22.385903	00:00:49	Completed	\N
226	8	192	Doug	patients	1	2025-05-08 12:31:33.428616-04	\N	\N	Completed	\N
227	9	192	Doug	patients	1	2025-05-08 12:32:58.555315-04	\N	\N	Completed	\N
228	10	192	Doug	patients	1	2025-05-08 12:33:28.307708-04	\N	\N	Completed	\N
247	28	192	Doug	patients	1	2025-05-12 16:54:20.390602-04	2025-05-12 16:54:44.720143	00:00:24	Completed	\N
254	35	192	Doug	patients	3	2025-05-12 18:15:44.616388-04	2025-07-10 20:48:28.009882	02:32:43	Completed	\N
229	11	192	Doug	patients	1	2025-05-08 13:13:50.120036-04	2025-05-08 13:14:16.729441	00:00:26	Completed	\N
230	12	192	Doug	patients	1	2025-05-08 13:30:46.885736-04	\N	\N	Completed	\N
239	21	192	Doug	patients	1	2025-05-12 14:57:58.275295-04	2025-05-12 14:58:16.38221	00:00:18	Completed	\N
231	13	192	Doug	patients	1	2025-05-08 13:31:47.547522-04	\N	\N	Completed	\N
232	14	192	Doug	patients	1	2025-05-08 13:32:02.100226-04	\N	\N	Completed	\N
233	15	192	Doug	patients	1	2025-05-08 13:32:42.878205-04	\N	\N	Completed	\N
234	16	192	Doug	patients	1	2025-05-08 13:40:57.50041-04	\N	\N	Completed	\N
255	36	192	Doug	patients	1	2025-05-12 19:51:35.756231-04	\N	\N	Completed	\N
235	17	192	Doug	patients	1	2025-05-08 13:47:17.227069-04	\N	\N	Completed	\N
241	23	192	Doug	patients	1	2025-05-12 15:17:35.937153-04	2025-05-12 15:18:02.661524	00:00:26	Completed	\N
261	42	192	Doug	patients	1	2025-05-12 21:21:24.933311-04	2025-05-12 21:21:51.223242	00:00:26	Completed	\N
243	25	192	Doug	patients	1	2025-05-12 15:39:24.283498-04	2025-05-12 15:39:43.133523	00:00:18	Completed	\N
249	30	192	Doug	patients	1	2025-05-12 17:15:28.006949-04	2025-05-12 17:15:53.873375	00:00:25	Completed	\N
245	27	192	Doug	patients	1	2025-05-12 16:06:07.961789-04	2025-05-12 16:06:36.569619	00:00:28	Completed	\N
258	39	192	Doug	patients	3	2025-05-12 20:13:20.679643-04	2025-05-12 20:13:43.257917	00:00:22	Completed	\N
250	31	192	Doug	patients	3	2025-05-12 17:15:36.381927-04	2025-07-10 22:42:37.990335	05:27:01	Completed	\N
251	32	192	Doug	patients	1	2025-05-12 17:44:19.227122-04	\N	\N	Completed	\N
257	38	192	Doug	patients	1	2025-05-12 20:13:14.318622-04	\N	\N	Completed	\N
253	34	192	Doug	patients	1	2025-05-12 18:15:37.039958-04	\N	\N	Completed	\N
260	41	192	Doug	patients	3	2025-05-12 20:44:03.536523-04	2025-05-12 20:44:22.037943	00:00:18	Completed	\N
259	40	192	Doug	patients	1	2025-05-12 20:43:56.707428-04	\N	\N	Completed	\N
268	49	192	Doug	patients	3	2025-05-13 11:34:46.122772-04	2025-05-13 11:35:04.512407	00:00:18	Completed	\N
262	43	192	Doug	patients	1	2025-05-12 21:51:47.136093-04	2025-05-12 21:52:17.085234	00:00:29	Completed	\N
266	47	192	Doug	patients	6	2025-05-13 11:32:06.597591-04	2025-05-13 11:32:24.347701	00:00:17	Completed	\N
263	44	192	Doug	patients	1	2025-05-12 22:10:24.282613-04	\N	\N	Completed	\N
265	46	192	Doug	patients	1	2025-05-13 11:31:58.089067-04	\N	\N	Completed	\N
264	45	192	Doug	patients	1	2025-05-12 22:24:44.111496-04	\N	\N	Completed	\N
270	51	192	Doug	patients	1	2025-07-10 16:35:30	\N	\N	Pending	\N
267	48	192	Doug	patients	1	2025-05-13 11:34:40.215994-04	\N	\N	Completed	\N
269	50	192	Doug	patients	0	2025-07-10 15:02:47	\N	\N	Pending	\N
256	37	192	Doug	patients	3	2025-05-12 19:51:47.468405-04	2025-07-10 17:04:00.057939	21:12:12	Completed	\N
272	53	192	Doug	patients	1	2025-07-10 22:19:28	2025-07-11 19:17:32.977568	20:58:04	Completed	\N
271	52	192	Doug	patients	1	2025-07-10 20:48:16	2025-07-10 21:19:03.653864	00:30:47	Completed	\N
252	33	192	Doug	patients	3	2025-05-12 17:44:28.12156-04	2025-07-10 22:19:36.524192	04:35:08	Completed	\N
273	54	192	Doug	patients	1	2025-07-12 12:23:48	\N	\N	Pending	\N
274	55	192	Doug	patients	1	2025-07-12 12:24:54	\N	\N	Pending	\N
248	29	192	Doug	patients	3	2025-05-12 16:54:26.583964-04	2025-07-12 15:59:56.396649	23:05:29	Completed	\N
275	56	192	Doug	patients	1	2025-07-12 19:01:54	\N	\N	Pending	\N
276	57	192	Doug	patients	1	2025-07-12 20:35:05	\N	\N	Pending	\N
277	58	192	Doug	patients	1	2025-07-12 20:53:19	\N	\N	Pending	\N
278	59	192	Doug	patients	1	2025-07-12 21:49:11	\N	\N	Pending	\N
279	60	192	Doug	patients	1	2025-07-12 22:37:01	\N	\N	Pending	\N
280	61	192	Doug	patients	1	2025-07-13 14:19:04	\N	\N	Pending	\N
281	62	192	Doug	patients	1	2025-07-13 14:27:29	\N	\N	Pending	\N
282	63	192	Doug	patients	1	2025-07-13 15:36:00	\N	\N	Pending	\N
283	64	192	Doug	patients	1	2025-07-13 15:50:44	\N	\N	Pending	\N
284	65	192	Doug	patients	1	2025-07-13 15:59:47	\N	\N	Pending	\N
285	66	192	Doug	patients	1	2025-07-13 16:02:39	\N	\N	Pending	\N
286	67	192	Doug	patients	1	2025-07-13 16:28:59	\N	\N	Pending	\N
287	68	192	Doug	patients	1	2025-07-13 16:35:20	\N	\N	Pending	\N
288	69	192	Doug	patients	1	2025-07-13 16:55:26	2025-07-13 16:55:32.511057	00:00:06	Completed	\N
289	70	192	Doug	patients	1	2025-07-13 17:26:02	\N	\N	Pending	\N
305	86	192	Doug	eccpend	1	2025-09-29 18:07:54	2025-09-29 18:08:03	00:00:09	Completed	\N
290	71	192	Doug	patients	1	2025-07-13 17:39:44	2025-07-13 17:39:51.277699	00:00:07	Completed	\N
291	72	192	Doug	patients	0	2025-07-16 15:02:36	\N	\N	Pending	\N
292	73	192	Doug	patients	0	2025-07-16 15:23:53	\N	\N	Pending	\N
293	74	192	Doug	patients	0	2025-07-16 15:28:00	\N	\N	Pending	\N
294	75	192	Doug	patients	1	2025-07-16 15:43:44	\N	\N	Pending	\N
295	76	192	Doug	patients	1	2025-07-17 13:34:29	\N	\N	Pending	\N
296	77	192	Doug	patients	1	2025-07-17 13:37:19	\N	\N	Pending	\N
297	78	192	Doug	patients	1	2025-07-17 13:42:09	\N	\N	Pending	\N
298	79	192	Doug	patients	1	2025-07-17 13:51:55	2025-07-17 14:09:21	00:17:26	Completed	\N
299	80	192	Doug	patients	1	2025-07-17 17:15:40	2025-07-17 17:15:48	00:00:08	Completed	\N
300	81	192	Doug	patients	1	2025-07-19 16:35:32	2025-07-19 16:35:39	00:00:07	Completed	\N
301	82	192	Doug	patients	2	2025-07-31 14:19:17	2025-07-31 14:19:29	00:00:12	Completed	\N
302	83	192	Doug	patients	1	2025-08-08 15:56:23	2025-08-08 15:56:36	00:00:13	Completed	\N
303	84	192	Doug	patients	1	2025-09-02 19:15:09	2025-09-02 19:15:17	00:00:08	Completed	\N
304	85	192	Doug	patients	1	2025-09-06 11:46:13	2025-09-06 11:46:25	00:00:12	Completed	\N
338	92	192	Doug	eccpend	350	2025-10-11 16:58:51.457217	2025-10-11 17:01:50	00:02:59	Completed	\N
332	87	192	Doug	eccpend	1	2025-10-10 23:42:05.548109-04	2025-10-11 00:04:51	00:22:45	Completed	\N
334	88	192	Doug	eccpend	1	2025-10-11 00:11:20.518924-04	2025-10-11 00:12:19	00:00:58	Completed	\N
335	89	192	Doug	eccpend	70	2025-10-11 00:42:38.498749	2025-10-11 00:43:22	00:00:44	Completed	\N
336	90	192	Doug	eccpend	70	2025-10-11 12:39:58.309809	2025-10-11 12:40:46	00:00:48	Completed	\N
337	91	192	Doug	eccpend	140	2025-10-11 13:07:51.089151	2025-10-11 13:08:57	00:01:06	Completed	\N
\.


--
-- Data for Name: etpprofm; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprofm (oid, templatenumber, datafieldname, datafieldnumber) FROM stdin;
4196	192	cc_number	1
4197	192	cc_type	2
4198	192	ccexp_month	3
4199	192	ccexp_year	4
4200	192	cnp_recurring	5
4201	192	cnp_security	6
4202	192	ecode	7
\.


--
-- Data for Name: etpprohd; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprohd (oid, location, templatenumber, username, dbtablename, uniquesourcecolumn, gencrypt) FROM stdin;
158	27858	192	Doug	eccpend	oid	1
\.


--
-- Data for Name: etpprorq; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprorq (oid, guestbook, location, templatenumber, username, dbtablename, importid, datafieldnumber, datafieldname, datavalue) FROM stdin;
2	\N	27858	192	Doug	eccpend	21	2	D2	Visa
3	\N	27858	192	Doug	eccpend	21	3	D3	12
4	\N	27858	192	Doug	eccpend	21	4	D4	2027
5	\N	27858	192	Doug	eccpend	21	5	D5	N
6	\N	27858	192	Doug	eccpend	21	6	D6	1234
7	\N	27858	192	Doug	eccpend	21	7	D7	1000
8	\N	27858	192	Doug	eccpend	22	1	D1	5555555555554444
9	\N	27858	192	Doug	eccpend	22	2	D2	MasterCard
10	\N	27858	192	Doug	eccpend	22	3	D3	06
11	\N	27858	192	Doug	eccpend	22	4	D4	2026
12	\N	27858	192	Doug	eccpend	22	5	D5	Y
13	\N	27858	192	Doug	eccpend	22	6	D6	5678
14	\N	27858	192	Doug	eccpend	22	7	D7	2001
15	\N	27858	192	Doug	eccpend	23	1	D1	6011111111111117
16	\N	27858	192	Doug	eccpend	23	2	D2	Discover
17	\N	27858	192	Doug	eccpend	23	3	D3	03
18	\N	27858	192	Doug	eccpend	23	4	D4	2028
19	\N	27858	192	Doug	eccpend	23	5	D5	N
20	\N	27858	192	Doug	eccpend	23	6	D6	9012
21	\N	27858	192	Doug	eccpend	23	7	D7	1000
22	\N	27858	192	Doug	eccpend	24	1	D1	378282246310005
23	\N	27858	192	Doug	eccpend	24	2	D2	Amex
24	\N	27858	192	Doug	eccpend	24	3	D3	09
25	\N	27858	192	Doug	eccpend	24	4	D4	2027
26	\N	27858	192	Doug	eccpend	24	5	D5	N
27	\N	27858	192	Doug	eccpend	24	6	D6	3456
28	\N	27858	192	Doug	eccpend	24	7	D7	3002
29	\N	27858	192	Doug	eccpend	25	1	D1	4000123456789010
30	\N	27858	192	Doug	eccpend	25	2	D2	Visa
31	\N	27858	192	Doug	eccpend	25	3	D3	11
32	\N	27858	192	Doug	eccpend	25	4	D4	2026
33	\N	27858	192	Doug	eccpend	25	5	D5	Y
34	\N	27858	192	Doug	eccpend	25	6	D6	7890
35	\N	27858	192	Doug	eccpend	25	7	D7	1000
36	\N	27858	192	Doug	eccpend	26	1	D1	5105105105105100
37	\N	27858	192	Doug	eccpend	26	2	D2	MasterCard
38	\N	27858	192	Doug	eccpend	26	3	D3	05
39	\N	27858	192	Doug	eccpend	26	4	D4	2025
40	\N	27858	192	Doug	eccpend	26	5	D5	N
41	\N	27858	192	Doug	eccpend	26	6	D6	2345
42	\N	27858	192	Doug	eccpend	26	7	D7	4001
43	\N	27858	192	Doug	eccpend	27	1	D1	6011000990139424
44	\N	27858	192	Doug	eccpend	27	2	D2	Discover
45	\N	27858	192	Doug	eccpend	27	3	D3	08
46	\N	27858	192	Doug	eccpend	27	4	D4	2027
47	\N	27858	192	Doug	eccpend	27	5	D5	N
48	\N	27858	192	Doug	eccpend	27	6	D6	6789
49	\N	27858	192	Doug	eccpend	27	7	D7	1000
50	\N	27858	192	Doug	eccpend	28	1	D1	4111111111111111
51	\N	27858	192	Doug	eccpend	28	2	D2	Visa
52	\N	27858	192	Doug	eccpend	28	3	D3	02
53	\N	27858	192	Doug	eccpend	28	4	D4	2024
54	\N	27858	192	Doug	eccpend	28	5	D5	Y
55	\N	27858	192	Doug	eccpend	28	6	D6	1234
56	\N	27858	192	Doug	eccpend	28	7	D7	2002
57	\N	27858	192	Doug	eccpend	29	1	D1	5555555555554444
58	\N	27858	192	Doug	eccpend	29	2	D2	MasterCard
59	\N	27858	192	Doug	eccpend	29	3	D3	07
60	\N	27858	192	Doug	eccpend	29	4	D4	2028
61	\N	27858	192	Doug	eccpend	29	5	D5	N
62	\N	27858	192	Doug	eccpend	29	6	D6	5678
63	\N	27858	192	Doug	eccpend	29	7	D7	1000
64	\N	27858	192	Doug	eccpend	30	1	D1	378734493671000
65	\N	27858	192	Doug	eccpend	30	2	D2	Amex
66	\N	27858	192	Doug	eccpend	30	3	D3	04
67	\N	27858	192	Doug	eccpend	30	4	D4	2027
68	\N	27858	192	Doug	eccpend	30	5	D5	N
69	\N	27858	192	Doug	eccpend	30	6	D6	9012
70	\N	27858	192	Doug	eccpend	30	7	D7	3003
71	\N	27858	192	Doug	eccpend	31	1	D1	4000123456789010
72	\N	27858	192	Doug	eccpend	31	2	D2	Visa
73	\N	27858	192	Doug	eccpend	31	3	D3	10
74	\N	27858	192	Doug	eccpend	31	4	D4	2026
75	\N	27858	192	Doug	eccpend	31	5	D5	Y
76	\N	27858	192	Doug	eccpend	31	6	D6	3456
77	\N	27858	192	Doug	eccpend	31	7	D7	1000
78	\N	27858	192	Doug	eccpend	32	1	D1	5105105105105100
79	\N	27858	192	Doug	eccpend	32	2	D2	MasterCard
80	\N	27858	192	Doug	eccpend	32	3	D3	01
81	\N	27858	192	Doug	eccpend	32	4	D4	2025
82	\N	27858	192	Doug	eccpend	32	5	D5	N
84	\N	27858	192	Doug	eccpend	32	7	D7	4002
85	\N	27858	192	Doug	eccpend	33	1	D1	6011000990139424
86	\N	27858	192	Doug	eccpend	33	2	D2	Discover
87	\N	27858	192	Doug	eccpend	33	3	D3	06
88	\N	27858	192	Doug	eccpend	33	4	D4	2027
89	\N	27858	192	Doug	eccpend	33	5	D5	N
90	\N	27858	192	Doug	eccpend	33	6	D6	6789
91	\N	27858	192	Doug	eccpend	33	7	D7	1000
92	\N	27858	192	Doug	eccpend	34	1	D1	4111111111111111
93	\N	27858	192	Doug	eccpend	34	2	D2	Visa
94	\N	27858	192	Doug	eccpend	34	3	D3	03
95	\N	27858	192	Doug	eccpend	34	4	D4	2024
96	\N	27858	192	Doug	eccpend	34	5	D5	Y
97	\N	27858	192	Doug	eccpend	34	6	D6	1234
98	\N	27858	192	Doug	eccpend	34	7	D7	2003
99	\N	27858	192	Doug	eccpend	35	1	D1	5555555555554444
100	\N	27858	192	Doug	eccpend	35	2	D2	MasterCard
101	\N	27858	192	Doug	eccpend	35	3	D3	09
102	\N	27858	192	Doug	eccpend	35	4	D4	2028
103	\N	27858	192	Doug	eccpend	35	5	D5	N
104	\N	27858	192	Doug	eccpend	35	6	D6	5678
105	\N	27858	192	Doug	eccpend	35	7	D7	1000
106	\N	27858	192	Doug	eccpend	36	1	D1	378734493671000
107	\N	27858	192	Doug	eccpend	36	2	D2	Amex
108	\N	27858	192	Doug	eccpend	36	3	D3	02
109	\N	27858	192	Doug	eccpend	36	4	D4	2027
110	\N	27858	192	Doug	eccpend	36	5	D5	N
111	\N	27858	192	Doug	eccpend	36	6	D6	9012
112	\N	27858	192	Doug	eccpend	36	7	D7	3004
113	\N	27858	192	Doug	eccpend	37	1	D1	4000123456789010
114	\N	27858	192	Doug	eccpend	37	2	D2	Visa
115	\N	27858	192	Doug	eccpend	37	3	D3	08
116	\N	27858	192	Doug	eccpend	37	4	D4	2026
117	\N	27858	192	Doug	eccpend	37	5	D5	Y
118	\N	27858	192	Doug	eccpend	37	6	D6	3456
119	\N	27858	192	Doug	eccpend	37	7	D7	1000
120	\N	27858	192	Doug	eccpend	38	1	D1	5105105105105100
121	\N	27858	192	Doug	eccpend	38	2	D2	MasterCard
122	\N	27858	192	Doug	eccpend	38	3	D3	04
123	\N	27858	192	Doug	eccpend	38	4	D4	2025
124	\N	27858	192	Doug	eccpend	38	5	D5	N
125	\N	27858	192	Doug	eccpend	38	6	D6	2345
126	\N	27858	192	Doug	eccpend	38	7	D7	4003
127	\N	27858	192	Doug	eccpend	39	1	D1	6011000990139424
128	\N	27858	192	Doug	eccpend	39	2	D2	Discover
129	\N	27858	192	Doug	eccpend	39	3	D3	07
130	\N	27858	192	Doug	eccpend	39	4	D4	2027
131	\N	27858	192	Doug	eccpend	39	5	D5	N
132	\N	27858	192	Doug	eccpend	39	6	D6	6789
133	\N	27858	192	Doug	eccpend	39	7	D7	1000
134	\N	27858	192	Doug	eccpend	40	1	D1	4111111111111111
135	\N	27858	192	Doug	eccpend	40	2	D2	Visa
136	\N	27858	192	Doug	eccpend	40	3	D3	01
137	\N	27858	192	Doug	eccpend	40	4	D4	2024
138	\N	27858	192	Doug	eccpend	40	5	D5	Y
139	\N	27858	192	Doug	eccpend	40	6	D6	1234
140	\N	27858	192	Doug	eccpend	40	7	D7	2004
141	\N	27858	192	Doug	eccpend	41	1	D1	4111111111111111
142	\N	27858	192	Doug	eccpend	41	2	D2	Visa
143	\N	27858	192	Doug	eccpend	41	3	D3	12
144	\N	27858	192	Doug	eccpend	41	4	D4	2027
145	\N	27858	192	Doug	eccpend	41	5	D5	N
146	\N	27858	192	Doug	eccpend	41	6	D6	1234
147	\N	27858	192	Doug	eccpend	41	7	D7	1000
148	\N	27858	192	Doug	eccpend	42	1	D1	5555555555554444
149	\N	27858	192	Doug	eccpend	42	2	D2	MasterCard
150	\N	27858	192	Doug	eccpend	42	3	D3	06
151	\N	27858	192	Doug	eccpend	42	4	D4	2026
152	\N	27858	192	Doug	eccpend	42	5	D5	Y
153	\N	27858	192	Doug	eccpend	42	6	D6	5678
154	\N	27858	192	Doug	eccpend	42	7	D7	2001
155	\N	27858	192	Doug	eccpend	43	1	D1	6011111111111117
156	\N	27858	192	Doug	eccpend	43	2	D2	Discover
157	\N	27858	192	Doug	eccpend	43	3	D3	03
158	\N	27858	192	Doug	eccpend	43	4	D4	2028
159	\N	27858	192	Doug	eccpend	43	5	D5	N
160	\N	27858	192	Doug	eccpend	43	6	D6	9012
161	\N	27858	192	Doug	eccpend	43	7	D7	1000
162	\N	27858	192	Doug	eccpend	44	1	D1	378282246310005
163	\N	27858	192	Doug	eccpend	44	2	D2	Amex
164	\N	27858	192	Doug	eccpend	44	3	D3	09
166	\N	27858	192	Doug	eccpend	44	5	D5	N
167	\N	27858	192	Doug	eccpend	44	6	D6	3456
168	\N	27858	192	Doug	eccpend	44	7	D7	3002
169	\N	27858	192	Doug	eccpend	45	1	D1	4000123456789010
170	\N	27858	192	Doug	eccpend	45	2	D2	Visa
171	\N	27858	192	Doug	eccpend	45	3	D3	11
172	\N	27858	192	Doug	eccpend	45	4	D4	2026
173	\N	27858	192	Doug	eccpend	45	5	D5	Y
174	\N	27858	192	Doug	eccpend	45	6	D6	7890
175	\N	27858	192	Doug	eccpend	45	7	D7	1000
176	\N	27858	192	Doug	eccpend	46	1	D1	5105105105105100
177	\N	27858	192	Doug	eccpend	46	2	D2	MasterCard
178	\N	27858	192	Doug	eccpend	46	3	D3	05
179	\N	27858	192	Doug	eccpend	46	4	D4	2025
180	\N	27858	192	Doug	eccpend	46	5	D5	N
181	\N	27858	192	Doug	eccpend	46	6	D6	2345
182	\N	27858	192	Doug	eccpend	46	7	D7	4001
183	\N	27858	192	Doug	eccpend	47	1	D1	6011000990139424
184	\N	27858	192	Doug	eccpend	47	2	D2	Discover
185	\N	27858	192	Doug	eccpend	47	3	D3	08
186	\N	27858	192	Doug	eccpend	47	4	D4	2027
187	\N	27858	192	Doug	eccpend	47	5	D5	N
188	\N	27858	192	Doug	eccpend	47	6	D6	6789
189	\N	27858	192	Doug	eccpend	47	7	D7	1000
190	\N	27858	192	Doug	eccpend	48	1	D1	4111111111111111
191	\N	27858	192	Doug	eccpend	48	2	D2	Visa
192	\N	27858	192	Doug	eccpend	48	3	D3	02
193	\N	27858	192	Doug	eccpend	48	4	D4	2024
194	\N	27858	192	Doug	eccpend	48	5	D5	Y
195	\N	27858	192	Doug	eccpend	48	6	D6	1234
196	\N	27858	192	Doug	eccpend	48	7	D7	2002
197	\N	27858	192	Doug	eccpend	49	1	D1	5555555555554444
198	\N	27858	192	Doug	eccpend	49	2	D2	MasterCard
199	\N	27858	192	Doug	eccpend	49	3	D3	07
200	\N	27858	192	Doug	eccpend	49	4	D4	2028
201	\N	27858	192	Doug	eccpend	49	5	D5	N
202	\N	27858	192	Doug	eccpend	49	6	D6	5678
203	\N	27858	192	Doug	eccpend	49	7	D7	1000
204	\N	27858	192	Doug	eccpend	50	1	D1	378734493671000
205	\N	27858	192	Doug	eccpend	50	2	D2	Amex
206	\N	27858	192	Doug	eccpend	50	3	D3	04
207	\N	27858	192	Doug	eccpend	50	4	D4	2027
208	\N	27858	192	Doug	eccpend	50	5	D5	N
209	\N	27858	192	Doug	eccpend	50	6	D6	9012
210	\N	27858	192	Doug	eccpend	50	7	D7	3003
211	\N	27858	192	Doug	eccpend	51	1	D1	4000123456789010
212	\N	27858	192	Doug	eccpend	51	2	D2	Visa
213	\N	27858	192	Doug	eccpend	51	3	D3	10
214	\N	27858	192	Doug	eccpend	51	4	D4	2026
215	\N	27858	192	Doug	eccpend	51	5	D5	Y
216	\N	27858	192	Doug	eccpend	51	6	D6	3456
217	\N	27858	192	Doug	eccpend	51	7	D7	1000
218	\N	27858	192	Doug	eccpend	52	1	D1	5105105105105100
219	\N	27858	192	Doug	eccpend	52	2	D2	MasterCard
220	\N	27858	192	Doug	eccpend	52	3	D3	01
221	\N	27858	192	Doug	eccpend	52	4	D4	2025
222	\N	27858	192	Doug	eccpend	52	5	D5	N
223	\N	27858	192	Doug	eccpend	52	6	D6	2345
224	\N	27858	192	Doug	eccpend	52	7	D7	4002
225	\N	27858	192	Doug	eccpend	53	1	D1	6011000990139424
226	\N	27858	192	Doug	eccpend	53	2	D2	Discover
227	\N	27858	192	Doug	eccpend	53	3	D3	06
228	\N	27858	192	Doug	eccpend	53	4	D4	2027
229	\N	27858	192	Doug	eccpend	53	5	D5	N
230	\N	27858	192	Doug	eccpend	53	6	D6	6789
231	\N	27858	192	Doug	eccpend	53	7	D7	1000
232	\N	27858	192	Doug	eccpend	54	1	D1	4111111111111111
233	\N	27858	192	Doug	eccpend	54	2	D2	Visa
234	\N	27858	192	Doug	eccpend	54	3	D3	03
235	\N	27858	192	Doug	eccpend	54	4	D4	2024
236	\N	27858	192	Doug	eccpend	54	5	D5	Y
237	\N	27858	192	Doug	eccpend	54	6	D6	1234
238	\N	27858	192	Doug	eccpend	54	7	D7	2003
239	\N	27858	192	Doug	eccpend	55	1	D1	5555555555554444
240	\N	27858	192	Doug	eccpend	55	2	D2	MasterCard
241	\N	27858	192	Doug	eccpend	55	3	D3	09
242	\N	27858	192	Doug	eccpend	55	4	D4	2028
243	\N	27858	192	Doug	eccpend	55	5	D5	N
244	\N	27858	192	Doug	eccpend	55	6	D6	5678
245	\N	27858	192	Doug	eccpend	55	7	D7	1000
246	\N	27858	192	Doug	eccpend	56	1	D1	378734493671000
248	\N	27858	192	Doug	eccpend	56	3	D3	02
249	\N	27858	192	Doug	eccpend	56	4	D4	2027
250	\N	27858	192	Doug	eccpend	56	5	D5	N
251	\N	27858	192	Doug	eccpend	56	6	D6	9012
252	\N	27858	192	Doug	eccpend	56	7	D7	3004
253	\N	27858	192	Doug	eccpend	57	1	D1	4000123456789010
254	\N	27858	192	Doug	eccpend	57	2	D2	Visa
255	\N	27858	192	Doug	eccpend	57	3	D3	08
256	\N	27858	192	Doug	eccpend	57	4	D4	2026
257	\N	27858	192	Doug	eccpend	57	5	D5	Y
258	\N	27858	192	Doug	eccpend	57	6	D6	3456
259	\N	27858	192	Doug	eccpend	57	7	D7	1000
260	\N	27858	192	Doug	eccpend	58	1	D1	5105105105105100
261	\N	27858	192	Doug	eccpend	58	2	D2	MasterCard
262	\N	27858	192	Doug	eccpend	58	3	D3	04
263	\N	27858	192	Doug	eccpend	58	4	D4	2025
264	\N	27858	192	Doug	eccpend	58	5	D5	N
265	\N	27858	192	Doug	eccpend	58	6	D6	2345
266	\N	27858	192	Doug	eccpend	58	7	D7	4003
267	\N	27858	192	Doug	eccpend	59	1	D1	6011000990139424
268	\N	27858	192	Doug	eccpend	59	2	D2	Discover
269	\N	27858	192	Doug	eccpend	59	3	D3	07
270	\N	27858	192	Doug	eccpend	59	4	D4	2027
271	\N	27858	192	Doug	eccpend	59	5	D5	N
272	\N	27858	192	Doug	eccpend	59	6	D6	6789
273	\N	27858	192	Doug	eccpend	59	7	D7	1000
274	\N	27858	192	Doug	eccpend	60	1	D1	4111111111111111
275	\N	27858	192	Doug	eccpend	60	2	D2	Visa
276	\N	27858	192	Doug	eccpend	60	3	D3	01
277	\N	27858	192	Doug	eccpend	60	4	D4	2024
278	\N	27858	192	Doug	eccpend	60	5	D5	Y
279	\N	27858	192	Doug	eccpend	60	6	D6	1234
280	\N	27858	192	Doug	eccpend	60	7	D7	2004
281	\N	27858	192	Doug	eccpend	61	1	D1	4111111111111111
282	\N	27858	192	Doug	eccpend	61	2	D2	Visa
283	\N	27858	192	Doug	eccpend	61	3	D3	12
284	\N	27858	192	Doug	eccpend	61	4	D4	2027
285	\N	27858	192	Doug	eccpend	61	5	D5	N
286	\N	27858	192	Doug	eccpend	61	6	D6	1234
287	\N	27858	192	Doug	eccpend	61	7	D7	1000
288	\N	27858	192	Doug	eccpend	62	1	D1	5555555555554444
289	\N	27858	192	Doug	eccpend	62	2	D2	MasterCard
290	\N	27858	192	Doug	eccpend	62	3	D3	06
291	\N	27858	192	Doug	eccpend	62	4	D4	2026
292	\N	27858	192	Doug	eccpend	62	5	D5	Y
293	\N	27858	192	Doug	eccpend	62	6	D6	5678
294	\N	27858	192	Doug	eccpend	62	7	D7	2001
295	\N	27858	192	Doug	eccpend	63	1	D1	6011111111111117
296	\N	27858	192	Doug	eccpend	63	2	D2	Discover
297	\N	27858	192	Doug	eccpend	63	3	D3	03
298	\N	27858	192	Doug	eccpend	63	4	D4	2028
299	\N	27858	192	Doug	eccpend	63	5	D5	N
300	\N	27858	192	Doug	eccpend	63	6	D6	9012
301	\N	27858	192	Doug	eccpend	63	7	D7	1000
302	\N	27858	192	Doug	eccpend	64	1	D1	378282246310005
303	\N	27858	192	Doug	eccpend	64	2	D2	Amex
304	\N	27858	192	Doug	eccpend	64	3	D3	09
305	\N	27858	192	Doug	eccpend	64	4	D4	2027
306	\N	27858	192	Doug	eccpend	64	5	D5	N
307	\N	27858	192	Doug	eccpend	64	6	D6	3456
308	\N	27858	192	Doug	eccpend	64	7	D7	3002
309	\N	27858	192	Doug	eccpend	65	1	D1	4000123456789010
310	\N	27858	192	Doug	eccpend	65	2	D2	Visa
311	\N	27858	192	Doug	eccpend	65	3	D3	11
312	\N	27858	192	Doug	eccpend	65	4	D4	2026
313	\N	27858	192	Doug	eccpend	65	5	D5	Y
314	\N	27858	192	Doug	eccpend	65	6	D6	7890
315	\N	27858	192	Doug	eccpend	65	7	D7	1000
316	\N	27858	192	Doug	eccpend	66	1	D1	378734493671000
317	\N	27858	192	Doug	eccpend	66	2	D2	Amex
318	\N	27858	192	Doug	eccpend	66	3	D3	02
319	\N	27858	192	Doug	eccpend	66	4	D4	2027
320	\N	27858	192	Doug	eccpend	66	5	D5	N
321	\N	27858	192	Doug	eccpend	66	6	D6	9012
322	\N	27858	192	Doug	eccpend	66	7	D7	4001
323	\N	27858	192	Doug	eccpend	67	1	D1	4000123456789010
324	\N	27858	192	Doug	eccpend	67	2	D2	Visa
325	\N	27858	192	Doug	eccpend	67	3	D3	08
326	\N	27858	192	Doug	eccpend	67	4	D4	2026
327	\N	27858	192	Doug	eccpend	67	5	D5	Y
328	\N	27858	192	Doug	eccpend	67	6	D6	3456
1	\N	27858	192	Doug	eccpend	21	1	D1	4111111111111111
83	\N	27858	192	Doug	eccpend	32	6	D6	2345
165	\N	27858	192	Doug	eccpend	44	4	D4	2027
247	\N	27858	192	Doug	eccpend	56	2	D2	Amex
329	\N	27858	192	Doug	eccpend	67	7	D7	1000
330	\N	27858	192	Doug	eccpend	68	1	D1	5105105105105100
331	\N	27858	192	Doug	eccpend	68	2	D2	MasterCard
332	\N	27858	192	Doug	eccpend	68	3	D3	04
333	\N	27858	192	Doug	eccpend	68	4	D4	2025
334	\N	27858	192	Doug	eccpend	68	5	D5	N
335	\N	27858	192	Doug	eccpend	68	6	D6	2345
336	\N	27858	192	Doug	eccpend	68	7	D7	4003
337	\N	27858	192	Doug	eccpend	69	1	D1	6011000990139424
338	\N	27858	192	Doug	eccpend	69	2	D2	Discover
339	\N	27858	192	Doug	eccpend	69	3	D3	07
340	\N	27858	192	Doug	eccpend	69	4	D4	2027
341	\N	27858	192	Doug	eccpend	69	5	D5	N
342	\N	27858	192	Doug	eccpend	69	6	D6	6789
343	\N	27858	192	Doug	eccpend	69	7	D7	1000
344	\N	27858	192	Doug	eccpend	70	1	D1	4111111111111111
345	\N	27858	192	Doug	eccpend	70	2	D2	Visa
346	\N	27858	192	Doug	eccpend	70	3	D3	01
347	\N	27858	192	Doug	eccpend	70	4	D4	2024
348	\N	27858	192	Doug	eccpend	70	5	D5	Y
349	\N	27858	192	Doug	eccpend	70	6	D6	1234
350	\N	27858	192	Doug	eccpend	70	7	D7	2004
\.


--
-- Data for Name: etpprort; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprort (oid, templatenumber, dbtablename, username, importid, guestbook, acode, actiontype, returnoka, returnokb, datestamp, tstamp) FROM stdin;
\.


--
-- Data for Name: etpprosr; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprosr (oid, guestbook, location, templatenumber, username, dbtablename, importid) FROM stdin;
\.


--
-- Data for Name: etpprotp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.etpprotp (oid, templatenumber, fieldname, fieldnumber, masktype) FROM stdin;
275	192	oid	1	unknown
276	192	dateord	2	unknown
277	192	etp_vendor_code	3	text
278	192	etp_vault_number	4	unknown
279	192	ecode	5	number
280	192	response	6	text
281	192	ordernum	7	unknown
282	192	status	8	text
283	192	tid	9	text
284	192	order_type	10	text
285	192	transaction_type	11	text
286	192	billing_name	12	text
287	192	billing_first_name	13	text
288	192	billing_last_name	14	text
289	192	billing_zip	15	text
290	192	billing_email	16	text
291	192	cc_type	17	text
292	192	cc_number	18	text
293	192	ccexp_month	19	text
294	192	ccexp_year	20	text
295	192	cnp_recurring	21	text
296	192	cnp_security	22	text
297	192	counter	23	text
298	192	grand_total	24	text
299	192	product_description	25	text
300	192	purchase_order_number	26	text
301	192	sales_tax	27	text
302	192	track1	28	text
303	192	track2	29	text
\.


--
-- Name: etp_log_logoid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etp_log_logoid_seq', 4157, true);


--
-- Name: etpconfig_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpconfig_oid_seq', 231, true);


--
-- Name: etpfetbt_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpfetbt_oid_seq', 127, true);


--
-- Name: etpparam_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpparam_oid_seq', 29, true);


--
-- Name: etpproac_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpproac_oid_seq', 229, true);


--
-- Name: etpprobf_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprobf_oid_seq', 1120, true);


--
-- Name: etpprobt_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprobt_oid_seq', 338, true);


--
-- Name: etpprofm_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprofm_oid_seq', 4202, true);


--
-- Name: etpprohd_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprohd_oid_seq', 158, true);


--
-- Name: etpprort_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprort_oid_seq', 435, true);


--
-- Name: etpprotp_oid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.etpprotp_oid_seq', 303, true);


--
-- Name: etp_log etp_log_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etp_log
    ADD CONSTRAINT etp_log_pkey PRIMARY KEY (logoid);


--
-- Name: etpconfig etpconfig_option_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpconfig
    ADD CONSTRAINT etpconfig_option_name_key UNIQUE (option_name);


--
-- Name: etpconfig etpconfig_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpconfig
    ADD CONSTRAINT etpconfig_pkey PRIMARY KEY (oid);


--
-- Name: etpfetbt etpfetbt_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpfetbt
    ADD CONSTRAINT etpfetbt_pkey PRIMARY KEY (oid);


--
-- Name: etpfetrq etpfetrq_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpfetrq
    ADD CONSTRAINT etpfetrq_pkey PRIMARY KEY (oid);


--
-- Name: etpfetrt etpfetrt_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpfetrt
    ADD CONSTRAINT etpfetrt_pkey PRIMARY KEY (oid);


--
-- Name: etppaclog etppaclog_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etppaclog
    ADD CONSTRAINT etppaclog_pkey PRIMARY KEY (oid);


--
-- Name: etpparam etpparam_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpparam
    ADD CONSTRAINT etpparam_pkey PRIMARY KEY (oid);


--
-- Name: etpproac etpproac_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpproac
    ADD CONSTRAINT etpproac_pkey PRIMARY KEY (oid);


--
-- Name: etpprobf etpprobf_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprobf
    ADD CONSTRAINT etpprobf_pkey PRIMARY KEY (oid);


--
-- Name: etpprobt etpprobt_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprobt
    ADD CONSTRAINT etpprobt_pkey PRIMARY KEY (oid);


--
-- Name: etpprofm etpprofm_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprofm
    ADD CONSTRAINT etpprofm_pkey PRIMARY KEY (oid);


--
-- Name: etpprohd etpprohd_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprohd
    ADD CONSTRAINT etpprohd_pkey PRIMARY KEY (oid);


--
-- Name: etpprorq etpprorq_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprorq
    ADD CONSTRAINT etpprorq_pkey PRIMARY KEY (oid);


--
-- Name: etpprort etpprort_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprort
    ADD CONSTRAINT etpprort_pkey PRIMARY KEY (oid);


--
-- Name: etpprosr etpprosr_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprosr
    ADD CONSTRAINT etpprosr_pkey PRIMARY KEY (oid);


--
-- Name: etpprotp etpprotp_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etpprotp
    ADD CONSTRAINT etpprotp_pkey PRIMARY KEY (oid);


--
-- Name: etppaclog idx_batchnum_oid; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.etppaclog
    ADD CONSTRAINT idx_batchnum_oid UNIQUE (batchnumber, oid);


--
-- Name: etpparam etpparam_change_trigger; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER etpparam_change_trigger AFTER INSERT OR DELETE OR UPDATE ON public.etpparam FOR EACH ROW EXECUTE FUNCTION public.log_etpparam_changes();


--
-- PostgreSQL database dump complete
--

