@echo off
:: SetupTriggerSystem_Auto.bat
:: Installs the automatic PRQ trigger function and attaches it to the configured table

set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs

IF NOT EXIST "%LOG_PATH%" (
    mkdir "%LOG_PATH%"
)

:: Step 1: Create the trigger function
echo [SetupTriggerSystem_Auto] Creating automatic trigger function...
psql -U %PGUSER% -h %PGHOST% -d %PGDATABASE% -f "%SQL_PATH%\\CreateTriggerInsertPRQFunction_Auto.sql" > "%LOG_PATH%\\CreateTriggerInsertPRQFunction_Auto.log" 2>&1

IF %ERRORLEVEL% NEQ 0 (
    echo [SetupTriggerSystem_Auto] ERROR: Function creation failed. Check %LOG_PATH%\\CreateTriggerInsertPRQFunction_Auto.log
    pause
    exit /b 1
)

:: Step 2: Attach the trigger to the source table
echo [SetupTriggerSystem_Auto] Attaching trigger to source table...
psql -U %PGUSER% -h %PGHOST% -d %PGDATABASE% -f "%SQL_PATH%\\AttachInsertPRQTrigger_Auto.sql" > "%LOG_PATH%\\AttachInsertPRQTrigger_Auto.log" 2>&1

IF %ERRORLEVEL% NEQ 0 (
    echo [SetupTriggerSystem_Auto] ERROR: Trigger attachment failed. Check %LOG_PATH%\\AttachInsertPRQTrigger_Auto.log
    pause
    exit /b 1
)

echo [SetupTriggerSystem_Auto] Automatic PRQ trigger system installed successfully.
pause
