:: StartFlushBuffered.bat
:: Purpose: Executes FlushBufferedToPRQ.sql to move ETPProBf to ETPProRq and create ETPProBt record
:: Version: TriggerBuffered_v250508a, 2025-07-08
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs
set PSQL="C:\Program Files\PostgreSQL\16\bin\psql.exe"

:: Log start
echo %DATE% %TIME% Flushing ETPProBf to ETPProRq... >> "%LOG_PATH%\StartFlushBuffered.log"

:: Run FlushBufferedToPRQ.sql
%PSQL% -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -f "%SQL_PATH%\FlushBufferedToPRQ.sql" >> "%LOG_PATH%\StartFlushBuffered.log" 2>&1
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Error executing FlushBufferedToPRQ.sql. Check %LOG_PATH%\StartFlushBuffered.log and etp_log table. Exiting. >> "%LOG_PATH%\StartFlushBuffered.log"
    exit /b 1
)

echo %DATE% %TIME% Flush completed successfully. >> "%LOG_PATH%\StartFlushBuffered.log"
