:: StartProcessing.bat
:: Purpose: Initiates triggered mode processing, claims batch, processes ETPProRq to ETPProRt, and finalizes
:: Version: TriggerBuffered_v250713f, 2025-07-13
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs
set PSQL="C:\Program Files\PostgreSQL\16\bin\psql.exe"

:: Ensure LOG_PATH exists
if not exist "%LOG_PATH%" (
    echo %DATE% %TIME% Error: LOG_PATH %LOG_PATH% does not exist. Creating... >> "%LOG_PATH%\StartProcessing.log"
    mkdir "%LOG_PATH%"
    if %ERRORLEVEL% neq 0 (
        echo %DATE% %TIME% Error: Failed to create LOG_PATH %LOG_PATH%. Exiting. >> "%LOG_PATH%\StartProcessing.log"
        pause
        exit /b 1
    )
)

:: Log start
echo %DATE% %TIME% Starting ETP/CTP Trigger Mode Protection Batch Processing >> "%LOG_PATH%\StartProcessing.log"

:: Step 1: Claim and detect Ready batch
set FOUND_BATCH=
call %PSQL% -U %PGUSER% -h %PGHOST% -p %PGPORT% -d %PGDATABASE% -t -f "%SQL_PATH%\ClaimBatch_ReturnBatchNumber.sql" > "%TEMP%\active_batch.txt" 2>> "%LOG_PATH%\StartProcessing.log"
for /f "tokens=1" %%B in ('findstr /R "^[ ]*[0-9][0-9]*" "%TEMP%\active_batch.txt"') do (
    set FOUND_BATCH=%%B
)
if not defined FOUND_BATCH (
    echo %DATE% %TIME% No Ready batch was found or claimed. Waiting... >> "%LOG_PATH%\StartProcessing.log"
    timeout /t 5 >nul
    pause
    exit /b 0
)
echo %DATE% %TIME% Processing batch detected: %FOUND_BATCH% >> "%LOG_PATH%\StartProcessing.log"

:: Step 2: Process ETPProRq to ETPProRt
echo %DATE% %TIME% Running PBatch3.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch3.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Error in PBatch3.bat (ERRORLEVEL: %ERRORLEVEL%). Exiting. >> "%LOG_PATH%\StartProcessing.log"
    pause
    exit /b 1
)

:: Step 3: Verify ETPProRt
echo %DATE% %TIME% Running PBatch4.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch4.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Error in PBatch4.bat (ERRORLEVEL: %ERRORLEVEL%). Exiting. >> "%LOG_PATH%\StartProcessing.log"
    pause
    exit /b 1
)

:: Step 4: Populate ETPProTp with masking rules
echo %DATE% %TIME% Running PBatch6.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch6.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Warning: Error in PBatch6.bat (ERRORLEVEL: %ERRORLEVEL%). Continuing. >> "%LOG_PATH%\StartProcessing.log"
)

:: Step 5: Update ETPProBt
echo %DATE% %TIME% Running PBatch7.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch7.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Warning: Error in PBatch7.bat (ERRORLEVEL: %ERRORLEVEL%). Continuing. >> "%LOG_PATH%\StartProcessing.log"
)

:: Step 6: Apply masking to source table
echo %DATE% %TIME% Running PBatch8.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch8.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Warning: Error in PBatch8.bat (ERRORLEVEL: %ERRORLEVEL%). Continuing. >> "%LOG_PATH%\StartProcessing.log"
)

:: Step 7: Populate ETPProAc
echo %DATE% %TIME% Running PBatch9.bat... >> "%LOG_PATH%\StartProcessing.log"
call .\PBatch9.bat
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% Warning: Error in PBatch9.bat (ERRORLEVEL: %ERRORLEVEL%). Continuing. >> "%LOG_PATH%\StartProcessing.log"
)

:: Log completion
echo %DATE% %TIME% CTP/ETP Trigger Mode protection processing complete! >> "%LOG_PATH%\StartProcessing.log"
pause