-- TriggerDiagnostic.sql
-- Check trigger setup, config flags, header integrity, and buffered inserts

-- 1. Verify that the trigger exists on the 'patients' table
SELECT 
    tgname AS trigger_name, 
    relname AS table_name,
    tgenabled
FROM pg_trigger 
JOIN pg_class ON pg_trigger.tgrelid = pg_class.oid
WHERE tgname = 'trigger_insert_prq' AND relname = 'patients';

-- 2. Check whether trigger mode and buffer mode are enabled
SELECT * FROM etpconfig 
WHERE option_name IN ('TriggerEnabled', 'BufferMode');

-- 3. Verify header information (should match current test source table)
SELECT dbtablename, uniquesourcecolumn 
FROM etpprohd;

-- 4. Show recent buffered records
SELECT * FROM etpprobf 
ORDER BY importid DESC 
LIMIT 5;
