:: TriggerProc.bat
:: Purpose: Initiates triggered mode processing, claims batch, processes ETPProRq to ETPProRt, and finalizes
:: Version: TriggerBuffered_v251004, 2025-10-04 (Fixed batch capture and path usage)
@echo off
set PGUSER=postgres
set PGPASSWORD=sa
set PGDATABASE=postgres
set PGHOST=localhost
set PGPORT=5432
set SQL_PATH=C:\ETP_A_26\PBatch
set LOG_PATH=C:\ETP_A_26\Logs
:: Log start to etp_log and TriggerProc.log
echo %DATE% %TIME% Starting TriggerProc.bat... >> "%LOG_PATH%\TriggerProc.log"
psql -d %PGDATABASE% -h %PGHOST% -p %PGPORT% -U %PGUSER% -c "INSERT INTO etp_log (log_time, log_message) VALUES (TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), 'TriggerProc.bat: Starting ETP/CTP Trigger Mode Processing. StartTime: ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'));" >> "%LOG_PATH%\TriggerProc.log" 2>&1
:: Detect Processing batch
echo %DATE% %TIME% Running PBatch3.bat... >> "%LOG_PATH%\TriggerProc.log"
call "%SQL_PATH%\PBatch3.bat"
:: Verify ETPProRt
echo %DATE% %TIME% Running PBatch4.bat... >> "%LOG_PATH%\TriggerProc.log"
call "%SQL_PATH%\PBatch4.bat"
:: Populate ETPProTp with masking rules: NOW DONE IN INIT
:: echo %DATE% %TIME% Running PBatch6.bat... >> "%LOG_PATH%\TriggerProc.log"
:: call "%SQL_PATH%\PBatch6.bat"
:: Update ETPProBt
:: echo %DATE% %TIME% Running PBatch7.bat... >> "%LOG_PATH%\TriggerProc.log"
:: call "%SQL_PATH%\PBatch7.bat"
:: Apply masking to source table
:: echo %DATE% %TIME% Running PBatch8.bat... >> "%LOG_PATH%\TriggerProc.log"
:: call "%SQL_PATH%\PBatch8.bat"
:: Populate ETPProAc
:: echo %DATE% %TIME% Running PBatch9.bat... >> "%LOG_PATH%\TriggerProc.log"
:: call "%SQL_PATH%\PBatch9.bat"
:: Log completion to etp_log and TriggerProc.log

echo %DATE% %TIME% Running PBatch789.bat... >> "%LOG_PATH%\TriggerProc.log"
call "%SQL_PATH%\PBatch789.bat"

