@echo off
:: ZIP_StableRelease.bat – Create archive of Trigger Buffered v250508a

set BASE_DIR=C:\ETP_A_26\PBatch
set VERSION=TriggerBuffered_v250508a
set RELEASE_DIR=%BASE_DIR%\StableRelease\%VERSION%
set LOG_DIR=C:\ETP_A_26\Logs

:: Create release directory
if not exist "%RELEASE_DIR%" (
    mkdir "%RELEASE_DIR%"
)

echo Copying core files to archive...

:: Core files
copy /Y "%BASE_DIR%\StartProcessing.bat" "%RELEASE_DIR%\StartProcessing.bat"
copy /Y "%BASE_DIR%\FlushBufferedToPRQ.sql" "%RELEASE_DIR%\FlushBufferedToPRQ.sql"
copy /Y "%BASE_DIR%\ClaimBatch_ReturnBatchNumber.sql" "%RELEASE_DIR%\ClaimBatch_ReturnBatchNumber.sql"

:: Optional: Copy final versions of PBatch2–PBatch9
for %%F in (2 3 4 5 6 7 8 9) do (
    if exist "%BASE_DIR%\PBatch%%F.sql" copy /Y "%BASE_DIR%\PBatch%%F.sql" "%RELEASE_DIR%\PBatch%%F.sql"
)

:: Optional: Copy current logs
echo Copying logs (if any)...
if exist "%LOG_DIR%" (
    xcopy /Y /S "%LOG_DIR%\*" "%RELEASE_DIR%\Logs\" >nul
)

echo Done! Stable release created at:
echo   %RELEASE_DIR%
pause
